/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.util.Assert;
import javax.annotation.Nullable;

public final class DeleteMutation
extends Mutation {
    public DeleteMutation(DocumentKey key, Precondition precondition) {
        super(key, precondition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteMutation that = (DeleteMutation)o;
        return this.hasSameKeyAndPrecondition(that);
    }

    public int hashCode() {
        return this.keyAndPreconditionHashCode();
    }

    public String toString() {
        return "DeleteMutation{" + this.keyAndPreconditionToString() + "}";
    }

    @Override
    public MaybeDocument applyToRemoteDocument(@Nullable MaybeDocument maybeDoc, MutationResult mutationResult) {
        this.verifyKeyMatches(maybeDoc);
        Assert.hardAssert(mutationResult.getTransformResults() == null, "Transform results received by DeleteMutation.", new Object[0]);
        return new NoDocument(this.getKey(), mutationResult.getVersion(), true);
    }

    @Override
    @Nullable
    public MaybeDocument applyToLocalView(@Nullable MaybeDocument maybeDoc, @Nullable MaybeDocument baseDoc, Timestamp localWriteTime) {
        this.verifyKeyMatches(maybeDoc);
        if (!this.getPrecondition().isValidFor(maybeDoc)) {
            return maybeDoc;
        }
        return new NoDocument(this.getKey(), SnapshotVersion.NONE, false);
    }

    @Override
    @Nullable
    public FieldMask getFieldMask() {
        return null;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }
}

