/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.model.value.DoubleValue;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.IntegerValue;
import com.google.firebase.firestore.model.value.NumberValue;
import com.google.firebase.firestore.util.Assert;

public class NumericIncrementTransformOperation
implements TransformOperation {
    private NumberValue operand;

    public NumericIncrementTransformOperation(NumberValue operand) {
        this.operand = operand;
    }

    @Override
    public FieldValue applyToLocalView(FieldValue previousValue, Timestamp localWriteTime) {
        if (previousValue instanceof IntegerValue && this.operand instanceof IntegerValue) {
            long sum = this.safeIncrement(((IntegerValue)previousValue).getInternalValue(), this.operandAsLong());
            return IntegerValue.valueOf(sum);
        }
        if (previousValue instanceof IntegerValue) {
            double sum = (double)((IntegerValue)previousValue).getInternalValue() + this.operandAsDouble();
            return DoubleValue.valueOf(sum);
        }
        if (previousValue instanceof DoubleValue) {
            double sum = ((DoubleValue)previousValue).getInternalValue() + this.operandAsDouble();
            return DoubleValue.valueOf(sum);
        }
        return this.operand;
    }

    private long safeIncrement(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) >= 0L) {
            return r;
        }
        if (r >= 0L) {
            return Long.MIN_VALUE;
        }
        return Long.MAX_VALUE;
    }

    private double operandAsDouble() {
        if (this.operand instanceof DoubleValue) {
            return ((DoubleValue)this.operand).getInternalValue();
        }
        if (this.operand instanceof IntegerValue) {
            return ((IntegerValue)this.operand).getInternalValue();
        }
        throw Assert.fail("Expected 'operand' to be of Number type, but was " + this.operand.getClass().getCanonicalName(), new Object[0]);
    }

    private long operandAsLong() {
        if (this.operand instanceof DoubleValue) {
            return (long)((DoubleValue)this.operand).getInternalValue();
        }
        if (this.operand instanceof IntegerValue) {
            return ((IntegerValue)this.operand).getInternalValue();
        }
        throw Assert.fail("Expected 'operand' to be of Number type, but was " + this.operand.getClass().getCanonicalName(), new Object[0]);
    }

    @Override
    public FieldValue applyToRemoteDocument(FieldValue previousValue, FieldValue transformResult) {
        return transformResult;
    }

    public FieldValue getOperand() {
        return this.operand;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }
}

