/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.UnknownDocument;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public final class TransformMutation
extends Mutation {
    private final List<FieldTransform> fieldTransforms;

    public TransformMutation(DocumentKey key, List<FieldTransform> fieldTransforms) {
        super(key, Precondition.exists(true));
        this.fieldTransforms = fieldTransforms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformMutation that = (TransformMutation)o;
        return this.hasSameKeyAndPrecondition(that) && this.fieldTransforms.equals(that.fieldTransforms);
    }

    public int hashCode() {
        int result = this.keyAndPreconditionHashCode();
        result = 31 * result + this.fieldTransforms.hashCode();
        return result;
    }

    public String toString() {
        return "TransformMutation{" + this.keyAndPreconditionToString() + ", fieldTransforms=" + this.fieldTransforms + "}";
    }

    public List<FieldTransform> getFieldTransforms() {
        return this.fieldTransforms;
    }

    @Override
    public MaybeDocument applyToRemoteDocument(@Nullable MaybeDocument maybeDoc, MutationResult mutationResult) {
        this.verifyKeyMatches(maybeDoc);
        Assert.hardAssert(mutationResult.getTransformResults() != null, "Transform results missing for TransformMutation.", new Object[0]);
        if (!this.getPrecondition().isValidFor(maybeDoc)) {
            return new UnknownDocument(this.getKey(), mutationResult.getVersion());
        }
        Document doc = this.requireDocument(maybeDoc);
        List<FieldValue> transformResults = this.serverTransformResults(doc, mutationResult.getTransformResults());
        ObjectValue newData = this.transformObject(doc.getData(), transformResults);
        return new Document(this.getKey(), mutationResult.getVersion(), newData, Document.DocumentState.COMMITTED_MUTATIONS);
    }

    @Override
    @Nullable
    public MaybeDocument applyToLocalView(@Nullable MaybeDocument maybeDoc, @Nullable MaybeDocument baseDoc, Timestamp localWriteTime) {
        this.verifyKeyMatches(maybeDoc);
        if (!this.getPrecondition().isValidFor(maybeDoc)) {
            return maybeDoc;
        }
        Document doc = this.requireDocument(maybeDoc);
        List<FieldValue> transformResults = this.localTransformResults(localWriteTime, baseDoc);
        ObjectValue newData = this.transformObject(doc.getData(), transformResults);
        return new Document(this.getKey(), doc.getVersion(), newData, Document.DocumentState.LOCAL_MUTATIONS);
    }

    @Override
    public FieldMask getFieldMask() {
        HashSet<FieldPath> fieldMask = new HashSet<FieldPath>();
        for (FieldTransform transform : this.fieldTransforms) {
            fieldMask.add(transform.getFieldPath());
        }
        return FieldMask.fromSet(fieldMask);
    }

    @Override
    public boolean isIdempotent() {
        for (FieldTransform transform : this.fieldTransforms) {
            if (transform.isIdempotent()) continue;
            return false;
        }
        return true;
    }

    private Document requireDocument(@Nullable MaybeDocument maybeDoc) {
        Assert.hardAssert(maybeDoc instanceof Document, "Unknown MaybeDocument type %s", maybeDoc);
        Document doc = (Document)maybeDoc;
        Assert.hardAssert(doc.getKey().equals(this.getKey()), "Can only transform a document with the same key", new Object[0]);
        return doc;
    }

    private List<FieldValue> serverTransformResults(@Nullable MaybeDocument baseDoc, List<FieldValue> serverTransformResults) {
        ArrayList<FieldValue> transformResults = new ArrayList<FieldValue>(this.fieldTransforms.size());
        Assert.hardAssert(this.fieldTransforms.size() == serverTransformResults.size(), "server transform count (%d) should match field transform count (%d)", serverTransformResults.size(), this.fieldTransforms.size());
        for (int i = 0; i < serverTransformResults.size(); ++i) {
            FieldTransform fieldTransform = this.fieldTransforms.get(i);
            TransformOperation transform = fieldTransform.getOperation();
            FieldValue previousValue = null;
            if (baseDoc instanceof Document) {
                previousValue = ((Document)baseDoc).getField(fieldTransform.getFieldPath());
            }
            transformResults.add(transform.applyToRemoteDocument(previousValue, serverTransformResults.get(i)));
        }
        return transformResults;
    }

    private List<FieldValue> localTransformResults(Timestamp localWriteTime, @Nullable MaybeDocument baseDoc) {
        ArrayList<FieldValue> transformResults = new ArrayList<FieldValue>(this.fieldTransforms.size());
        for (FieldTransform fieldTransform : this.fieldTransforms) {
            TransformOperation transform = fieldTransform.getOperation();
            FieldValue previousValue = null;
            if (baseDoc instanceof Document) {
                previousValue = ((Document)baseDoc).getField(fieldTransform.getFieldPath());
            }
            transformResults.add(transform.applyToLocalView(previousValue, localWriteTime));
        }
        return transformResults;
    }

    private ObjectValue transformObject(ObjectValue objectValue, List<FieldValue> transformResults) {
        Assert.hardAssert(transformResults.size() == this.fieldTransforms.size(), "Transform results length mismatch.", new Object[0]);
        for (int i = 0; i < this.fieldTransforms.size(); ++i) {
            FieldTransform fieldTransform = this.fieldTransforms.get(i);
            FieldPath fieldPath = fieldTransform.getFieldPath();
            objectValue = objectValue.set(fieldPath, transformResults.get(i));
        }
        return objectValue;
    }
}

