/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.remote.FirestoreCallCredentials;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.IncomingStreamObserver;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import com.google.firestore.v1.FirestoreGrpc;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FirestoreChannel {
    private static final Metadata.Key<String> X_GOOG_API_CLIENT_HEADER = Metadata.Key.of((String)"x-goog-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> RESOURCE_PREFIX_HEADER = Metadata.Key.of((String)"google-cloud-resource-prefix", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String X_GOOG_API_CLIENT_VALUE = "gl-java/ fire/19.0.2 grpc/";
    private final AsyncQueue asyncQueue;
    private final CredentialsProvider credentialsProvider;
    private final ManagedChannel channel;
    private final CallOptions callOptions;
    private final String resourcePrefixValue;

    public FirestoreChannel(AsyncQueue asyncQueue, CredentialsProvider credentialsProvider, ManagedChannel grpcChannel, DatabaseId databaseId) {
        this.asyncQueue = asyncQueue;
        this.credentialsProvider = credentialsProvider;
        FirestoreCallCredentials firestoreHeaders = new FirestoreCallCredentials(credentialsProvider);
        FirestoreGrpc.FirestoreStub firestoreStub = (FirestoreGrpc.FirestoreStub)FirestoreGrpc.newStub((Channel)grpcChannel).withCallCredentials((CallCredentials)firestoreHeaders);
        this.channel = grpcChannel;
        this.callOptions = firestoreStub.getCallOptions();
        this.resourcePrefixValue = String.format("projects/%s/databases/%s", databaseId.getProjectId(), databaseId.getDatabaseId());
    }

    public void shutdown() {
        this.channel.shutdown();
        try {
            if (!this.channel.awaitTermination(1L, TimeUnit.SECONDS)) {
                Logger.debug(FirestoreChannel.class.getSimpleName(), "Unable to gracefully shutdown the gRPC ManagedChannel. Will attempt an immediate shutdown.", new Object[0]);
                this.channel.shutdownNow();
                if (!this.channel.awaitTermination(60L, TimeUnit.SECONDS)) {
                    Logger.warn(FirestoreChannel.class.getSimpleName(), "Unable to forcefully shutdown the gRPC ManagedChannel.", new Object[0]);
                }
            }
        }
        catch (InterruptedException e) {
            this.channel.shutdownNow();
            Logger.warn(FirestoreChannel.class.getSimpleName(), "Interrupted while shutting down the gRPC Managed Channel", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> runBidiStreamingRpc(MethodDescriptor<ReqT, RespT> method, final IncomingStreamObserver<RespT> observer) {
        final ClientCall call = this.channel.newCall(method, this.callOptions);
        call.start(new ClientCall.Listener<RespT>(){

            public void onHeaders(Metadata headers) {
                try {
                    observer.onHeaders(headers);
                }
                catch (Throwable t) {
                    FirestoreChannel.this.asyncQueue.panic(t);
                }
            }

            public void onMessage(RespT message) {
                try {
                    observer.onNext(message);
                    call.request(1);
                }
                catch (Throwable t) {
                    FirestoreChannel.this.asyncQueue.panic(t);
                }
            }

            public void onClose(Status status, Metadata trailers) {
                try {
                    observer.onClose(status);
                }
                catch (Throwable t) {
                    FirestoreChannel.this.asyncQueue.panic(t);
                }
            }

            public void onReady() {
                try {
                    observer.onReady();
                }
                catch (Throwable t) {
                    FirestoreChannel.this.asyncQueue.panic(t);
                }
            }
        }, this.requestHeaders());
        call.request(1);
        return call;
    }

    public <ReqT, RespT> Task<List<RespT>> runStreamingResponseRpc(MethodDescriptor<ReqT, RespT> method, ReqT request) {
        final TaskCompletionSource tcs = new TaskCompletionSource();
        final ClientCall call = this.channel.newCall(method, this.callOptions);
        final ArrayList results = new ArrayList();
        call.start(new ClientCall.Listener<RespT>(){

            public void onMessage(RespT message) {
                results.add(message);
                call.request(1);
            }

            public void onClose(Status status, Metadata trailers) {
                if (status.isOk()) {
                    tcs.setResult((Object)results);
                } else {
                    tcs.setException((Exception)((Object)Util.exceptionFromStatus(status)));
                }
            }
        }, this.requestHeaders());
        call.request(1);
        call.sendMessage(request);
        call.halfClose();
        return tcs.getTask();
    }

    public <ReqT, RespT> Task<RespT> runRpc(MethodDescriptor<ReqT, RespT> method, ReqT request) {
        final TaskCompletionSource tcs = new TaskCompletionSource();
        ClientCall call = this.channel.newCall(method, this.callOptions);
        call.start(new ClientCall.Listener<RespT>(){

            public void onMessage(RespT message) {
                tcs.setResult(message);
            }

            public void onClose(Status status, Metadata trailers) {
                if (status.isOk()) {
                    if (!tcs.getTask().isComplete()) {
                        tcs.setException((Exception)((Object)new FirebaseFirestoreException("Received onClose with status OK, but no message.", FirebaseFirestoreException.Code.INTERNAL)));
                    }
                } else {
                    tcs.setException((Exception)((Object)Util.exceptionFromStatus(status)));
                }
            }
        }, this.requestHeaders());
        call.request(2);
        call.sendMessage(request);
        call.halfClose();
        return tcs.getTask();
    }

    public void invalidateToken() {
        this.credentialsProvider.invalidateToken();
    }

    private Metadata requestHeaders() {
        Metadata headers = new Metadata();
        headers.put(X_GOOG_API_CLIENT_HEADER, (Object)X_GOOG_API_CLIENT_VALUE);
        headers.put(RESOURCE_PREFIX_HEADER, (Object)this.resourcePrefixValue);
        return headers;
    }
}

