/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.QueryDocumentSnapshot;
import com.google.firebase.firestore.core.DocumentViewChange;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentSet;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@PublicApi
public class DocumentChange {
    private final Type type;
    private final QueryDocumentSnapshot document;
    private final int oldIndex;
    private final int newIndex;

    @VisibleForTesting
    DocumentChange(QueryDocumentSnapshot document, Type type, int oldIndex, int newIndex) {
        this.type = type;
        this.document = document;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof DocumentChange) {
            DocumentChange that = (DocumentChange)object;
            return this.type.equals((Object)that.type) && this.document.equals(that.document) && this.oldIndex == that.oldIndex && this.newIndex == that.newIndex;
        }
        return false;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.document.hashCode();
        result = result * 31 + this.oldIndex;
        result = result * 31 + this.newIndex;
        return result;
    }

    @NonNull
    @PublicApi
    public Type getType() {
        return this.type;
    }

    @NonNull
    @PublicApi
    public QueryDocumentSnapshot getDocument() {
        return this.document;
    }

    @PublicApi
    public int getOldIndex() {
        return this.oldIndex;
    }

    @PublicApi
    public int getNewIndex() {
        return this.newIndex;
    }

    static List<DocumentChange> changesFromSnapshot(FirebaseFirestore firestore, MetadataChanges metadataChanges, ViewSnapshot snapshot) {
        ArrayList<DocumentChange> documentChanges = new ArrayList<DocumentChange>();
        if (snapshot.getOldDocuments().isEmpty()) {
            int index = 0;
            Document lastDoc = null;
            for (DocumentViewChange change : snapshot.getChanges()) {
                Document document = change.getDocument();
                QueryDocumentSnapshot documentSnapshot = QueryDocumentSnapshot.fromDocument(firestore, document, snapshot.isFromCache(), snapshot.getMutatedKeys().contains((Object)document.getKey()));
                Assert.hardAssert(change.getType() == DocumentViewChange.Type.ADDED, "Invalid added event for first snapshot", new Object[0]);
                Assert.hardAssert(lastDoc == null || snapshot.getQuery().comparator().compare(lastDoc, document) < 0, "Got added events in wrong order", new Object[0]);
                documentChanges.add(new DocumentChange(documentSnapshot, Type.ADDED, -1, index++));
                lastDoc = document;
            }
        } else {
            DocumentSet indexTracker = snapshot.getOldDocuments();
            for (DocumentViewChange change : snapshot.getChanges()) {
                int newIndex;
                int oldIndex;
                if (metadataChanges == MetadataChanges.EXCLUDE && change.getType() == DocumentViewChange.Type.METADATA) continue;
                Document document = change.getDocument();
                QueryDocumentSnapshot documentSnapshot = QueryDocumentSnapshot.fromDocument(firestore, document, snapshot.isFromCache(), snapshot.getMutatedKeys().contains((Object)document.getKey()));
                Type type = DocumentChange.getType(change);
                if (type != Type.ADDED) {
                    oldIndex = indexTracker.indexOf(document.getKey());
                    Assert.hardAssert(oldIndex >= 0, "Index for document not found", new Object[0]);
                    indexTracker = indexTracker.remove(document.getKey());
                } else {
                    oldIndex = -1;
                }
                if (type != Type.REMOVED) {
                    newIndex = (indexTracker = indexTracker.add(document)).indexOf(document.getKey());
                    Assert.hardAssert(newIndex >= 0, "Index for document not found", new Object[0]);
                } else {
                    newIndex = -1;
                }
                documentChanges.add(new DocumentChange(documentSnapshot, type, oldIndex, newIndex));
            }
        }
        return documentChanges;
    }

    private static Type getType(DocumentViewChange change) {
        switch (change.getType()) {
            case ADDED: {
                return Type.ADDED;
            }
            case METADATA: 
            case MODIFIED: {
                return Type.MODIFIED;
            }
            case REMOVED: {
                return Type.REMOVED;
            }
        }
        throw new IllegalArgumentException("Unknown view change type: " + (Object)((Object)change.getType()));
    }

    @PublicApi
    public static enum Type {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

