/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.util.Assert;
import java.util.List;

public final class Bound {
    private final boolean before;
    private final List<FieldValue> position;

    public Bound(List<FieldValue> position, boolean before) {
        this.position = position;
        this.before = before;
    }

    public List<FieldValue> getPosition() {
        return this.position;
    }

    public boolean isBefore() {
        return this.before;
    }

    public String canonicalString() {
        StringBuilder builder = new StringBuilder();
        if (this.before) {
            builder.append("b:");
        } else {
            builder.append("a:");
        }
        for (FieldValue indexComponent : this.position) {
            builder.append(indexComponent.toString());
        }
        return builder.toString();
    }

    public boolean sortsBeforeDocument(List<OrderBy> orderBy, Document document) {
        Assert.hardAssert(this.position.size() <= orderBy.size(), "Bound has more components than query's orderBy", new Object[0]);
        int comparison = 0;
        for (int i = 0; i < this.position.size(); ++i) {
            OrderBy orderByComponent = orderBy.get(i);
            FieldValue component = this.position.get(i);
            if (orderByComponent.field.equals(FieldPath.KEY_PATH)) {
                Object refValue = component.value();
                Assert.hardAssert(refValue instanceof DocumentKey, "Bound has a non-key value where the key path is being used %s", component);
                comparison = ((DocumentKey)refValue).compareTo(document.getKey());
            } else {
                FieldValue docValue = document.getField(orderByComponent.getField());
                Assert.hardAssert(docValue != null, "Field should exist since document matched the orderBy already.", new Object[0]);
                comparison = component.compareTo(docValue);
            }
            if (orderByComponent.getDirection().equals((Object)OrderBy.Direction.DESCENDING)) {
                comparison *= -1;
            }
            if (comparison != 0) break;
        }
        return this.before ? comparison <= 0 : comparison < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bound bound = (Bound)o;
        return this.before == bound.before && this.position.equals(bound.position);
    }

    public int hashCode() {
        int result = this.before ? 1 : 0;
        result = 31 * result + this.position.hashCode();
        return result;
    }

    public String toString() {
        return "Bound{before=" + this.before + ", position=" + this.position + '}';
    }
}

