/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.ArrayContainsAnyFilter;
import com.google.firebase.firestore.core.ArrayContainsFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.InFilter;
import com.google.firebase.firestore.core.KeyFieldFilter;
import com.google.firebase.firestore.core.KeyFieldInFilter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.ArrayValue;
import com.google.firebase.firestore.model.value.DoubleValue;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.NullValue;
import com.google.firebase.firestore.model.value.ReferenceValue;
import com.google.firebase.firestore.util.Assert;
import java.util.Arrays;

public class FieldFilter
extends Filter {
    private final Filter.Operator operator;
    private final FieldValue value;
    private final FieldPath field;

    protected FieldFilter(FieldPath field, Filter.Operator operator, FieldValue value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public Filter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public FieldPath getField() {
        return this.field;
    }

    public FieldValue getValue() {
        return this.value;
    }

    public static FieldFilter create(FieldPath path, Filter.Operator operator, FieldValue value) {
        if (path.isKeyField()) {
            if (operator == Filter.Operator.IN) {
                Assert.hardAssert(value instanceof ArrayValue, "Comparing on key with IN, but an array value was not a RefValue", new Object[0]);
                return new KeyFieldInFilter(path, (ArrayValue)value);
            }
            Assert.hardAssert(value instanceof ReferenceValue, "Comparing on key, but filter value not a ReferenceValue", new Object[0]);
            Assert.hardAssert(operator != Filter.Operator.ARRAY_CONTAINS && operator != Filter.Operator.ARRAY_CONTAINS_ANY, operator.toString() + "queries don't make sense on document keys", new Object[0]);
            return new KeyFieldFilter(path, operator, (ReferenceValue)value);
        }
        if (value.equals(NullValue.nullValue())) {
            if (operator != Filter.Operator.EQUAL) {
                throw new IllegalArgumentException("Invalid Query. You can only perform equality comparisons on null (via whereEqualTo()).");
            }
            return new FieldFilter(path, operator, value);
        }
        if (value.equals(DoubleValue.NaN)) {
            if (operator != Filter.Operator.EQUAL) {
                throw new IllegalArgumentException("Invalid Query. You can only perform equality comparisons on NaN (via whereEqualTo()).");
            }
            return new FieldFilter(path, operator, value);
        }
        if (operator == Filter.Operator.ARRAY_CONTAINS) {
            return new ArrayContainsFilter(path, value);
        }
        if (operator == Filter.Operator.IN) {
            Assert.hardAssert(value instanceof ArrayValue, "IN filter has invalid value: " + value.toString(), new Object[0]);
            return new InFilter(path, (ArrayValue)value);
        }
        if (operator == Filter.Operator.ARRAY_CONTAINS_ANY) {
            Assert.hardAssert(value instanceof ArrayValue, "ARRAY_CONTAINS_ANY filter has invalid value: " + value.toString(), new Object[0]);
            return new ArrayContainsAnyFilter(path, (ArrayValue)value);
        }
        return new FieldFilter(path, operator, value);
    }

    @Override
    public boolean matches(Document doc) {
        FieldValue other = doc.getField(this.field);
        return other != null && this.value.typeOrder() == other.typeOrder() && this.matchesComparison(other.compareTo(this.value));
    }

    protected boolean matchesComparison(int comp) {
        switch (this.operator) {
            case LESS_THAN: {
                return comp < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return comp <= 0;
            }
            case EQUAL: {
                return comp == 0;
            }
            case GREATER_THAN: {
                return comp > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return comp >= 0;
            }
        }
        throw Assert.fail("Unknown FieldFilter operator: %s", new Object[]{this.operator});
    }

    public boolean isInequality() {
        return Arrays.asList(Filter.Operator.LESS_THAN, Filter.Operator.LESS_THAN_OR_EQUAL, Filter.Operator.GREATER_THAN, Filter.Operator.GREATER_THAN_OR_EQUAL).contains((Object)this.operator);
    }

    @Override
    public String getCanonicalId() {
        return this.getField().canonicalString() + this.getOperator().toString() + this.getValue().toString();
    }

    public String toString() {
        return this.field.canonicalString() + " " + (Object)((Object)this.operator) + " " + this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FieldFilter)) {
            return false;
        }
        FieldFilter other = (FieldFilter)o;
        return this.operator == other.operator && this.field.equals(other.field) && this.value.equals(other.value);
    }

    public int hashCode() {
        int result = 37;
        result = 31 * result + this.operator.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

