/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.ArrayValue;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.ReferenceValue;
import com.google.firebase.firestore.util.Assert;

public class KeyFieldInFilter
extends FieldFilter {
    KeyFieldInFilter(FieldPath field, ArrayValue value) {
        super(field, Filter.Operator.IN, value);
        ArrayValue arrayValue = (ArrayValue)this.getValue();
        for (FieldValue refValue : arrayValue.getInternalValue()) {
            Assert.hardAssert(refValue instanceof ReferenceValue, "Comparing on key with IN, but an array value was not a ReferenceValue", new Object[0]);
        }
    }

    @Override
    public boolean matches(Document doc) {
        ArrayValue arrayValue = (ArrayValue)this.getValue();
        for (FieldValue refValue : arrayValue.getInternalValue()) {
            if (!doc.getKey().equals(((ReferenceValue)refValue).value())) continue;
            return true;
        }
        return false;
    }
}

