/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.IndexRange;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.IndexCursor;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.local.QueryEngine;
import com.google.firebase.firestore.local.SQLiteCollectionIndex;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.value.ArrayValue;
import com.google.firebase.firestore.model.value.BooleanValue;
import com.google.firebase.firestore.model.value.DoubleValue;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.util.Assert;
import java.util.Arrays;
import java.util.List;

public class IndexedQueryEngine
implements QueryEngine {
    private static final double HIGH_SELECTIVITY = 1.0;
    private static final double LOW_SELECTIVITY = 0.5;
    private static final List<Class> lowCardinalityTypes = Arrays.asList(BooleanValue.class, ArrayValue.class, ObjectValue.class);
    private final LocalDocumentsView localDocuments;
    private final SQLiteCollectionIndex collectionIndex;

    public IndexedQueryEngine(LocalDocumentsView localDocuments, SQLiteCollectionIndex collectionIndex) {
        this.localDocuments = localDocuments;
        this.collectionIndex = collectionIndex;
    }

    @Override
    public ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingQuery(Query query) {
        return query.isDocumentQuery() ? this.localDocuments.getDocumentsMatchingQuery(query) : this.performCollectionQuery(query);
    }

    private ImmutableSortedMap<DocumentKey, Document> performCollectionQuery(Query query) {
        ImmutableSortedMap<DocumentKey, Document> filteredResults;
        Assert.hardAssert(!query.isDocumentQuery(), "matchesCollectionQuery() called with document query.", new Object[0]);
        IndexRange indexRange = IndexedQueryEngine.extractBestIndexRange(query);
        if (indexRange != null) {
            filteredResults = this.performQueryUsingIndex(query, indexRange);
        } else {
            Assert.hardAssert(query.getFilters().isEmpty(), "If there are any filters, we should be able to use an index.", new Object[0]);
            filteredResults = this.localDocuments.getDocumentsMatchingQuery(query);
        }
        return filteredResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableSortedMap<DocumentKey, Document> performQueryUsingIndex(Query query, IndexRange indexRange) {
        ImmutableSortedMap results = DocumentCollections.emptyDocumentMap();
        IndexCursor cursor = this.collectionIndex.getCursor(query.getPath(), indexRange);
        try {
            while (cursor.next()) {
                Document document = (Document)this.localDocuments.getDocument(cursor.getDocumentKey());
                if (!query.matches(document)) continue;
                results = results.insert((Object)cursor.getDocumentKey(), (Object)document);
            }
        }
        finally {
            cursor.close();
        }
        return results;
    }

    private static double estimateFilterSelectivity(Filter filter) {
        Assert.hardAssert(filter instanceof FieldFilter, "Filter type expected to be FieldFilter", new Object[0]);
        FieldFilter fieldFilter = (FieldFilter)filter;
        if (fieldFilter.getValue().equals(null) || fieldFilter.getValue().equals(DoubleValue.NaN)) {
            return 1.0;
        }
        double operatorSelectivity = fieldFilter.getOperator().equals((Object)Filter.Operator.EQUAL) ? 1.0 : 0.5;
        double typeSelectivity = lowCardinalityTypes.contains(fieldFilter.getValue().getClass()) ? 0.5 : 1.0;
        return typeSelectivity * operatorSelectivity;
    }

    @Nullable
    @VisibleForTesting
    static IndexRange extractBestIndexRange(Query query) {
        double currentSelectivity = -1.0;
        if (!query.getFilters().isEmpty()) {
            Filter selectedFilter = null;
            for (Filter currentFilter : query.getFilters()) {
                double estimatedSelectivity = IndexedQueryEngine.estimateFilterSelectivity(currentFilter);
                if (!(estimatedSelectivity > currentSelectivity)) continue;
                selectedFilter = currentFilter;
                currentSelectivity = estimatedSelectivity;
            }
            Assert.hardAssert(selectedFilter != null, "Filter should be defined", new Object[0]);
            return IndexedQueryEngine.convertFilterToIndexRange(selectedFilter);
        }
        FieldPath orderPath = query.getOrderBy().get(0).getField();
        if (!orderPath.equals(FieldPath.KEY_PATH)) {
            return IndexRange.builder().setFieldPath(query.getOrderBy().get(0).getField()).build();
        }
        return null;
    }

    private static IndexRange convertFilterToIndexRange(Filter filter) {
        IndexRange.Builder indexRange = IndexRange.builder().setFieldPath(filter.getField());
        if (filter instanceof FieldFilter) {
            FieldFilter fieldFilter = (FieldFilter)filter;
            FieldValue filterValue = fieldFilter.getValue();
            switch (fieldFilter.getOperator()) {
                case EQUAL: {
                    indexRange.setStart(filterValue).setEnd(filterValue);
                    break;
                }
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: {
                    indexRange.setEnd(filterValue);
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    indexRange.setStart(filterValue);
                    break;
                }
                default: {
                    throw Assert.fail("Unexpected operator in query filter", new Object[0]);
                }
            }
        }
        return indexRange.build();
    }

    @Override
    public void handleDocumentChange(MaybeDocument oldDocument, MaybeDocument newDocument) {
        throw new RuntimeException("Not yet implemented.");
    }
}

