/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Assert;
import javax.annotation.Nullable;

public final class Precondition {
    public static final Precondition NONE = new Precondition(null, null);
    @Nullable
    private final SnapshotVersion updateTime;
    @Nullable
    private final Boolean exists;

    private Precondition(@Nullable SnapshotVersion updateTime, @Nullable Boolean exists) {
        Assert.hardAssert(updateTime == null || exists == null, "Precondition can specify \"exists\" or \"updateTime\" but not both", new Object[0]);
        this.updateTime = updateTime;
        this.exists = exists;
    }

    public static Precondition exists(boolean exists) {
        return new Precondition(null, exists);
    }

    public static Precondition updateTime(SnapshotVersion version) {
        return new Precondition(version, null);
    }

    public boolean isNone() {
        return this.updateTime == null && this.exists == null;
    }

    @Nullable
    public SnapshotVersion getUpdateTime() {
        return this.updateTime;
    }

    @Nullable
    public Boolean getExists() {
        return this.exists;
    }

    public boolean isValidFor(@Nullable MaybeDocument maybeDoc) {
        if (this.updateTime != null) {
            return maybeDoc instanceof Document && maybeDoc.getVersion().equals(this.updateTime);
        }
        if (this.exists != null) {
            return this.exists == maybeDoc instanceof Document;
        }
        Assert.hardAssert(this.isNone(), "Precondition should be empty", new Object[0]);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Precondition that = (Precondition)o;
        if (this.updateTime != null ? !this.updateTime.equals(that.updateTime) : that.updateTime != null) {
            return false;
        }
        return this.exists != null ? this.exists.equals(that.exists) : that.exists == null;
    }

    public int hashCode() {
        int result = this.updateTime != null ? this.updateTime.hashCode() : 0;
        result = 31 * result + (this.exists != null ? this.exists.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.isNone()) {
            return "Precondition{<none>}";
        }
        if (this.updateTime != null) {
            return "Precondition{updateTime=" + this.updateTime + "}";
        }
        if (this.exists != null) {
            return "Precondition{exists=" + this.exists + "}";
        }
        throw Assert.fail("Invalid Precondition", new Object[0]);
    }
}

