/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import com.google.firebase.firestore.model.value.DoubleValue;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.IntegerValue;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Util;

public abstract class NumberValue
extends FieldValue {
    @Override
    public int typeOrder() {
        return 2;
    }

    @Override
    public int compareTo(FieldValue o) {
        if (!(o instanceof NumberValue)) {
            return this.defaultCompareTo(o);
        }
        if (this instanceof DoubleValue) {
            double thisDouble = ((DoubleValue)this).getInternalValue();
            if (o instanceof DoubleValue) {
                return Util.compareDoubles(thisDouble, ((DoubleValue)o).getInternalValue());
            }
            Assert.hardAssert(o instanceof IntegerValue, "Unknown NumberValue: %s", o);
            return Util.compareMixed(thisDouble, ((IntegerValue)o).getInternalValue());
        }
        Assert.hardAssert(this instanceof IntegerValue, "Unknown NumberValue: %s", this);
        long thisLong = ((IntegerValue)this).getInternalValue();
        if (o instanceof IntegerValue) {
            return Util.compareLongs(thisLong, ((IntegerValue)o).getInternalValue());
        }
        Assert.hardAssert(o instanceof DoubleValue, "Unknown NumberValue: %s", o);
        return -1 * Util.compareMixed(((DoubleValue)o).getInternalValue(), thisLong);
    }
}

