/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.value.FieldValue;

public class ReferenceValue
extends FieldValue {
    private final DatabaseId databaseId;
    private final DocumentKey key;

    private ReferenceValue(DatabaseId databaseId, DocumentKey documentKey) {
        this.databaseId = databaseId;
        this.key = documentKey;
    }

    @Override
    public int typeOrder() {
        return 6;
    }

    @Override
    public DocumentKey value() {
        return this.key;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ReferenceValue) {
            ReferenceValue ref = (ReferenceValue)o;
            return this.key.equals(ref.key) && this.databaseId.equals(ref.databaseId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 31;
        result = 31 * result + this.databaseId.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    @Override
    public int compareTo(FieldValue o) {
        if (o instanceof ReferenceValue) {
            ReferenceValue ref = (ReferenceValue)o;
            int cmp = this.databaseId.compareTo(ref.databaseId);
            return cmp != 0 ? cmp : this.key.compareTo(ref.key);
        }
        return this.defaultCompareTo(o);
    }

    public static ReferenceValue valueOf(DatabaseId databaseId, DocumentKey documentKey) {
        return new ReferenceValue(databaseId, documentKey);
    }
}

