/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.firebase.firestore.remote.ConnectivityMonitor;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class AndroidConnectivityMonitor
implements ConnectivityMonitor {
    private final Context context;
    @Nullable
    private final ConnectivityManager connectivityManager;
    @Nullable
    private Runnable unregisterRunnable;
    private final List<Consumer<ConnectivityMonitor.NetworkStatus>> callbacks = new ArrayList<Consumer<ConnectivityMonitor.NetworkStatus>>();

    public AndroidConnectivityMonitor(Context context) {
        Assert.hardAssert(context != null, "Context must be non-null", new Object[0]);
        this.context = context;
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.configureNetworkMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(Consumer<ConnectivityMonitor.NetworkStatus> callback) {
        List<Consumer<ConnectivityMonitor.NetworkStatus>> list = this.callbacks;
        synchronized (list) {
            this.callbacks.add(callback);
        }
    }

    @Override
    public void shutdown() {
        if (this.unregisterRunnable != null) {
            this.unregisterRunnable.run();
            this.unregisterRunnable = null;
        }
    }

    private void configureNetworkMonitoring() {
        if (Build.VERSION.SDK_INT >= 24 && this.connectivityManager != null) {
            final DefaultNetworkCallback defaultNetworkCallback = new DefaultNetworkCallback();
            this.connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)defaultNetworkCallback);
            this.unregisterRunnable = new Runnable(){

                @Override
                public void run() {
                    AndroidConnectivityMonitor.this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)defaultNetworkCallback);
                }
            };
        } else {
            final NetworkReceiver networkReceiver = new NetworkReceiver();
            IntentFilter networkIntentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this.context.registerReceiver((BroadcastReceiver)networkReceiver, networkIntentFilter);
            this.unregisterRunnable = new Runnable(){

                @Override
                public void run() {
                    AndroidConnectivityMonitor.this.context.unregisterReceiver((BroadcastReceiver)networkReceiver);
                }
            };
        }
    }

    private class NetworkReceiver
    extends BroadcastReceiver {
        private boolean isConnected = false;

        private NetworkReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = conn.getActiveNetworkInfo();
            boolean wasConnected = this.isConnected;
            boolean bl = this.isConnected = networkInfo != null && networkInfo.isConnected();
            if (this.isConnected && !wasConnected) {
                List list = AndroidConnectivityMonitor.this.callbacks;
                synchronized (list) {
                    for (Consumer callback : AndroidConnectivityMonitor.this.callbacks) {
                        callback.accept(ConnectivityMonitor.NetworkStatus.REACHABLE);
                    }
                }
            }
            if (!this.isConnected && wasConnected) {
                List list = AndroidConnectivityMonitor.this.callbacks;
                synchronized (list) {
                    for (Consumer callback : AndroidConnectivityMonitor.this.callbacks) {
                        callback.accept(ConnectivityMonitor.NetworkStatus.UNREACHABLE);
                    }
                }
            }
        }
    }

    @TargetApi(value=24)
    private class DefaultNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private DefaultNetworkCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAvailable(Network network) {
            List list = AndroidConnectivityMonitor.this.callbacks;
            synchronized (list) {
                for (Consumer callback : AndroidConnectivityMonitor.this.callbacks) {
                    callback.accept(ConnectivityMonitor.NetworkStatus.REACHABLE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLost(Network network) {
            List list = AndroidConnectivityMonitor.this.callbacks;
            synchronized (list) {
                for (Consumer callback : AndroidConnectivityMonitor.this.callbacks) {
                    callback.accept(ConnectivityMonitor.NetworkStatus.UNREACHABLE);
                }
            }
        }
    }
}

