/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$1;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$2;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$3;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$4;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$5;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$6;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$7;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$8;
import com.google.firebase.firestore.util.AsyncQueue$$Lambda$9;
import com.google.firebase.firestore.util.AsyncQueue$DelayedTask$$Lambda$1;
import com.google.firebase.firestore.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;

public class AsyncQueue {
    private final Thread thread;
    private final ScheduledThreadPoolExecutor executor;
    private final ArrayList<DelayedTask> delayedTasks = new ArrayList();

    public static <TResult> Task<TResult> callTask(Executor executor, Callable<Task<TResult>> task) {
        TaskCompletionSource tcs = new TaskCompletionSource();
        executor.execute(AsyncQueue$$Lambda$1.lambdaFactory$(task, executor, tcs));
        return tcs.getTask();
    }

    public AsyncQueue() {
        DelayedStartFactory threadFactory = new DelayedStartFactory();
        this.thread = Executors.defaultThreadFactory().newThread(threadFactory);
        this.thread.setName("FirestoreWorker");
        this.thread.setDaemon(true);
        this.thread.setUncaughtExceptionHandler(AsyncQueue$$Lambda$2.lambdaFactory$(this));
        this.executor = new ScheduledThreadPoolExecutor(1, threadFactory){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t == null && r instanceof Future) {
                    Future future = (Future)((Object)r);
                    try {
                        if (future.isDone()) {
                            future.get();
                        }
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException ee) {
                        t = ee.getCause();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (t != null) {
                    AsyncQueue.this.panic(t);
                }
            }
        };
        this.executor.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void verifyIsCurrentThread() {
        Thread current = Thread.currentThread();
        if (this.thread != current) {
            throw Assert.fail("We are running on the wrong thread. Expected to be on the AsyncQueue thread %s/%d but was %s/%d", this.thread.getName(), this.thread.getId(), current.getName(), current.getId());
        }
    }

    @CheckReturnValue
    public <T> Task<T> enqueue(Callable<T> task) {
        TaskCompletionSource completionSource = new TaskCompletionSource();
        try {
            this.executor.execute(AsyncQueue$$Lambda$3.lambdaFactory$(completionSource, task));
        }
        catch (RejectedExecutionException e) {
            Logger.warn(AsyncQueue.class.getSimpleName(), "Refused to enqueue task after panic", new Object[0]);
        }
        return completionSource.getTask();
    }

    @CheckReturnValue
    public Task<Void> enqueue(Runnable task) {
        return this.enqueue(AsyncQueue$$Lambda$4.lambdaFactory$(task));
    }

    public void enqueueAndForget(Runnable task) {
        this.enqueue(task);
    }

    public DelayedTask enqueueAfterDelay(TimerId timerId, long delayMs, Runnable task) {
        Assert.hardAssert(!this.containsDelayedTask(timerId), "Attempted to schedule multiple operations with timer id %s.", new Object[]{timerId});
        DelayedTask delayedTask = this.createAndScheduleDelayedTask(timerId, delayMs, task);
        this.delayedTasks.add(delayedTask);
        return delayedTask;
    }

    public void panic(Throwable t) {
        this.executor.shutdownNow();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(AsyncQueue$$Lambda$5.lambdaFactory$(t));
    }

    @VisibleForTesting
    public void runSync(Runnable task) throws InterruptedException {
        Semaphore done = new Semaphore(0);
        Throwable[] t = new Throwable[1];
        this.enqueueAndForget(AsyncQueue$$Lambda$6.lambdaFactory$(task, t, done));
        done.acquire(1);
        if (t[0] != null) {
            throw new RuntimeException("Synchronous task failed", t[0]);
        }
    }

    @VisibleForTesting
    public boolean containsDelayedTask(TimerId timerId) {
        for (DelayedTask delayedTask : this.delayedTasks) {
            if (delayedTask.timerId != timerId) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public void runDelayedTasksUntil(TimerId lastTimerId) throws InterruptedException {
        this.runSync(AsyncQueue$$Lambda$7.lambdaFactory$(this, lastTimerId));
    }

    public void shutdown() {
        this.executor.setCorePoolSize(0);
    }

    private DelayedTask createAndScheduleDelayedTask(TimerId timerId, long delayMs, Runnable task) {
        long targetTimeMs = System.currentTimeMillis() + delayMs;
        DelayedTask delayedTask = new DelayedTask(timerId, targetTimeMs, task);
        delayedTask.start(delayMs);
        return delayedTask;
    }

    private void removeDelayedTask(DelayedTask task) {
        boolean found = this.delayedTasks.remove(task);
        Assert.hardAssert(found, "Delayed task not found.", new Object[0]);
    }

    static /* synthetic */ void lambda$runDelayedTasksUntil$8(AsyncQueue this_, TimerId lastTimerId) {
        Assert.hardAssert(lastTimerId == TimerId.ALL || this_.containsDelayedTask(lastTimerId), "Attempted to run tasks until missing TimerId: %s", new Object[]{lastTimerId});
        Collections.sort(this_.delayedTasks, AsyncQueue$$Lambda$8.lambdaFactory$());
        for (DelayedTask delayedTask : new ArrayList<DelayedTask>(this_.delayedTasks)) {
            delayedTask.skipDelay();
            if (lastTimerId == TimerId.ALL || delayedTask.timerId != lastTimerId) continue;
            break;
        }
    }

    static /* synthetic */ int lambda$runDelayedTasksUntil$7(DelayedTask a, DelayedTask b) {
        return Long.compare(a.targetTimeMs, b.targetTimeMs);
    }

    static /* synthetic */ void lambda$runSync$6(Runnable task, Throwable[] t, Semaphore done) {
        try {
            task.run();
        }
        catch (Throwable throwable) {
            t[0] = throwable;
        }
        done.release();
    }

    static /* synthetic */ void lambda$panic$5(Throwable t) {
        if (t instanceof OutOfMemoryError) {
            OutOfMemoryError error = new OutOfMemoryError("Firestore (20.2.0) ran out of memory. Check your queries to make sure they are not loading an excessive amount of data.");
            error.initCause(t);
            throw error;
        }
        throw new RuntimeException("Internal error in Firestore (20.2.0).", t);
    }

    static /* synthetic */ Void lambda$enqueue$4(Runnable task) throws Exception {
        task.run();
        return null;
    }

    static /* synthetic */ void lambda$enqueue$3(TaskCompletionSource completionSource, Callable task) {
        try {
            completionSource.setResult(task.call());
        }
        catch (Exception e) {
            completionSource.setException(e);
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ void lambda$new$2(AsyncQueue this_, Thread crashingThread, Throwable throwable) {
        this_.panic(throwable);
    }

    static /* synthetic */ void lambda$callTask$1(Callable task, Executor executor, TaskCompletionSource tcs) {
        try {
            ((Task)task.call()).continueWith(executor, AsyncQueue$$Lambda$9.lambdaFactory$(tcs));
        }
        catch (Exception e) {
            tcs.setException(e);
        }
        catch (Throwable t) {
            IllegalStateException e = new IllegalStateException("Unhandled throwable in callTask.", t);
            tcs.setException((Exception)e);
        }
    }

    static /* synthetic */ Void lambda$callTask$0(TaskCompletionSource tcs, Task task1) throws Exception {
        if (task1.isSuccessful()) {
            tcs.setResult(task1.getResult());
        } else {
            tcs.setException(task1.getException());
        }
        return null;
    }

    private class DelayedStartFactory
    implements Runnable,
    ThreadFactory {
        private final CountDownLatch latch = new CountDownLatch(1);
        private Runnable delegate;

        private DelayedStartFactory() {
        }

        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.delegate.run();
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            Assert.hardAssert(this.delegate == null, "Only one thread may be created in an AsyncQueue.", new Object[0]);
            this.delegate = runnable;
            this.latch.countDown();
            return AsyncQueue.this.thread;
        }
    }

    public class DelayedTask {
        private final TimerId timerId;
        private final long targetTimeMs;
        private final Runnable task;
        private ScheduledFuture scheduledFuture;

        private DelayedTask(TimerId timerId, long targetTimeMs, Runnable task) {
            this.timerId = timerId;
            this.targetTimeMs = targetTimeMs;
            this.task = task;
        }

        private void start(long delayMs) {
            this.scheduledFuture = AsyncQueue.this.executor.schedule(AsyncQueue$DelayedTask$$Lambda$1.lambdaFactory$(this), delayMs, TimeUnit.MILLISECONDS);
        }

        void skipDelay() {
            this.handleDelayElapsed();
        }

        public void cancel() {
            AsyncQueue.this.verifyIsCurrentThread();
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.markDone();
            }
        }

        private void handleDelayElapsed() {
            AsyncQueue.this.verifyIsCurrentThread();
            if (this.scheduledFuture != null) {
                this.markDone();
                this.task.run();
            }
        }

        private void markDone() {
            Assert.hardAssert(this.scheduledFuture != null, "Caller should have verified scheduledFuture is non-null.", new Object[0]);
            this.scheduledFuture = null;
            AsyncQueue.this.removeDelayedTask(this);
        }

        static /* synthetic */ void access$lambda$0(DelayedTask delayedTask) {
            delayedTask.handleDelayElapsed();
        }
    }

    public static enum TimerId {
        ALL,
        LISTEN_STREAM_IDLE,
        LISTEN_STREAM_CONNECTION_BACKOFF,
        WRITE_STREAM_IDLE,
        WRITE_STREAM_CONNECTION_BACKOFF,
        ONLINE_STATE_TIMEOUT,
        GARBAGE_COLLECTION;

    }
}

