/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore$$Lambda$1;
import com.google.firebase.firestore.FirebaseFirestore$$Lambda$2;
import com.google.firebase.firestore.FirebaseFirestore$$Lambda$3;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.FirestoreMultiDbComponent;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.UserDataConverter;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.EmptyCredentialsProvider;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.core.FirestoreClient;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class FirebaseFirestore {
    private static final String TAG = "FirebaseFirestore";
    private final Context context;
    private final DatabaseId databaseId;
    private final String persistenceKey;
    private final CredentialsProvider credentialsProvider;
    private final AsyncQueue asyncQueue;
    private final FirebaseApp firebaseApp;
    private final UserDataConverter dataConverter;
    private final InstanceRegistry instanceRegistry;
    private FirebaseFirestoreSettings settings;
    private volatile FirestoreClient client;

    @NonNull
    public static FirebaseFirestore getInstance() {
        FirebaseApp app = FirebaseApp.getInstance();
        if (app == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return FirebaseFirestore.getInstance(app, "(default)");
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp app) {
        return FirebaseFirestore.getInstance(app, "(default)");
    }

    @NonNull
    private static FirebaseFirestore getInstance(@NonNull FirebaseApp app, @NonNull String database) {
        Preconditions.checkNotNull((Object)app, (Object)"Provided FirebaseApp must not be null.");
        FirestoreMultiDbComponent component = (FirestoreMultiDbComponent)app.get(FirestoreMultiDbComponent.class);
        Preconditions.checkNotNull((Object)component, (Object)"Firestore component is not present.");
        return component.get(database);
    }

    @NonNull
    static FirebaseFirestore newInstance(@NonNull Context context, @NonNull FirebaseApp app, @Nullable InternalAuthProvider authProvider, @NonNull String database, @NonNull InstanceRegistry instanceRegistry) {
        CredentialsProvider provider;
        String projectId = app.getOptions().getProjectId();
        if (projectId == null) {
            throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
        }
        DatabaseId databaseId = DatabaseId.forDatabase(projectId, database);
        AsyncQueue queue = new AsyncQueue();
        if (authProvider == null) {
            Logger.debug(TAG, "Firebase Auth not available, falling back to unauthenticated usage.", new Object[0]);
            provider = new EmptyCredentialsProvider();
        } else {
            provider = new FirebaseAuthCredentialsProvider(authProvider);
        }
        String persistenceKey = app.getName();
        FirebaseFirestore firestore = new FirebaseFirestore(context, databaseId, persistenceKey, provider, queue, app, instanceRegistry);
        return firestore;
    }

    @VisibleForTesting
    FirebaseFirestore(Context context, DatabaseId databaseId, String persistenceKey, CredentialsProvider credentialsProvider, AsyncQueue asyncQueue, @Nullable FirebaseApp firebaseApp, InstanceRegistry instanceRegistry) {
        this.context = (Context)Preconditions.checkNotNull((Object)context);
        this.databaseId = (DatabaseId)Preconditions.checkNotNull((Object)((DatabaseId)Preconditions.checkNotNull((Object)databaseId)));
        this.dataConverter = new UserDataConverter(databaseId);
        this.persistenceKey = (String)Preconditions.checkNotNull((Object)persistenceKey);
        this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
        this.asyncQueue = (AsyncQueue)Preconditions.checkNotNull((Object)asyncQueue);
        this.firebaseApp = firebaseApp;
        this.instanceRegistry = instanceRegistry;
        this.settings = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings settings) {
        DatabaseId databaseId = this.databaseId;
        synchronized (databaseId) {
            Preconditions.checkNotNull((Object)settings, (Object)"Provided settings must not be null.");
            if (this.client != null && !this.settings.equals(settings)) {
                throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
            }
            this.settings = settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureClientConfigured() {
        if (this.client != null) {
            return;
        }
        DatabaseId databaseId = this.databaseId;
        synchronized (databaseId) {
            if (this.client != null) {
                return;
            }
            DatabaseInfo databaseInfo = new DatabaseInfo(this.databaseId, this.persistenceKey, this.settings.getHost(), this.settings.isSslEnabled());
            this.client = new FirestoreClient(this.context, databaseInfo, this.settings, this.credentialsProvider, this.asyncQueue);
        }
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.firebaseApp;
    }

    @NonNull
    public CollectionReference collection(@NonNull String collectionPath) {
        Preconditions.checkNotNull((Object)collectionPath, (Object)"Provided collection path must not be null.");
        this.ensureClientConfigured();
        return new CollectionReference(ResourcePath.fromString(collectionPath), this);
    }

    @NonNull
    public DocumentReference document(@NonNull String documentPath) {
        Preconditions.checkNotNull((Object)documentPath, (Object)"Provided document path must not be null.");
        this.ensureClientConfigured();
        return DocumentReference.forPath(ResourcePath.fromString(documentPath), this);
    }

    @NonNull
    public com.google.firebase.firestore.Query collectionGroup(@NonNull String collectionId) {
        Preconditions.checkNotNull((Object)collectionId, (Object)"Provided collection ID must not be null.");
        if (collectionId.contains("/")) {
            throw new IllegalArgumentException(String.format("Invalid collectionId '%s'. Collection IDs must not contain '/'.", collectionId));
        }
        this.ensureClientConfigured();
        return new com.google.firebase.firestore.Query(new Query(ResourcePath.EMPTY, collectionId), this);
    }

    private <ResultT> Task<ResultT> runTransaction(Transaction.Function<ResultT> updateFunction, Executor executor) {
        this.ensureClientConfigured();
        Function wrappedUpdateFunction = FirebaseFirestore$$Lambda$1.lambdaFactory$(this, executor, updateFunction);
        return this.client.transaction(wrappedUpdateFunction, 5);
    }

    @NonNull
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> updateFunction) {
        Preconditions.checkNotNull(updateFunction, (Object)"Provided transaction update function must not be null.");
        return this.runTransaction(updateFunction, Transaction.getDefaultExecutor());
    }

    @NonNull
    public WriteBatch batch() {
        this.ensureClientConfigured();
        return new WriteBatch(this);
    }

    @NonNull
    public Task<Void> runBatch(@NonNull WriteBatch.Function batchFunction) {
        WriteBatch batch = this.batch();
        batchFunction.apply(batch);
        return batch.commit();
    }

    Task<Void> shutdownInternal() {
        this.ensureClientConfigured();
        return this.client.shutdown();
    }

    @VisibleForTesting
    Task<Void> shutdown() {
        this.instanceRegistry.remove(this.getDatabaseId().getDatabaseId());
        return this.shutdownInternal();
    }

    @VisibleForTesting
    AsyncQueue getAsyncQueue() {
        return this.asyncQueue;
    }

    @NonNull
    public Task<Void> enableNetwork() {
        this.ensureClientConfigured();
        return this.client.enableNetwork();
    }

    @NonNull
    public Task<Void> disableNetwork() {
        this.ensureClientConfigured();
        return this.client.disableNetwork();
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        if (loggingEnabled) {
            Logger.setLogLevel(Logger.Level.DEBUG);
        } else {
            Logger.setLogLevel(Logger.Level.WARN);
        }
    }

    @NonNull
    public Task<Void> clearPersistence() {
        TaskCompletionSource source = new TaskCompletionSource();
        this.asyncQueue.enqueueAndForgetEvenAfterShutdown(FirebaseFirestore$$Lambda$2.lambdaFactory$(this, source));
        return source.getTask();
    }

    FirestoreClient getClient() {
        return this.client;
    }

    DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    UserDataConverter getDataConverter() {
        return this.dataConverter;
    }

    void validateReference(DocumentReference docRef) {
        Preconditions.checkNotNull((Object)docRef, (Object)"Provided DocumentReference must not be null.");
        if (docRef.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Cloud Firestore instance.");
        }
    }

    static /* synthetic */ void lambda$clearPersistence$2(FirebaseFirestore this_, TaskCompletionSource source) {
        try {
            if (this_.client != null && !this_.client.isShutdown()) {
                throw new FirebaseFirestoreException("Persistence cannot be cleared while the firestore instance is running.", FirebaseFirestoreException.Code.FAILED_PRECONDITION);
            }
            SQLitePersistence.clearPersistence(this_.context, this_.databaseId, this_.persistenceKey);
            source.setResult(null);
        }
        catch (FirebaseFirestoreException e) {
            source.setException((Exception)((Object)e));
        }
    }

    static /* synthetic */ Task lambda$runTransaction$1(FirebaseFirestore this_, Executor executor, Transaction.Function updateFunction, Transaction internalTransaction) {
        return Tasks.call((Executor)executor, (Callable)FirebaseFirestore$$Lambda$3.lambdaFactory$(this_, updateFunction, internalTransaction));
    }

    static /* synthetic */ Object lambda$runTransaction$0(FirebaseFirestore this_, Transaction.Function updateFunction, Transaction internalTransaction) throws Exception {
        return updateFunction.apply(new com.google.firebase.firestore.Transaction(internalTransaction, this_));
    }

    public static interface InstanceRegistry {
        public void remove(@NonNull String var1);
    }
}

