/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Function;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.LimboDocumentChange;
import com.google.firebase.firestore.core.OnlineState;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.QueryView;
import com.google.firebase.firestore.core.SyncEngine$$Lambda$1;
import com.google.firebase.firestore.core.SyncEngine$$Lambda$2;
import com.google.firebase.firestore.core.TargetIdGenerator;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.core.View;
import com.google.firebase.firestore.core.ViewChange;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.LocalViewChanges;
import com.google.firebase.firestore.local.LocalWriteResult;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatchResult;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.RemoteEvent;
import com.google.firebase.firestore.remote.RemoteStore;
import com.google.firebase.firestore.remote.TargetChange;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SyncEngine
implements RemoteStore.RemoteStoreCallback {
    private static final String TAG = SyncEngine.class.getSimpleName();
    private final LocalStore localStore;
    private final RemoteStore remoteStore;
    private final Map<Query, QueryView> queryViewsByQuery;
    private final Map<Integer, QueryView> queryViewsByTarget;
    private final Map<DocumentKey, Integer> limboTargetsByKey;
    private final Map<Integer, LimboResolution> limboResolutionsByTarget;
    private final ReferenceSet limboDocumentRefs;
    private final Map<User, Map<Integer, TaskCompletionSource<Void>>> mutationUserCallbacks;
    private final TargetIdGenerator targetIdGenerator;
    private User currentUser;
    private SyncEngineCallback syncEngineListener;

    public SyncEngine(LocalStore localStore, RemoteStore remoteStore, User initialUser) {
        this.localStore = localStore;
        this.remoteStore = remoteStore;
        this.queryViewsByQuery = new HashMap<Query, QueryView>();
        this.queryViewsByTarget = new HashMap<Integer, QueryView>();
        this.limboTargetsByKey = new HashMap<DocumentKey, Integer>();
        this.limboResolutionsByTarget = new HashMap<Integer, LimboResolution>();
        this.limboDocumentRefs = new ReferenceSet();
        this.mutationUserCallbacks = new HashMap<User, Map<Integer, TaskCompletionSource<Void>>>();
        this.targetIdGenerator = TargetIdGenerator.forSyncEngine();
        this.currentUser = initialUser;
    }

    public void setCallback(SyncEngineCallback callback) {
        this.syncEngineListener = callback;
    }

    private void assertCallback(String method) {
        Assert.hardAssert(this.syncEngineListener != null, "Trying to call %s before setting callback", method);
    }

    public int listen(Query query) {
        this.assertCallback("listen");
        Assert.hardAssert(!this.queryViewsByQuery.containsKey(query), "We already listen to query: %s", query);
        QueryData queryData = this.localStore.allocateQuery(query);
        ViewSnapshot viewSnapshot = this.initializeViewAndComputeSnapshot(queryData);
        this.syncEngineListener.onViewSnapshots(Collections.singletonList(viewSnapshot));
        this.remoteStore.listen(queryData);
        return queryData.getTargetId();
    }

    private ViewSnapshot initializeViewAndComputeSnapshot(QueryData queryData) {
        Query query = queryData.getQuery();
        ImmutableSortedMap<DocumentKey, Document> docs = this.localStore.executeQuery(query);
        ImmutableSortedSet<DocumentKey> remoteKeys = this.localStore.getRemoteDocumentKeys(queryData.getTargetId());
        View view = new View(query, remoteKeys);
        View.DocumentChanges viewDocChanges = view.computeDocChanges(docs);
        ViewChange viewChange = view.applyChanges(viewDocChanges);
        Assert.hardAssert(view.getLimboDocuments().size() == 0, "View returned limbo docs before target ack from the server", new Object[0]);
        QueryView queryView = new QueryView(query, queryData.getTargetId(), view);
        this.queryViewsByQuery.put(query, queryView);
        this.queryViewsByTarget.put(queryData.getTargetId(), queryView);
        return viewChange.getSnapshot();
    }

    void stopListening(Query query) {
        this.assertCallback("stopListening");
        QueryView queryView = this.queryViewsByQuery.get(query);
        Assert.hardAssert(queryView != null, "Trying to stop listening to a query not found", new Object[0]);
        this.localStore.releaseQuery(query);
        this.remoteStore.stopListening(queryView.getTargetId());
        this.removeAndCleanupQuery(queryView);
    }

    public void writeMutations(List<Mutation> mutations, TaskCompletionSource<Void> userTask) {
        this.assertCallback("writeMutations");
        LocalWriteResult result = this.localStore.writeLocally(mutations);
        this.addUserCallback(result.getBatchId(), userTask);
        this.emitNewSnapsAndNotifyLocalStore(result.getChanges(), null);
        this.remoteStore.fillWritePipeline();
    }

    private void addUserCallback(int batchId, TaskCompletionSource<Void> userTask) {
        Map<Integer, TaskCompletionSource<Void>> userTasks = this.mutationUserCallbacks.get(this.currentUser);
        if (userTasks == null) {
            userTasks = new HashMap<Integer, TaskCompletionSource<Void>>();
            this.mutationUserCallbacks.put(this.currentUser, userTasks);
        }
        userTasks.put(batchId, userTask);
    }

    public <TResult> Task<TResult> transaction(AsyncQueue asyncQueue, Function<Transaction, Task<TResult>> updateFunction, int retries) {
        Assert.hardAssert(retries >= 0, "Got negative number of retries for transaction.", new Object[0]);
        Transaction transaction = this.remoteStore.createTransaction();
        return ((Task)updateFunction.apply((Object)transaction)).continueWithTask(asyncQueue.getExecutor(), SyncEngine$$Lambda$1.lambdaFactory$(this, retries, asyncQueue, updateFunction, transaction));
    }

    @Override
    public void handleRemoteEvent(RemoteEvent event) {
        this.assertCallback("handleRemoteEvent");
        for (Map.Entry<Integer, TargetChange> entry : event.getTargetChanges().entrySet()) {
            Integer targetId = entry.getKey();
            TargetChange targetChange = entry.getValue();
            LimboResolution limboResolution = this.limboResolutionsByTarget.get(targetId);
            if (limboResolution == null) continue;
            Assert.hardAssert(targetChange.getAddedDocuments().size() + targetChange.getModifiedDocuments().size() + targetChange.getRemovedDocuments().size() <= 1, "Limbo resolution for single document contains multiple changes.", new Object[0]);
            if (targetChange.getAddedDocuments().size() > 0) {
                limboResolution.receivedDocument = true;
                continue;
            }
            if (targetChange.getModifiedDocuments().size() > 0) {
                Assert.hardAssert(limboResolution.receivedDocument, "Received change for limbo target document without add.", new Object[0]);
                continue;
            }
            if (targetChange.getRemovedDocuments().size() <= 0) continue;
            Assert.hardAssert(limboResolution.receivedDocument, "Received remove for limbo target document without add.", new Object[0]);
            limboResolution.receivedDocument = false;
        }
        ImmutableSortedMap<DocumentKey, MaybeDocument> changes = this.localStore.applyRemoteEvent(event);
        this.emitNewSnapsAndNotifyLocalStore(changes, event);
    }

    @Override
    public void handleOnlineStateChange(OnlineState onlineState) {
        ArrayList<ViewSnapshot> newViewSnapshots = new ArrayList<ViewSnapshot>();
        for (Map.Entry<Query, QueryView> entry : this.queryViewsByQuery.entrySet()) {
            View view = entry.getValue().getView();
            ViewChange viewChange = view.applyOnlineStateChange(onlineState);
            Assert.hardAssert(viewChange.getLimboChanges().isEmpty(), "OnlineState should not affect limbo documents.", new Object[0]);
            if (viewChange.getSnapshot() == null) continue;
            newViewSnapshots.add(viewChange.getSnapshot());
        }
        this.syncEngineListener.onViewSnapshots(newViewSnapshots);
        this.syncEngineListener.handleOnlineStateChange(onlineState);
    }

    @Override
    public ImmutableSortedSet<DocumentKey> getRemoteKeysForTarget(int targetId) {
        LimboResolution limboResolution = this.limboResolutionsByTarget.get(targetId);
        if (limboResolution != null && limboResolution.receivedDocument) {
            return DocumentKey.emptyKeySet().insert((Object)limboResolution.key);
        }
        QueryView queryView = this.queryViewsByTarget.get(targetId);
        return queryView != null ? queryView.getView().getSyncedDocuments() : DocumentKey.emptyKeySet();
    }

    @Override
    public void handleRejectedListen(int targetId, Status error) {
        DocumentKey limboKey;
        this.assertCallback("handleRejectedListen");
        LimboResolution limboResolution = this.limboResolutionsByTarget.get(targetId);
        DocumentKey documentKey = limboKey = limboResolution != null ? limboResolution.key : null;
        if (limboKey != null) {
            this.limboTargetsByKey.remove(limboKey);
            this.limboResolutionsByTarget.remove(targetId);
            Map<DocumentKey, MaybeDocument> documentUpdates = Collections.singletonMap(limboKey, new NoDocument(limboKey, SnapshotVersion.NONE, false));
            Set<DocumentKey> limboDocuments = Collections.singleton(limboKey);
            RemoteEvent event = new RemoteEvent(SnapshotVersion.NONE, Collections.<Integer, TargetChange>emptyMap(), Collections.<Integer>emptySet(), documentUpdates, limboDocuments);
            this.handleRemoteEvent(event);
        } else {
            QueryView queryView = this.queryViewsByTarget.get(targetId);
            Assert.hardAssert(queryView != null, "Unknown target: %s", targetId);
            Query query = queryView.getQuery();
            this.localStore.releaseQuery(query);
            this.removeAndCleanupQuery(queryView);
            this.logErrorIfInteresting(error, "Listen for %s failed", query);
            this.syncEngineListener.onError(query, error);
        }
    }

    @Override
    public void handleSuccessfulWrite(MutationBatchResult mutationBatchResult) {
        this.assertCallback("handleSuccessfulWrite");
        this.notifyUser(mutationBatchResult.getBatch().getBatchId(), null);
        ImmutableSortedMap<DocumentKey, MaybeDocument> changes = this.localStore.acknowledgeBatch(mutationBatchResult);
        this.emitNewSnapsAndNotifyLocalStore(changes, null);
    }

    @Override
    public void handleRejectedWrite(int batchId, Status status) {
        this.assertCallback("handleRejectedWrite");
        ImmutableSortedMap<DocumentKey, MaybeDocument> changes = this.localStore.rejectBatch(batchId);
        if (!changes.isEmpty()) {
            this.logErrorIfInteresting(status, "Write failed at %s", ((DocumentKey)changes.getMinKey()).getPath());
        }
        this.notifyUser(batchId, status);
        this.emitNewSnapsAndNotifyLocalStore(changes, null);
    }

    private void notifyUser(int batchId, @Nullable Status status) {
        Integer boxedBatchId;
        TaskCompletionSource<Void> userTask;
        Map<Integer, TaskCompletionSource<Void>> userTasks = this.mutationUserCallbacks.get(this.currentUser);
        if (userTasks != null && (userTask = userTasks.get(boxedBatchId = Integer.valueOf(batchId))) != null) {
            if (status != null) {
                userTask.setException((Exception)((Object)Util.exceptionFromStatus(status)));
            } else {
                userTask.setResult(null);
            }
            userTasks.remove(boxedBatchId);
        }
    }

    private void removeAndCleanupQuery(QueryView view) {
        this.queryViewsByQuery.remove(view.getQuery());
        this.queryViewsByTarget.remove(view.getTargetId());
        ImmutableSortedSet<DocumentKey> limboKeys = this.limboDocumentRefs.referencesForId(view.getTargetId());
        this.limboDocumentRefs.removeReferencesForId(view.getTargetId());
        for (DocumentKey key : limboKeys) {
            if (this.limboDocumentRefs.containsKey(key)) continue;
            this.removeLimboTarget(key);
        }
    }

    private void removeLimboTarget(DocumentKey key) {
        Integer targetId = this.limboTargetsByKey.get(key);
        if (targetId != null) {
            this.remoteStore.stopListening(targetId);
            this.limboTargetsByKey.remove(key);
            this.limboResolutionsByTarget.remove(targetId);
        }
    }

    private void emitNewSnapsAndNotifyLocalStore(ImmutableSortedMap<DocumentKey, MaybeDocument> changes, @Nullable RemoteEvent remoteEvent) {
        ArrayList<ViewSnapshot> newSnapshots = new ArrayList<ViewSnapshot>();
        ArrayList<LocalViewChanges> documentChangesInAllViews = new ArrayList<LocalViewChanges>();
        for (Map.Entry<Query, QueryView> entry : this.queryViewsByQuery.entrySet()) {
            QueryView queryView = entry.getValue();
            View view = queryView.getView();
            View.DocumentChanges viewDocChanges = view.computeDocChanges(changes);
            if (viewDocChanges.needsRefill()) {
                ImmutableSortedMap<DocumentKey, Document> docs = this.localStore.executeQuery(queryView.getQuery());
                viewDocChanges = view.computeDocChanges(docs, viewDocChanges);
            }
            TargetChange targetChange = remoteEvent == null ? null : remoteEvent.getTargetChanges().get(queryView.getTargetId());
            ViewChange viewChange = queryView.getView().applyChanges(viewDocChanges, targetChange);
            this.updateTrackedLimboDocuments(viewChange.getLimboChanges(), queryView.getTargetId());
            if (viewChange.getSnapshot() == null) continue;
            newSnapshots.add(viewChange.getSnapshot());
            LocalViewChanges docChanges = LocalViewChanges.fromViewSnapshot(queryView.getTargetId(), viewChange.getSnapshot());
            documentChangesInAllViews.add(docChanges);
        }
        this.syncEngineListener.onViewSnapshots(newSnapshots);
        this.localStore.notifyLocalViewChanges(documentChangesInAllViews);
    }

    private void updateTrackedLimboDocuments(List<LimboDocumentChange> limboChanges, int targetId) {
        block4: for (LimboDocumentChange limboChange : limboChanges) {
            switch (limboChange.getType()) {
                case ADDED: {
                    this.limboDocumentRefs.addReference(limboChange.getKey(), targetId);
                    this.trackLimboChange(limboChange);
                    continue block4;
                }
                case REMOVED: {
                    Logger.debug(TAG, "Document no longer in limbo: %s", limboChange.getKey());
                    DocumentKey limboDocKey = limboChange.getKey();
                    this.limboDocumentRefs.removeReference(limboDocKey, targetId);
                    if (this.limboDocumentRefs.containsKey(limboDocKey)) continue block4;
                    this.removeLimboTarget(limboDocKey);
                    continue block4;
                }
            }
            throw Assert.fail("Unknown limbo change type: %s", new Object[]{limboChange.getType()});
        }
    }

    private void trackLimboChange(LimboDocumentChange change) {
        DocumentKey key = change.getKey();
        if (!this.limboTargetsByKey.containsKey(key)) {
            Logger.debug(TAG, "New document in limbo: %s", key);
            int limboTargetId = this.targetIdGenerator.nextId();
            Query query = Query.atPath(key.getPath());
            QueryData queryData = new QueryData(query, limboTargetId, -1L, QueryPurpose.LIMBO_RESOLUTION);
            this.limboResolutionsByTarget.put(limboTargetId, new LimboResolution(key));
            this.remoteStore.listen(queryData);
            this.limboTargetsByKey.put(key, limboTargetId);
        }
    }

    @VisibleForTesting
    public Map<DocumentKey, Integer> getCurrentLimboDocuments() {
        return new HashMap<DocumentKey, Integer>(this.limboTargetsByKey);
    }

    public void handleCredentialChange(User user) {
        boolean userChanged = !this.currentUser.equals(user);
        this.currentUser = user;
        if (userChanged) {
            ImmutableSortedMap<DocumentKey, MaybeDocument> changes = this.localStore.handleUserChange(user);
            this.emitNewSnapsAndNotifyLocalStore(changes, null);
        }
        this.remoteStore.handleCredentialChange();
    }

    private void logErrorIfInteresting(Status error, String contextString, Object ... contextArgs) {
        if (this.errorIsInteresting(error)) {
            String context = String.format(contextString, contextArgs);
            Logger.warn("Firestore", "%s: %s", context, error);
        }
    }

    private boolean errorIsInteresting(Status error) {
        String description;
        Status.Code code = error.getCode();
        String string = description = error.getDescription() != null ? error.getDescription() : "";
        if (code == Status.Code.FAILED_PRECONDITION && description.contains("requires an index")) {
            return true;
        }
        return code == Status.Code.PERMISSION_DENIED;
    }

    private boolean isRetryableTransactionError(Exception e) {
        if (e instanceof FirebaseFirestoreException) {
            FirebaseFirestoreException.Code code = ((FirebaseFirestoreException)((Object)e)).getCode();
            return code == FirebaseFirestoreException.Code.ABORTED || code == FirebaseFirestoreException.Code.FAILED_PRECONDITION || !Datastore.isPermanentError(((FirebaseFirestoreException)((Object)e)).getCode());
        }
        return false;
    }

    static /* synthetic */ Task lambda$transaction$1(SyncEngine this_, int retries, AsyncQueue asyncQueue, Function updateFunction, Transaction transaction, Task userTask) throws Exception {
        if (!userTask.isSuccessful()) {
            if (retries > 0 && this_.isRetryableTransactionError(userTask.getException())) {
                return this_.transaction(asyncQueue, updateFunction, retries - 1);
            }
            return userTask;
        }
        return transaction.commit().continueWithTask(asyncQueue.getExecutor(), SyncEngine$$Lambda$2.lambdaFactory$(this_, userTask, retries, asyncQueue, updateFunction));
    }

    static /* synthetic */ Task lambda$transaction$0(SyncEngine this_, Task userTask, int retries, AsyncQueue asyncQueue, Function updateFunction, Task commitTask) throws Exception {
        if (commitTask.isSuccessful()) {
            return Tasks.forResult((Object)userTask.getResult());
        }
        Exception e = commitTask.getException();
        if (retries > 0 && this_.isRetryableTransactionError(e)) {
            return this_.transaction(asyncQueue, updateFunction, retries - 1);
        }
        return Tasks.forException((Exception)e);
    }

    static interface SyncEngineCallback {
        public void onViewSnapshots(List<ViewSnapshot> var1);

        public void onError(Query var1, Status var2);

        public void handleOnlineStateChange(OnlineState var1);
    }

    private static class LimboResolution {
        private final DocumentKey key;
        private boolean receivedDocument;

        LimboResolution(DocumentKey key) {
            this.key = key;
        }
    }
}

