/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.TimestampValue;

public final class ServerTimestampValue
extends FieldValue {
    private final Timestamp localWriteTime;
    @Nullable
    private final FieldValue previousValue;

    public ServerTimestampValue(Timestamp localWriteTime, @Nullable FieldValue previousValue) {
        this.localWriteTime = localWriteTime;
        this.previousValue = previousValue;
    }

    @Override
    public int typeOrder() {
        return 3;
    }

    @Override
    @Nullable
    public Object value() {
        return null;
    }

    @Nullable
    public Object getPreviousValue() {
        if (this.previousValue instanceof ServerTimestampValue) {
            return ((ServerTimestampValue)this.previousValue).getPreviousValue();
        }
        return this.previousValue != null ? this.previousValue.value() : null;
    }

    public Timestamp getLocalWriteTime() {
        return this.localWriteTime;
    }

    @Override
    public String toString() {
        return "<ServerTimestamp localTime=" + this.localWriteTime.toString() + ">";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ServerTimestampValue && this.localWriteTime.equals(((ServerTimestampValue)o).localWriteTime);
    }

    @Override
    public int hashCode() {
        return this.localWriteTime.hashCode();
    }

    @Override
    public int compareTo(FieldValue o) {
        if (o instanceof ServerTimestampValue) {
            return this.localWriteTime.compareTo(((ServerTimestampValue)o).localWriteTime);
        }
        if (o instanceof TimestampValue) {
            return 1;
        }
        return this.defaultCompareTo(o);
    }
}

