/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.auth;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.internal.IdTokenListener;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider$$Lambda$1;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider$$Lambda$2;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.util.Listener;
import com.google.firebase.internal.InternalTokenResult;

public final class FirebaseAuthCredentialsProvider
extends CredentialsProvider {
    private final InternalAuthProvider authProvider;
    private final IdTokenListener idTokenListener;
    @Nullable
    private Listener<User> changeListener;
    private User currentUser;
    private int tokenCounter;
    private boolean forceRefresh;

    public FirebaseAuthCredentialsProvider(InternalAuthProvider authProvider) {
        this.authProvider = authProvider;
        this.idTokenListener = FirebaseAuthCredentialsProvider$$Lambda$1.lambdaFactory$(this);
        this.currentUser = this.getUser();
        this.tokenCounter = 0;
        authProvider.addIdTokenListener(this.idTokenListener);
    }

    @Override
    public synchronized Task<String> getToken() {
        boolean doForceRefresh = this.forceRefresh;
        this.forceRefresh = false;
        Task res = this.authProvider.getAccessToken(doForceRefresh);
        int savedCounter = this.tokenCounter;
        return res.continueWith(FirebaseAuthCredentialsProvider$$Lambda$2.lambdaFactory$(this, savedCounter));
    }

    @Override
    public synchronized void invalidateToken() {
        this.forceRefresh = true;
    }

    @Override
    public synchronized void setChangeListener(@NonNull Listener<User> changeListener) {
        this.changeListener = changeListener;
        changeListener.onValue(this.currentUser);
    }

    @Override
    public synchronized void removeChangeListener() {
        this.changeListener = null;
        this.authProvider.removeIdTokenListener(this.idTokenListener);
    }

    private User getUser() {
        String uid = this.authProvider.getUid();
        return uid != null ? new User(uid) : User.UNAUTHENTICATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ String lambda$getToken$1(FirebaseAuthCredentialsProvider this_, int savedCounter, Task task) throws Exception {
        FirebaseAuthCredentialsProvider firebaseAuthCredentialsProvider = this_;
        synchronized (firebaseAuthCredentialsProvider) {
            if (savedCounter != this_.tokenCounter) {
                throw new FirebaseFirestoreException("getToken aborted due to token change", FirebaseFirestoreException.Code.ABORTED);
            }
            if (!task.isSuccessful()) {
                throw task.getException();
            }
            return ((GetTokenResult)task.getResult()).getToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$new$0(FirebaseAuthCredentialsProvider this_, InternalTokenResult token) {
        FirebaseAuthCredentialsProvider firebaseAuthCredentialsProvider = this_;
        synchronized (firebaseAuthCredentialsProvider) {
            this_.currentUser = this_.getUser();
            ++this_.tokenCounter;
            if (this_.changeListener != null) {
                this_.changeListener.onValue(this_.currentUser);
            }
        }
    }
}

