/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Function;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.local.SQLiteIndexManager;
import com.google.firebase.firestore.local.SQLiteLruReferenceDelegate;
import com.google.firebase.firestore.local.SQLiteMutationQueue;
import com.google.firebase.firestore.local.SQLitePersistence$$Lambda$1;
import com.google.firebase.firestore.local.SQLitePersistence$$Lambda$2;
import com.google.firebase.firestore.local.SQLitePersistence$Query$$Lambda$1;
import com.google.firebase.firestore.local.SQLiteQueryCache;
import com.google.firebase.firestore.local.SQLiteRemoteDocumentCache;
import com.google.firebase.firestore.local.SQLiteSchema;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;
import com.google.firebase.firestore.util.FileUtil;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Supplier;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class SQLitePersistence
extends Persistence {
    private final SQLiteOpenHelper opener;
    private final LocalSerializer serializer;
    private final SQLiteQueryCache queryCache;
    private final SQLiteIndexManager indexManager;
    private final SQLiteRemoteDocumentCache remoteDocumentCache;
    private final SQLiteLruReferenceDelegate referenceDelegate;
    private final SQLiteTransactionListener transactionListener = new SQLiteTransactionListener(){

        public void onBegin() {
            SQLitePersistence.this.referenceDelegate.onTransactionStarted();
        }

        public void onCommit() {
            SQLitePersistence.this.referenceDelegate.onTransactionCommitted();
        }

        public void onRollback() {
        }
    };
    private SQLiteDatabase db;
    private boolean started;

    @VisibleForTesting
    public static String databaseName(String persistenceKey, DatabaseId databaseId) {
        try {
            return "firestore." + URLEncoder.encode(persistenceKey, "utf-8") + "." + URLEncoder.encode(databaseId.getProjectId(), "utf-8") + "." + URLEncoder.encode(databaseId.getDatabaseId(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SQLitePersistence(Context context, String persistenceKey, DatabaseId databaseId, LocalSerializer serializer, LruGarbageCollector.Params params) {
        this(serializer, params, new OpenHelper(context, SQLitePersistence.databaseName(persistenceKey, databaseId)));
    }

    public SQLitePersistence(LocalSerializer serializer, LruGarbageCollector.Params params, SQLiteOpenHelper openHelper) {
        this.opener = openHelper;
        this.serializer = serializer;
        this.queryCache = new SQLiteQueryCache(this, this.serializer);
        this.indexManager = new SQLiteIndexManager(this);
        this.remoteDocumentCache = new SQLiteRemoteDocumentCache(this, this.serializer);
        this.referenceDelegate = new SQLiteLruReferenceDelegate(this, params);
    }

    @Override
    public void start() {
        Assert.hardAssert(!this.started, "SQLitePersistence double-started!", new Object[0]);
        this.started = true;
        try {
            this.db = this.opener.getWritableDatabase();
        }
        catch (SQLiteDatabaseLockedException e) {
            throw new RuntimeException("Failed to gain exclusive lock to the Cloud Firestore client's offline persistence. This generally means you are using Cloud Firestore from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing Cloud Firestore in your Application class. If you are intentionally using Cloud Firestore from multiple processes, you can only enable offline persistence (that is, call setPersistenceEnabled(true)) in one of them.", e);
        }
        this.queryCache.start();
        this.referenceDelegate.start(this.queryCache.getHighestListenSequenceNumber());
    }

    @Override
    public void shutdown() {
        Assert.hardAssert(this.started, "SQLitePersistence shutdown without start!", new Object[0]);
        this.started = false;
        this.db.close();
        this.db = null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public SQLiteLruReferenceDelegate getReferenceDelegate() {
        return this.referenceDelegate;
    }

    @Override
    MutationQueue getMutationQueue(User user) {
        return new SQLiteMutationQueue(this, this.serializer, user);
    }

    @Override
    SQLiteQueryCache getQueryCache() {
        return this.queryCache;
    }

    @Override
    IndexManager getIndexManager() {
        return this.indexManager;
    }

    @Override
    RemoteDocumentCache getRemoteDocumentCache() {
        return this.remoteDocumentCache;
    }

    @Override
    void runTransaction(String action, Runnable operation) {
        Logger.debug(TAG, "Starting transaction: %s", action);
        this.db.beginTransactionWithListener(this.transactionListener);
        try {
            operation.run();
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> T runTransaction(String action, Supplier<T> operation) {
        Logger.debug(TAG, "Starting transaction: %s", action);
        T value = null;
        this.db.beginTransactionWithListener(this.transactionListener);
        try {
            value = operation.get();
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
        return value;
    }

    public static void clearPersistence(Context context, DatabaseId databaseId, String persistenceKey) throws FirebaseFirestoreException {
        String databaseName = SQLitePersistence.databaseName(persistenceKey, databaseId);
        String sqLitePath = context.getDatabasePath(databaseName).getPath();
        String journalPath = sqLitePath + "-journal";
        String walPath = sqLitePath + "-wal";
        File sqLiteFile = new File(sqLitePath);
        File journalFile = new File(journalPath);
        File walFile = new File(walPath);
        try {
            FileUtil.delete(sqLiteFile);
            FileUtil.delete(journalFile);
            FileUtil.delete(walFile);
        }
        catch (IOException e) {
            throw new FirebaseFirestoreException("Failed to clear persistence." + e, FirebaseFirestoreException.Code.UNKNOWN);
        }
    }

    long getByteSize() {
        return this.getPageCount() * this.getPageSize();
    }

    private long getPageSize() {
        return (Long)this.query("PRAGMA page_size").firstValue(SQLitePersistence$$Lambda$1.lambdaFactory$());
    }

    private long getPageCount() {
        return (Long)this.query("PRAGMA page_count").firstValue(SQLitePersistence$$Lambda$2.lambdaFactory$());
    }

    void execute(String sql, Object ... args) {
        this.db.execSQL(sql, args);
    }

    SQLiteStatement prepare(String sql) {
        return this.db.compileStatement(sql);
    }

    int execute(SQLiteStatement statement, Object ... args) {
        statement.clearBindings();
        SQLitePersistence.bind((SQLiteProgram)statement, args);
        return statement.executeUpdateDelete();
    }

    Query query(String sql) {
        return new Query(this.db, sql);
    }

    private static void bind(SQLiteProgram program, Object[] bindArgs) {
        for (int i = 0; i < bindArgs.length; ++i) {
            Object arg = bindArgs[i];
            if (arg == null) {
                program.bindNull(i + 1);
                continue;
            }
            if (arg instanceof String) {
                program.bindString(i + 1, (String)arg);
                continue;
            }
            if (arg instanceof Integer) {
                program.bindLong(i + 1, (long)((Integer)arg).intValue());
                continue;
            }
            if (arg instanceof Long) {
                program.bindLong(i + 1, ((Long)arg).longValue());
                continue;
            }
            if (arg instanceof Double) {
                program.bindDouble(i + 1, ((Double)arg).doubleValue());
                continue;
            }
            if (arg instanceof byte[]) {
                program.bindBlob(i + 1, (byte[])arg);
                continue;
            }
            throw Assert.fail("Unknown argument %s of type %s", arg, arg.getClass());
        }
    }

    static /* synthetic */ Long lambda$getPageCount$1(Cursor row) {
        return row.getLong(0);
    }

    static /* synthetic */ Long lambda$getPageSize$0(Cursor row) {
        return row.getLong(0);
    }

    static class LongQuery {
        private final SQLitePersistence db;
        private final String head;
        private final String tail;
        private final List<Object> argsHead;
        private int subqueriesPerformed = 0;
        private final Iterator<Object> argsIter;
        private static final int LIMIT = 900;

        LongQuery(SQLitePersistence db, String head, List<Object> allArgs, String tail) {
            this.db = db;
            this.head = head;
            this.argsHead = Collections.emptyList();
            this.tail = tail;
            this.argsIter = allArgs.iterator();
        }

        LongQuery(SQLitePersistence db, String head, List<Object> argsHead, List<Object> allArgs, String tail) {
            this.db = db;
            this.head = head;
            this.argsHead = argsHead;
            this.tail = tail;
            this.argsIter = allArgs.iterator();
        }

        boolean hasMoreSubqueries() {
            return this.argsIter.hasNext();
        }

        Query performNextSubquery() {
            ++this.subqueriesPerformed;
            ArrayList<Object> subqueryArgs = new ArrayList<Object>(this.argsHead);
            StringBuilder placeholdersBuilder = new StringBuilder();
            for (int i = 0; this.argsIter.hasNext() && i < 900 - this.argsHead.size(); ++i) {
                if (i > 0) {
                    placeholdersBuilder.append(", ");
                }
                placeholdersBuilder.append("?");
                subqueryArgs.add(this.argsIter.next());
            }
            String placeholders = placeholdersBuilder.toString();
            return this.db.query(this.head + placeholders + this.tail).binding(subqueryArgs.toArray());
        }

        int getSubqueriesPerformed() {
            return this.subqueriesPerformed;
        }
    }

    static class Query {
        private final SQLiteDatabase db;
        private final String sql;
        private SQLiteDatabase.CursorFactory cursorFactory;

        Query(SQLiteDatabase db, String sql) {
            this.db = db;
            this.sql = sql;
        }

        Query binding(Object ... args) {
            this.cursorFactory = SQLitePersistence$Query$$Lambda$1.lambdaFactory$(args);
            return this;
        }

        int forEach(Consumer<Cursor> consumer) {
            int rowsProcessed = 0;
            Cursor cursor = this.startQuery();
            Throwable throwable = null;
            try {
                while (cursor.moveToNext()) {
                    ++rowsProcessed;
                    consumer.accept(cursor);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            return rowsProcessed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int first(Consumer<Cursor> consumer) {
            Cursor cursor = null;
            try {
                cursor = this.startQuery();
                if (cursor.moveToFirst()) {
                    consumer.accept(cursor);
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        <T> T firstValue(Function<Cursor, T> function) {
            Cursor cursor = null;
            try {
                cursor = this.startQuery();
                if (cursor.moveToFirst()) {
                    Object object = function.apply((Object)cursor);
                    return (T)object;
                }
                T t = null;
                return t;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        boolean isEmpty() {
            Cursor cursor = null;
            try {
                cursor = this.startQuery();
                boolean bl = !cursor.moveToFirst();
                return bl;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        private Cursor startQuery() {
            if (this.cursorFactory != null) {
                return this.db.rawQueryWithFactory(this.cursorFactory, this.sql, null, null);
            }
            return this.db.rawQuery(this.sql, null);
        }

        static /* synthetic */ Cursor lambda$binding$0(Object[] args, SQLiteDatabase db1, SQLiteCursorDriver masterQuery, String editTable, SQLiteQuery query) {
            SQLitePersistence.bind((SQLiteProgram)query, args);
            return new SQLiteCursor(masterQuery, editTable, query);
        }
    }

    private static class OpenHelper
    extends SQLiteOpenHelper {
        private boolean configured;

        OpenHelper(Context context, String databaseName) {
            super(context, databaseName, null, 10);
        }

        public void onConfigure(SQLiteDatabase db) {
            this.configured = true;
            Cursor cursor = db.rawQuery("PRAGMA locking_mode = EXCLUSIVE", new String[0]);
            cursor.close();
        }

        private void ensureConfigured(SQLiteDatabase db) {
            if (!this.configured) {
                this.onConfigure(db);
            }
        }

        public void onCreate(SQLiteDatabase db) {
            this.ensureConfigured(db);
            new SQLiteSchema(db).runMigrations(0);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.ensureConfigured(db);
            new SQLiteSchema(db).runMigrations(oldVersion);
        }

        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.ensureConfigured(db);
        }

        public void onOpen(SQLiteDatabase db) {
            this.ensureConfigured(db);
        }
    }
}

