/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.MemoryIndexManager;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$1;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$10;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$11;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$12;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$13;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$2;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$3;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$4;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$5;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$6;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$7;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$8;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$9;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.proto.Target;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

class SQLiteSchema {
    static final int VERSION = 10;
    static final int INDEXING_SUPPORT_VERSION = 11;
    private static final int SEQUENCE_NUMBER_BATCH_SIZE = 100;
    private final SQLiteDatabase db;

    SQLiteSchema(SQLiteDatabase db) {
        this.db = db;
    }

    void runMigrations() {
        this.runMigrations(0, 10);
    }

    void runMigrations(int fromVersion) {
        this.runMigrations(fromVersion, 10);
    }

    void runMigrations(int fromVersion, int toVersion) {
        if (fromVersion < 1 && toVersion >= 1) {
            this.createV1MutationQueue();
            this.createV1QueryCache();
            this.createV1RemoteDocumentCache();
        }
        if (fromVersion < 3 && toVersion >= 3 && fromVersion != 0) {
            this.dropV1QueryCache();
            this.createV1QueryCache();
        }
        if (fromVersion < 4 && toVersion >= 4) {
            this.ensureTargetGlobal();
            this.addTargetCount();
        }
        if (fromVersion < 5 && toVersion >= 5) {
            this.addSequenceNumber();
        }
        if (fromVersion < 6 && toVersion >= 6) {
            this.removeAcknowledgedMutations();
        }
        if (fromVersion < 7 && toVersion >= 7) {
            this.ensureSequenceNumbers();
        }
        if (fromVersion < 8 && toVersion >= 8) {
            this.createV8CollectionParentsIndex();
        }
        if (fromVersion < 9 && toVersion >= 9) {
            if (!this.hasReadTime()) {
                this.addReadTime();
            } else {
                this.dropLastLimboFreeSnapshotVersion();
            }
        }
        if (fromVersion == 9 && toVersion >= 10) {
            this.dropLastLimboFreeSnapshotVersion();
        }
        if (fromVersion < 11 && toVersion >= 11) {
            Preconditions.checkState((boolean)Persistence.INDEXING_SUPPORT_ENABLED);
            this.createLocalDocumentsCollectionIndex();
        }
    }

    private void ifTablesDontExist(String[] tables, Runnable fn) {
        boolean tablesFound = false;
        String allTables = "[" + TextUtils.join((CharSequence)", ", (Object[])tables) + "]";
        for (int i = 0; i < tables.length; ++i) {
            String table = tables[i];
            boolean tableFound = this.tableExists(table);
            if (i == 0) {
                tablesFound = tableFound;
                continue;
            }
            if (tableFound == tablesFound) continue;
            String msg = "Expected all of " + allTables + " to either exist or not, but ";
            msg = tablesFound ? msg + tables[0] + " exists and " + table + " does not" : msg + tables[0] + " does not exist and " + table + " does";
            throw new IllegalStateException(msg);
        }
        if (!tablesFound) {
            fn.run();
        } else {
            Log.d((String)"SQLiteSchema", (String)("Skipping migration because all of " + allTables + " already exist"));
        }
    }

    private void createV1MutationQueue() {
        this.ifTablesDontExist(new String[]{"mutation_queues", "mutations", "document_mutations"}, SQLiteSchema$$Lambda$1.lambdaFactory$(this));
    }

    private void removeAcknowledgedMutations() {
        SQLitePersistence.Query mutationQueuesQuery = new SQLitePersistence.Query(this.db, "SELECT uid, last_acknowledged_batch_id FROM mutation_queues");
        mutationQueuesQuery.forEach(SQLiteSchema$$Lambda$2.lambdaFactory$(this));
    }

    private void removeMutationBatch(String uid, int batchId) {
        SQLiteStatement mutationDeleter = this.db.compileStatement("DELETE FROM mutations WHERE uid = ? AND batch_id = ?");
        mutationDeleter.bindString(1, uid);
        mutationDeleter.bindLong(2, (long)batchId);
        int deleted = mutationDeleter.executeUpdateDelete();
        Assert.hardAssert(deleted != 0, "Mutatiohn batch (%s, %d) did not exist", uid, batchId);
        this.db.execSQL("DELETE FROM document_mutations WHERE uid = ? AND batch_id = ?", new Object[]{uid, batchId});
    }

    private void createV1QueryCache() {
        this.ifTablesDontExist(new String[]{"targets", "target_globals", "target_documents"}, SQLiteSchema$$Lambda$3.lambdaFactory$(this));
    }

    private void dropV1QueryCache() {
        if (this.tableExists("targets")) {
            this.db.execSQL("DROP TABLE targets");
        }
        if (this.tableExists("target_globals")) {
            this.db.execSQL("DROP TABLE target_globals");
        }
        if (this.tableExists("target_documents")) {
            this.db.execSQL("DROP TABLE target_documents");
        }
    }

    private void createV1RemoteDocumentCache() {
        this.ifTablesDontExist(new String[]{"remote_documents"}, SQLiteSchema$$Lambda$4.lambdaFactory$(this));
    }

    private void createLocalDocumentsCollectionIndex() {
        this.ifTablesDontExist(new String[]{"collection_index"}, SQLiteSchema$$Lambda$5.lambdaFactory$(this));
    }

    private void ensureTargetGlobal() {
        boolean targetGlobalExists;
        boolean bl = targetGlobalExists = DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db, (String)"target_globals") == 1L;
        if (!targetGlobalExists) {
            this.db.execSQL("INSERT INTO target_globals (highest_target_id, highest_listen_sequence_number, last_remote_snapshot_version_seconds, last_remote_snapshot_version_nanos) VALUES (?, ?, ?, ?)", (Object[])new String[]{"0", "0", "0", "0"});
        }
    }

    private void addTargetCount() {
        if (!this.tableContainsColumn("target_globals", "target_count")) {
            this.db.execSQL("ALTER TABLE target_globals ADD COLUMN target_count INTEGER");
        }
        long count = DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db, (String)"targets");
        ContentValues cv = new ContentValues();
        cv.put("target_count", Long.valueOf(count));
        this.db.update("target_globals", cv, null, null);
    }

    private void addSequenceNumber() {
        if (!this.tableContainsColumn("target_documents", "sequence_number")) {
            this.db.execSQL("ALTER TABLE target_documents ADD COLUMN sequence_number INTEGER");
        }
    }

    private boolean hasReadTime() {
        boolean hasReadTimeNanos;
        boolean hasReadTimeSeconds = this.tableContainsColumn("remote_documents", "read_time_seconds");
        Assert.hardAssert(hasReadTimeSeconds == (hasReadTimeNanos = this.tableContainsColumn("remote_documents", "read_time_nanos")), "Table contained just one of read_time_seconds or read_time_nanos", new Object[0]);
        return hasReadTimeSeconds && hasReadTimeNanos;
    }

    private void addReadTime() {
        this.db.execSQL("ALTER TABLE remote_documents ADD COLUMN read_time_seconds INTEGER");
        this.db.execSQL("ALTER TABLE remote_documents ADD COLUMN read_time_nanos INTEGER");
    }

    private void dropLastLimboFreeSnapshotVersion() {
        new SQLitePersistence.Query(this.db, "SELECT target_id, target_proto FROM targets").forEach(SQLiteSchema$$Lambda$6.lambdaFactory$(this));
    }

    private void ensureSequenceNumbers() {
        SQLitePersistence.Query sequenceNumberQuery = new SQLitePersistence.Query(this.db, "SELECT highest_listen_sequence_number FROM target_globals LIMIT 1");
        Long boxedSequenceNumber = (Long)sequenceNumberQuery.firstValue(SQLiteSchema$$Lambda$7.lambdaFactory$());
        Assert.hardAssert(boxedSequenceNumber != null, "Missing highest sequence number", new Object[0]);
        long sequenceNumber = boxedSequenceNumber;
        SQLiteStatement tagDocument = this.db.compileStatement("INSERT INTO target_documents (target_id, path, sequence_number) VALUES (0, ?, ?)");
        SQLitePersistence.Query untaggedDocumentsQuery = new SQLitePersistence.Query(this.db, "SELECT RD.path FROM remote_documents AS RD WHERE NOT EXISTS (SELECT TD.path FROM target_documents AS TD WHERE RD.path = TD.path AND TD.target_id = 0) LIMIT ?").binding(100);
        boolean[] resultsRemaining = new boolean[]{false};
        do {
            untaggedDocumentsQuery.forEach(SQLiteSchema$$Lambda$8.lambdaFactory$(resultsRemaining, tagDocument, sequenceNumber));
        } while (resultsRemaining[0]);
    }

    private void createV8CollectionParentsIndex() {
        this.ifTablesDontExist(new String[]{"collection_parents"}, SQLiteSchema$$Lambda$9.lambdaFactory$(this));
        MemoryIndexManager.MemoryCollectionParentIndex cache = new MemoryIndexManager.MemoryCollectionParentIndex();
        SQLiteStatement addIndexEntry = this.db.compileStatement("INSERT OR REPLACE INTO collection_parents (collection_id, parent) VALUES (?, ?)");
        Consumer addEntry = SQLiteSchema$$Lambda$10.lambdaFactory$(cache, addIndexEntry);
        SQLitePersistence.Query remoteDocumentsQuery = new SQLitePersistence.Query(this.db, "SELECT path FROM remote_documents");
        remoteDocumentsQuery.forEach(SQLiteSchema$$Lambda$11.lambdaFactory$(addEntry));
        SQLitePersistence.Query documentMutationsQuery = new SQLitePersistence.Query(this.db, "SELECT path FROM document_mutations");
        documentMutationsQuery.forEach(SQLiteSchema$$Lambda$12.lambdaFactory$(addEntry));
    }

    private boolean tableContainsColumn(String table, String column) {
        List<String> columns = this.getTableColumns(table);
        return columns.indexOf(column) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<String> getTableColumns(String table) {
        Cursor c = null;
        ArrayList<String> columns = new ArrayList<String>();
        try {
            c = this.db.rawQuery("PRAGMA table_info(" + table + ")", null);
            int nameIndex = c.getColumnIndex("name");
            while (c.moveToNext()) {
                columns.add(c.getString(nameIndex));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return columns;
    }

    private boolean tableExists(String table) {
        return !new SQLitePersistence.Query(this.db, "SELECT 1=1 FROM sqlite_master WHERE tbl_name = ?").binding(table).isEmpty();
    }

    static /* synthetic */ void lambda$createV8CollectionParentsIndex$12(Consumer addEntry, Cursor row) {
        ResourcePath path = EncodedPath.decodeResourcePath(row.getString(0));
        addEntry.accept((ResourcePath)path.popLast());
    }

    static /* synthetic */ void lambda$createV8CollectionParentsIndex$11(Consumer addEntry, Cursor row) {
        ResourcePath path = EncodedPath.decodeResourcePath(row.getString(0));
        addEntry.accept((ResourcePath)path.popLast());
    }

    static /* synthetic */ void lambda$createV8CollectionParentsIndex$10(MemoryIndexManager.MemoryCollectionParentIndex cache, SQLiteStatement addIndexEntry, ResourcePath collectionPath) {
        if (cache.add(collectionPath)) {
            String collectionId = collectionPath.getLastSegment();
            ResourcePath parentPath = (ResourcePath)collectionPath.popLast();
            addIndexEntry.clearBindings();
            addIndexEntry.bindString(1, collectionId);
            addIndexEntry.bindString(2, EncodedPath.encode(parentPath));
            addIndexEntry.execute();
        }
    }

    static /* synthetic */ void lambda$createV8CollectionParentsIndex$9(SQLiteSchema this_) {
        this_.db.execSQL("CREATE TABLE collection_parents (collection_id TEXT, parent TEXT, PRIMARY KEY(collection_id, parent))");
    }

    static /* synthetic */ void lambda$ensureSequenceNumbers$8(boolean[] resultsRemaining, SQLiteStatement tagDocument, long sequenceNumber, Cursor row) {
        resultsRemaining[0] = true;
        tagDocument.clearBindings();
        tagDocument.bindString(1, row.getString(0));
        tagDocument.bindLong(2, sequenceNumber);
        Assert.hardAssert(tagDocument.executeInsert() != -1L, "Failed to insert a sentinel row", new Object[0]);
    }

    static /* synthetic */ Long lambda$ensureSequenceNumbers$7(Cursor c) {
        return c.getLong(0);
    }

    static /* synthetic */ void lambda$dropLastLimboFreeSnapshotVersion$6(SQLiteSchema this_, Cursor cursor) {
        int targetId = cursor.getInt(0);
        byte[] targetProtoBytes = cursor.getBlob(1);
        try {
            Target targetProto = Target.parseFrom(targetProtoBytes);
            targetProto = (Target)((Target.Builder)targetProto.toBuilder()).clearLastLimboFreeSnapshotVersion().build();
            this_.db.execSQL("UPDATE targets SET target_proto = ? WHERE target_id = ?", new Object[]{targetProto.toByteArray(), targetId});
        }
        catch (InvalidProtocolBufferException e) {
            throw Assert.fail("Failed to decode Query data for target %s", targetId);
        }
    }

    static /* synthetic */ void lambda$createLocalDocumentsCollectionIndex$5(SQLiteSchema this_) {
        this_.db.execSQL("CREATE TABLE collection_index (uid TEXT, collection_path TEXT, field_path TEXT, field_value_type INTEGER, field_value_1, field_value_2, document_id TEXT, PRIMARY KEY (uid, collection_path, field_path, field_value_type, field_value_1, field_value_2, document_id))");
    }

    static /* synthetic */ void lambda$createV1RemoteDocumentCache$4(SQLiteSchema this_) {
        this_.db.execSQL("CREATE TABLE remote_documents (path TEXT PRIMARY KEY, contents BLOB)");
    }

    static /* synthetic */ void lambda$createV1QueryCache$3(SQLiteSchema this_) {
        this_.db.execSQL("CREATE TABLE targets (target_id INTEGER PRIMARY KEY, canonical_id TEXT, snapshot_version_seconds INTEGER, snapshot_version_nanos INTEGER, resume_token BLOB, last_listen_sequence_number INTEGER,target_proto BLOB)");
        this_.db.execSQL("CREATE INDEX query_targets ON targets (canonical_id, target_id)");
        this_.db.execSQL("CREATE TABLE target_globals (highest_target_id INTEGER, highest_listen_sequence_number INTEGER, last_remote_snapshot_version_seconds INTEGER, last_remote_snapshot_version_nanos INTEGER)");
        this_.db.execSQL("CREATE TABLE target_documents (target_id INTEGER, path TEXT, PRIMARY KEY (target_id, path))");
        this_.db.execSQL("CREATE INDEX document_targets ON target_documents (path, target_id)");
    }

    static /* synthetic */ void lambda$removeAcknowledgedMutations$2(SQLiteSchema this_, Cursor mutationQueueEntry) {
        String uid = mutationQueueEntry.getString(0);
        long lastAcknowledgedBatchId = mutationQueueEntry.getLong(1);
        SQLitePersistence.Query mutationsQuery = new SQLitePersistence.Query(this_.db, "SELECT batch_id FROM mutations WHERE uid = ? AND batch_id <= ?").binding(uid, lastAcknowledgedBatchId);
        mutationsQuery.forEach(SQLiteSchema$$Lambda$13.lambdaFactory$(this_, uid));
    }

    static /* synthetic */ void lambda$removeAcknowledgedMutations$1(SQLiteSchema this_, String uid, Cursor value) {
        this_.removeMutationBatch(uid, value.getInt(0));
    }

    static /* synthetic */ void lambda$createV1MutationQueue$0(SQLiteSchema this_) {
        this_.db.execSQL("CREATE TABLE mutation_queues (uid TEXT PRIMARY KEY, last_acknowledged_batch_id INTEGER, last_stream_token BLOB)");
        this_.db.execSQL("CREATE TABLE mutations (uid TEXT, batch_id INTEGER, mutations BLOB, PRIMARY KEY (uid, batch_id))");
        this_.db.execSQL("CREATE TABLE document_mutations (uid TEXT, path TEXT, batch_id INTEGER, PRIMARY KEY (uid, path, batch_id))");
    }
}

