/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Function;
import com.google.firebase.firestore.model.Document$$Lambda$1;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Document
extends MaybeDocument {
    private static final Comparator<Document> KEY_COMPARATOR = Document$$Lambda$1.lambdaFactory$();
    private final DocumentState documentState;
    @Nullable
    private final com.google.firestore.v1.Document proto;
    @Nullable
    private final Function<Value, FieldValue> converter;
    @Nullable
    private ObjectValue objectValue;
    @Nullable
    private Map<FieldPath, FieldValue> fieldValueCache;

    public static Comparator<Document> keyComparator() {
        return KEY_COMPARATOR;
    }

    public Document(DocumentKey key, SnapshotVersion version, DocumentState documentState, ObjectValue objectValue) {
        super(key, version);
        this.documentState = documentState;
        this.objectValue = objectValue;
        this.proto = null;
        this.converter = null;
    }

    public Document(DocumentKey key, SnapshotVersion version, DocumentState documentState, com.google.firestore.v1.Document proto, Function<Value, FieldValue> converter) {
        super(key, version);
        this.documentState = documentState;
        this.proto = proto;
        this.converter = converter;
    }

    @Nullable
    public com.google.firestore.v1.Document getProto() {
        return this.proto;
    }

    @NonNull
    public ObjectValue getData() {
        if (this.objectValue == null) {
            Assert.hardAssert(this.proto != null && this.converter != null, "Expected proto and converter to be non-null", new Object[0]);
            ObjectValue result = ObjectValue.emptyObject();
            for (Map.Entry<String, Value> entry : this.proto.getFieldsMap().entrySet()) {
                FieldPath path = FieldPath.fromSingleSegment(entry.getKey());
                FieldValue value = (FieldValue)this.converter.apply((Object)entry.getValue());
                result = result.set(path, value);
            }
            this.objectValue = result;
            this.fieldValueCache = null;
        }
        return this.objectValue;
    }

    @Nullable
    public FieldValue getField(FieldPath path) {
        FieldValue fieldValue;
        if (this.objectValue != null) {
            return this.objectValue.get(path);
        }
        Assert.hardAssert(this.proto != null && this.converter != null, "Expected proto and converter to be non-null", new Object[0]);
        if (this.fieldValueCache == null) {
            this.fieldValueCache = new ConcurrentHashMap<FieldPath, FieldValue>();
        }
        if ((fieldValue = this.fieldValueCache.get(path)) == null) {
            Value protoValue = this.proto.getFieldsMap().get(path.getFirstSegment());
            for (int i = 1; protoValue != null && i < path.length(); ++i) {
                if (protoValue.getValueTypeCase() != Value.ValueTypeCase.MAP_VALUE) {
                    return null;
                }
                protoValue = protoValue.getMapValue().getFieldsMap().get(path.getSegment(i));
            }
            if (protoValue != null) {
                fieldValue = (FieldValue)this.converter.apply((Object)protoValue);
                this.fieldValueCache.put(path, fieldValue);
            }
        }
        return fieldValue;
    }

    @Nullable
    public Object getFieldValue(FieldPath path) {
        FieldValue value = this.getField(path);
        return value == null ? null : value.value();
    }

    public boolean hasLocalMutations() {
        return this.documentState.equals((Object)DocumentState.LOCAL_MUTATIONS);
    }

    public boolean hasCommittedMutations() {
        return this.documentState.equals((Object)DocumentState.COMMITTED_MUTATIONS);
    }

    @Override
    public boolean hasPendingWrites() {
        return this.hasLocalMutations() || this.hasCommittedMutations();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        return this.getVersion().equals(document.getVersion()) && this.getKey().equals(document.getKey()) && this.documentState.equals((Object)document.documentState) && this.getData().equals(document.getData());
    }

    public int hashCode() {
        int result = this.getKey().hashCode();
        result = 31 * result + this.getVersion().hashCode();
        result = 31 * result + this.documentState.hashCode();
        return result;
    }

    public String toString() {
        return "Document{key=" + this.getKey() + ", data=" + this.getData() + ", version=" + this.getVersion() + ", documentState=" + this.documentState.name() + '}';
    }

    static /* synthetic */ int lambda$static$0(Document left, Document right) {
        return left.getKey().compareTo(right.getKey());
    }

    public static enum DocumentState {
        LOCAL_MUTATIONS,
        COMMITTED_MUTATIONS,
        SYNCED;

    }
}

