/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.ArrayValue;
import com.google.firebase.firestore.model.value.FieldValue;

public class ArrayContainsAnyFilter
extends FieldFilter {
    ArrayContainsAnyFilter(FieldPath field, FieldValue value) {
        super(field, Filter.Operator.ARRAY_CONTAINS_ANY, value);
    }

    @Override
    public boolean matches(Document doc) {
        ArrayValue arrayValue = (ArrayValue)this.getValue();
        FieldValue other = doc.getField(this.getField());
        if (!(other instanceof ArrayValue)) {
            return false;
        }
        for (FieldValue val : ((ArrayValue)other).getInternalValue()) {
            if (!arrayValue.getInternalValue().contains(val)) continue;
            return true;
        }
        return false;
    }
}

