/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.LimboDocumentChange;
import com.google.firebase.firestore.core.OnlineState;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.QueryView;
import com.google.firebase.firestore.core.TargetIdGenerator;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.core.TransactionRunner;
import com.google.firebase.firestore.core.View;
import com.google.firebase.firestore.core.ViewChange;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.LocalViewChanges;
import com.google.firebase.firestore.local.LocalWriteResult;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.local.QueryResult;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatchResult;
import com.google.firebase.firestore.remote.RemoteEvent;
import com.google.firebase.firestore.remote.RemoteStore;
import com.google.firebase.firestore.remote.TargetChange;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SyncEngine
implements RemoteStore.RemoteStoreCallback {
    private static final String TAG = SyncEngine.class.getSimpleName();
    private final LocalStore localStore;
    private final RemoteStore remoteStore;
    private final Map<Query, QueryView> queryViewsByQuery;
    private final Map<Integer, List<Query>> queriesByTarget;
    private final Map<DocumentKey, Integer> limboTargetsByKey;
    private final Map<Integer, LimboResolution> limboResolutionsByTarget;
    private final ReferenceSet limboDocumentRefs;
    private final Map<User, Map<Integer, TaskCompletionSource<Void>>> mutationUserCallbacks;
    private final Map<Integer, List<TaskCompletionSource<Void>>> pendingWritesCallbacks;
    private final TargetIdGenerator targetIdGenerator;
    private User currentUser;
    private SyncEngineCallback syncEngineListener;

    public SyncEngine(LocalStore localStore, RemoteStore remoteStore, User initialUser) {
        this.localStore = localStore;
        this.remoteStore = remoteStore;
        this.queryViewsByQuery = new HashMap<Query, QueryView>();
        this.queriesByTarget = new HashMap<Integer, List<Query>>();
        this.limboTargetsByKey = new HashMap<DocumentKey, Integer>();
        this.limboResolutionsByTarget = new HashMap<Integer, LimboResolution>();
        this.limboDocumentRefs = new ReferenceSet();
        this.mutationUserCallbacks = new HashMap<User, Map<Integer, TaskCompletionSource<Void>>>();
        this.targetIdGenerator = TargetIdGenerator.forSyncEngine();
        this.currentUser = initialUser;
        this.pendingWritesCallbacks = new HashMap<Integer, List<TaskCompletionSource<Void>>>();
    }

    public void setCallback(SyncEngineCallback callback) {
        this.syncEngineListener = callback;
    }

    private void assertCallback(String method) {
        Assert.hardAssert(this.syncEngineListener != null, "Trying to call %s before setting callback", method);
    }

    public int listen(Query query) {
        this.assertCallback("listen");
        Assert.hardAssert(!this.queryViewsByQuery.containsKey(query), "We already listen to query: %s", query);
        QueryData queryData = this.localStore.allocateTarget(query.toTarget());
        ViewSnapshot viewSnapshot = this.initializeViewAndComputeSnapshot(query, queryData.getTargetId());
        this.syncEngineListener.onViewSnapshots(Collections.singletonList(viewSnapshot));
        this.remoteStore.listen(queryData);
        return queryData.getTargetId();
    }

    private ViewSnapshot initializeViewAndComputeSnapshot(Query query, int targetId) {
        QueryResult queryResult = this.localStore.executeQuery(query, true);
        ViewSnapshot.SyncState currentTargetSyncState = ViewSnapshot.SyncState.NONE;
        TargetChange synthesizedCurrentChange = null;
        if (this.queriesByTarget.get(targetId) != null) {
            Query mirrorQuery = this.queriesByTarget.get(targetId).get(0);
            currentTargetSyncState = this.queryViewsByQuery.get(mirrorQuery).getView().getSyncState();
            synthesizedCurrentChange = TargetChange.createSynthesizedTargetChangeForCurrentChange(currentTargetSyncState == ViewSnapshot.SyncState.SYNCED);
        }
        View view = new View(query, queryResult.getRemoteKeys());
        View.DocumentChanges viewDocChanges = view.computeDocChanges(queryResult.getDocuments());
        ViewChange viewChange = view.applyChanges(viewDocChanges, synthesizedCurrentChange);
        Assert.hardAssert(view.getLimboDocuments().size() == 0, "View returned limbo docs before target ack from the server", new Object[0]);
        QueryView queryView = new QueryView(query, targetId, view);
        this.queryViewsByQuery.put(query, queryView);
        if (!this.queriesByTarget.containsKey(targetId)) {
            this.queriesByTarget.put(targetId, new ArrayList(1));
        }
        this.queriesByTarget.get(targetId).add(query);
        return viewChange.getSnapshot();
    }

    void stopListening(Query query) {
        this.assertCallback("stopListening");
        QueryView queryView = this.queryViewsByQuery.get(query);
        Assert.hardAssert(queryView != null, "Trying to stop listening to a query not found", new Object[0]);
        this.queryViewsByQuery.remove(query);
        int targetId = queryView.getTargetId();
        List<Query> targetQueries = this.queriesByTarget.get(targetId);
        targetQueries.remove(query);
        if (targetQueries.isEmpty()) {
            this.localStore.releaseTarget(targetId);
            this.remoteStore.stopListening(targetId);
            this.removeAndCleanupTarget(targetId, Status.OK);
        }
    }

    public void writeMutations(List<Mutation> mutations, TaskCompletionSource<Void> userTask) {
        this.assertCallback("writeMutations");
        LocalWriteResult result = this.localStore.writeLocally(mutations);
        this.addUserCallback(result.getBatchId(), userTask);
        this.emitNewSnapsAndNotifyLocalStore(result.getChanges(), null);
        this.remoteStore.fillWritePipeline();
    }

    private void addUserCallback(int batchId, TaskCompletionSource<Void> userTask) {
        Map<Integer, TaskCompletionSource<Void>> userTasks = this.mutationUserCallbacks.get(this.currentUser);
        if (userTasks == null) {
            userTasks = new HashMap<Integer, TaskCompletionSource<Void>>();
            this.mutationUserCallbacks.put(this.currentUser, userTasks);
        }
        userTasks.put(batchId, userTask);
    }

    public <TResult> Task<TResult> transaction(AsyncQueue asyncQueue, Function<Transaction, Task<TResult>> updateFunction) {
        return new TransactionRunner<TResult>(asyncQueue, this.remoteStore, updateFunction).run();
    }

    @Override
    public void handleRemoteEvent(RemoteEvent event) {
        this.assertCallback("handleRemoteEvent");
        for (Map.Entry<Integer, TargetChange> entry : event.getTargetChanges().entrySet()) {
            Integer targetId = entry.getKey();
            TargetChange targetChange = entry.getValue();
            LimboResolution limboResolution = this.limboResolutionsByTarget.get(targetId);
            if (limboResolution == null) continue;
            Assert.hardAssert(targetChange.getAddedDocuments().size() + targetChange.getModifiedDocuments().size() + targetChange.getRemovedDocuments().size() <= 1, "Limbo resolution for single document contains multiple changes.", new Object[0]);
            if (targetChange.getAddedDocuments().size() > 0) {
                limboResolution.receivedDocument = true;
                continue;
            }
            if (targetChange.getModifiedDocuments().size() > 0) {
                Assert.hardAssert(limboResolution.receivedDocument, "Received change for limbo target document without add.", new Object[0]);
                continue;
            }
            if (targetChange.getRemovedDocuments().size() <= 0) continue;
            Assert.hardAssert(limboResolution.receivedDocument, "Received remove for limbo target document without add.", new Object[0]);
            limboResolution.receivedDocument = false;
        }
        ImmutableSortedMap<DocumentKey, MaybeDocument> changes = this.localStore.applyRemoteEvent(event);
        this.emitNewSnapsAndNotifyLocalStore(changes, event);
    }

    @Override
    public void handleOnlineStateChange(OnlineState onlineState) {
        this.assertCallback("handleOnlineStateChange");
        ArrayList<ViewSnapshot> newViewSnapshots = new ArrayList<ViewSnapshot>();
        for (Map.Entry<Query, QueryView> entry : this.queryViewsByQuery.entrySet()) {
            View view = entry.getValue().getView();
            ViewChange viewChange = view.applyOnlineStateChange(onlineState);
            Assert.hardAssert(viewChange.getLimboChanges().isEmpty(), "OnlineState should not affect limbo documents.", new Object[0]);
            if (viewChange.getSnapshot() == null) continue;
            newViewSnapshots.add(viewChange.getSnapshot());
        }
        this.syncEngineListener.onViewSnapshots(newViewSnapshots);
        this.syncEngineListener.handleOnlineStateChange(onlineState);
    }

    @Override
    public ImmutableSortedSet<DocumentKey> getRemoteKeysForTarget(int targetId) {
        LimboResolution limboResolution = this.limboResolutionsByTarget.get(targetId);
        if (limboResolution != null && limboResolution.receivedDocument) {
            return DocumentKey.emptyKeySet().insert((Object)limboResolution.key);
        }
        ArrayList remoteKeys = Lists.newArrayList();
        if (this.queriesByTarget.containsKey(targetId)) {
            for (Query query : this.queriesByTarget.get(targetId)) {
                if (!this.queryViewsByQuery.containsKey(query)) continue;
                remoteKeys.addAll(Lists.newArrayList(this.queryViewsByQuery.get(query).getView().getSyncedDocuments()));
            }
        }
        return new ImmutableSortedSet((List)remoteKeys, DocumentKey.comparator());
    }

    @Override
    public void handleRejectedListen(int targetId, Status error) {
        DocumentKey limboKey;
        this.assertCallback("handleRejectedListen");
        LimboResolution limboResolution = this.limboResolutionsByTarget.get(targetId);
        DocumentKey documentKey = limboKey = limboResolution != null ? limboResolution.key : null;
        if (limboKey != null) {
            this.limboTargetsByKey.remove(limboKey);
            this.limboResolutionsByTarget.remove(targetId);
            Map<DocumentKey, MaybeDocument> documentUpdates = Collections.singletonMap(limboKey, new NoDocument(limboKey, SnapshotVersion.NONE, false));
            Set<DocumentKey> limboDocuments = Collections.singleton(limboKey);
            RemoteEvent event = new RemoteEvent(SnapshotVersion.NONE, Collections.<Integer, TargetChange>emptyMap(), Collections.<Integer>emptySet(), documentUpdates, limboDocuments);
            this.handleRemoteEvent(event);
        } else {
            this.localStore.releaseTarget(targetId);
            this.removeAndCleanupTarget(targetId, error);
        }
    }

    @Override
    public void handleSuccessfulWrite(MutationBatchResult mutationBatchResult) {
        this.assertCallback("handleSuccessfulWrite");
        this.notifyUser(mutationBatchResult.getBatch().getBatchId(), null);
        this.resolvePendingWriteTasks(mutationBatchResult.getBatch().getBatchId());
        ImmutableSortedMap<DocumentKey, MaybeDocument> changes = this.localStore.acknowledgeBatch(mutationBatchResult);
        this.emitNewSnapsAndNotifyLocalStore(changes, null);
    }

    @Override
    public void handleRejectedWrite(int batchId, Status status) {
        this.assertCallback("handleRejectedWrite");
        ImmutableSortedMap<DocumentKey, MaybeDocument> changes = this.localStore.rejectBatch(batchId);
        if (!changes.isEmpty()) {
            this.logErrorIfInteresting(status, "Write failed at %s", ((DocumentKey)changes.getMinKey()).getPath());
        }
        this.notifyUser(batchId, status);
        this.resolvePendingWriteTasks(batchId);
        this.emitNewSnapsAndNotifyLocalStore(changes, null);
    }

    public void registerPendingWritesTask(TaskCompletionSource<Void> userTask) {
        int largestPendingBatchId;
        if (!this.remoteStore.canUseNetwork()) {
            Logger.debug(TAG, "The network is disabled. The task returned by 'awaitPendingWrites()' will not complete until the network is enabled.", new Object[0]);
        }
        if ((largestPendingBatchId = this.localStore.getHighestUnacknowledgedBatchId()) == -1) {
            userTask.setResult(null);
            return;
        }
        if (this.pendingWritesCallbacks.containsKey(largestPendingBatchId)) {
            this.pendingWritesCallbacks.get(largestPendingBatchId).add(userTask);
        } else {
            this.pendingWritesCallbacks.put(largestPendingBatchId, Lists.newArrayList((Object[])new TaskCompletionSource[]{userTask}));
        }
    }

    private void resolvePendingWriteTasks(int batchId) {
        if (this.pendingWritesCallbacks.containsKey(batchId)) {
            for (TaskCompletionSource<Void> task : this.pendingWritesCallbacks.get(batchId)) {
                task.setResult(null);
            }
            this.pendingWritesCallbacks.remove(batchId);
        }
    }

    private void failOutstandingPendingWritesAwaitingTasks() {
        for (Map.Entry<Integer, List<TaskCompletionSource<Void>>> entry : this.pendingWritesCallbacks.entrySet()) {
            for (TaskCompletionSource<Void> task : entry.getValue()) {
                task.setException((Exception)((Object)new FirebaseFirestoreException("'waitForPendingWrites' task is cancelled due to User change.", FirebaseFirestoreException.Code.CANCELLED)));
            }
        }
        this.pendingWritesCallbacks.clear();
    }

    private void notifyUser(int batchId, @Nullable Status status) {
        Integer boxedBatchId;
        TaskCompletionSource<Void> userTask;
        Map<Integer, TaskCompletionSource<Void>> userTasks = this.mutationUserCallbacks.get(this.currentUser);
        if (userTasks != null && (userTask = userTasks.get(boxedBatchId = Integer.valueOf(batchId))) != null) {
            if (status != null) {
                userTask.setException((Exception)((Object)Util.exceptionFromStatus(status)));
            } else {
                userTask.setResult(null);
            }
            userTasks.remove(boxedBatchId);
        }
    }

    private void removeAndCleanupTarget(int targetId, Status status) {
        for (Query query : this.queriesByTarget.get(targetId)) {
            this.queryViewsByQuery.remove(query);
            if (status.isOk()) continue;
            this.syncEngineListener.onError(query, status);
            this.logErrorIfInteresting(status, "Listen for %s failed", query);
        }
        this.queriesByTarget.remove(targetId);
        ImmutableSortedSet<DocumentKey> limboKeys = this.limboDocumentRefs.referencesForId(targetId);
        this.limboDocumentRefs.removeReferencesForId(targetId);
        for (DocumentKey key : limboKeys) {
            if (this.limboDocumentRefs.containsKey(key)) continue;
            this.removeLimboTarget(key);
        }
    }

    private void removeLimboTarget(DocumentKey key) {
        Integer targetId = this.limboTargetsByKey.get(key);
        if (targetId != null) {
            this.remoteStore.stopListening(targetId);
            this.limboTargetsByKey.remove(key);
            this.limboResolutionsByTarget.remove(targetId);
        }
    }

    private void emitNewSnapsAndNotifyLocalStore(ImmutableSortedMap<DocumentKey, MaybeDocument> changes, @Nullable RemoteEvent remoteEvent) {
        ArrayList<ViewSnapshot> newSnapshots = new ArrayList<ViewSnapshot>();
        ArrayList<LocalViewChanges> documentChangesInAllViews = new ArrayList<LocalViewChanges>();
        for (Map.Entry<Query, QueryView> entry : this.queryViewsByQuery.entrySet()) {
            QueryView queryView = entry.getValue();
            View view = queryView.getView();
            View.DocumentChanges viewDocChanges = view.computeDocChanges(changes);
            if (viewDocChanges.needsRefill()) {
                QueryResult queryResult = this.localStore.executeQuery(queryView.getQuery(), false);
                viewDocChanges = view.computeDocChanges(queryResult.getDocuments(), viewDocChanges);
            }
            TargetChange targetChange = remoteEvent == null ? null : remoteEvent.getTargetChanges().get(queryView.getTargetId());
            ViewChange viewChange = queryView.getView().applyChanges(viewDocChanges, targetChange);
            this.updateTrackedLimboDocuments(viewChange.getLimboChanges(), queryView.getTargetId());
            if (viewChange.getSnapshot() == null) continue;
            newSnapshots.add(viewChange.getSnapshot());
            LocalViewChanges docChanges = LocalViewChanges.fromViewSnapshot(queryView.getTargetId(), viewChange.getSnapshot());
            documentChangesInAllViews.add(docChanges);
        }
        this.syncEngineListener.onViewSnapshots(newSnapshots);
        this.localStore.notifyLocalViewChanges(documentChangesInAllViews);
    }

    private void updateTrackedLimboDocuments(List<LimboDocumentChange> limboChanges, int targetId) {
        block4: for (LimboDocumentChange limboChange : limboChanges) {
            switch (limboChange.getType()) {
                case ADDED: {
                    this.limboDocumentRefs.addReference(limboChange.getKey(), targetId);
                    this.trackLimboChange(limboChange);
                    continue block4;
                }
                case REMOVED: {
                    Logger.debug(TAG, "Document no longer in limbo: %s", limboChange.getKey());
                    DocumentKey limboDocKey = limboChange.getKey();
                    this.limboDocumentRefs.removeReference(limboDocKey, targetId);
                    if (this.limboDocumentRefs.containsKey(limboDocKey)) continue block4;
                    this.removeLimboTarget(limboDocKey);
                    continue block4;
                }
            }
            throw Assert.fail("Unknown limbo change type: %s", new Object[]{limboChange.getType()});
        }
    }

    private void trackLimboChange(LimboDocumentChange change) {
        DocumentKey key = change.getKey();
        if (!this.limboTargetsByKey.containsKey(key)) {
            Logger.debug(TAG, "New document in limbo: %s", key);
            int limboTargetId = this.targetIdGenerator.nextId();
            Query query = Query.atPath(key.getPath());
            QueryData queryData = new QueryData(query.toTarget(), limboTargetId, -1L, QueryPurpose.LIMBO_RESOLUTION);
            this.limboResolutionsByTarget.put(limboTargetId, new LimboResolution(key));
            this.remoteStore.listen(queryData);
            this.limboTargetsByKey.put(key, limboTargetId);
        }
    }

    @VisibleForTesting
    public Map<DocumentKey, Integer> getCurrentLimboDocuments() {
        return new HashMap<DocumentKey, Integer>(this.limboTargetsByKey);
    }

    public void handleCredentialChange(User user) {
        boolean userChanged = !this.currentUser.equals(user);
        this.currentUser = user;
        if (userChanged) {
            this.failOutstandingPendingWritesAwaitingTasks();
            ImmutableSortedMap<DocumentKey, MaybeDocument> changes = this.localStore.handleUserChange(user);
            this.emitNewSnapsAndNotifyLocalStore(changes, null);
        }
        this.remoteStore.handleCredentialChange();
    }

    private void logErrorIfInteresting(Status error, String contextString, Object ... contextArgs) {
        if (this.errorIsInteresting(error)) {
            String context = String.format(contextString, contextArgs);
            Logger.warn("Firestore", "%s: %s", context, error);
        }
    }

    private boolean errorIsInteresting(Status error) {
        String description;
        Status.Code code = error.getCode();
        String string = description = error.getDescription() != null ? error.getDescription() : "";
        if (code == Status.Code.FAILED_PRECONDITION && description.contains("requires an index")) {
            return true;
        }
        return code == Status.Code.PERMISSION_DENIED;
    }

    static interface SyncEngineCallback {
        public void onViewSnapshots(List<ViewSnapshot> var1);

        public void onError(Query var1, Status var2);

        public void handleOnlineStateChange(OnlineState var1);
    }

    private static class LimboResolution {
        private final DocumentKey key;
        private boolean receivedDocument;

        LimboResolution(DocumentKey key) {
            this.key = key;
        }
    }
}

