/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.remote.FirestoreChannel;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$1;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$2;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Supplier;
import com.google.firestore.v1.FirestoreGrpc;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.android.AndroidChannelBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GrpcCallProvider {
    private static final String LOG_TAG = "GrpcCallProvider";
    private static Supplier<ManagedChannelBuilder<?>> overrideChannelBuilderSupplier;
    private final Task<ManagedChannel> channelTask;
    private final AsyncQueue asyncQueue;
    private CallOptions callOptions;

    @VisibleForTesting
    public static void overrideChannelBuilder(Supplier<ManagedChannelBuilder<?>> channelBuilderSupplier) {
        overrideChannelBuilderSupplier = channelBuilderSupplier;
    }

    GrpcCallProvider(AsyncQueue asyncQueue, Context context, DatabaseInfo databaseInfo, CallCredentials firestoreHeaders) {
        this.asyncQueue = asyncQueue;
        this.channelTask = Tasks.call((Executor)Executors.BACKGROUND_EXECUTOR, (Callable)GrpcCallProvider$$Lambda$1.lambdaFactory$(this, context, databaseInfo, firestoreHeaders, asyncQueue));
    }

    private ManagedChannel initChannel(Context context, DatabaseInfo databaseInfo) {
        ManagedChannelBuilder channelBuilder;
        try {
            ProviderInstaller.installIfNeeded((Context)context);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IllegalStateException e) {
            Logger.warn(LOG_TAG, "Failed to update ssl context: %s", e);
        }
        if (overrideChannelBuilderSupplier != null) {
            channelBuilder = overrideChannelBuilderSupplier.get();
        } else {
            channelBuilder = ManagedChannelBuilder.forTarget((String)databaseInfo.getHost());
            if (!databaseInfo.isSslEnabled()) {
                channelBuilder.usePlaintext();
            }
        }
        channelBuilder.keepAliveTime(30L, TimeUnit.SECONDS);
        AndroidChannelBuilder androidChannelBuilder = AndroidChannelBuilder.fromBuilder((ManagedChannelBuilder)channelBuilder).context(context);
        return androidChannelBuilder.build();
    }

    <ReqT, RespT> Task<ClientCall<ReqT, RespT>> createClientCall(MethodDescriptor<ReqT, RespT> methodDescriptor) {
        return this.channelTask.continueWithTask(this.asyncQueue.getExecutor(), GrpcCallProvider$$Lambda$2.lambdaFactory$(this, methodDescriptor));
    }

    void shutdown() {
        ManagedChannel channel = null;
        try {
            channel = (ManagedChannel)Tasks.await(this.channelTask);
        }
        catch (ExecutionException e) {
            Logger.warn(FirestoreChannel.class.getSimpleName(), "Channel is not initialized, shutdown will just do nothing. Channel initializing run into exception: %s", e);
            return;
        }
        catch (InterruptedException e) {
            Logger.warn(FirestoreChannel.class.getSimpleName(), "Interrupted while retrieving the gRPC Managed Channel", new Object[0]);
            Thread.currentThread().interrupt();
            return;
        }
        channel.shutdown();
        try {
            if (!channel.awaitTermination(1L, TimeUnit.SECONDS)) {
                Logger.debug(FirestoreChannel.class.getSimpleName(), "Unable to gracefully shutdown the gRPC ManagedChannel. Will attempt an immediate shutdown.", new Object[0]);
                channel.shutdownNow();
                if (!channel.awaitTermination(60L, TimeUnit.SECONDS)) {
                    Logger.warn(FirestoreChannel.class.getSimpleName(), "Unable to forcefully shutdown the gRPC ManagedChannel.", new Object[0]);
                }
            }
        }
        catch (InterruptedException e) {
            channel.shutdownNow();
            Logger.warn(FirestoreChannel.class.getSimpleName(), "Interrupted while shutting down the gRPC Managed Channel", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    static /* synthetic */ Task lambda$createClientCall$1(GrpcCallProvider this_, MethodDescriptor methodDescriptor, Task task) throws Exception {
        return Tasks.forResult((Object)((ManagedChannel)task.getResult()).newCall(methodDescriptor, this_.callOptions));
    }

    static /* synthetic */ ManagedChannel lambda$new$0(GrpcCallProvider this_, Context context, DatabaseInfo databaseInfo, CallCredentials firestoreHeaders, AsyncQueue asyncQueue) throws Exception {
        ManagedChannel channel = this_.initChannel(context, databaseInfo);
        FirestoreGrpc.FirestoreStub firestoreStub = (FirestoreGrpc.FirestoreStub)((FirestoreGrpc.FirestoreStub)FirestoreGrpc.newStub((Channel)channel).withCallCredentials(firestoreHeaders)).withExecutor(asyncQueue.getExecutor());
        this_.callOptions = firestoreStub.getCallOptions();
        return channel;
    }
}

