/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.number;

import com.google.cloud.datastore.core.number.NumberParts;
import java.util.Arrays;

public class NumberIndexEncoder {
    private static final byte[] ENCODED_ZERO = new byte[]{-128};
    private static final byte[] ENCODED_NAN = new byte[]{0, 96};
    private static final byte[] ENCODED_NEGATIVE_INFINITY = new byte[]{0, -128};
    private static final byte[] ENCODED_POSITIVE_INFINITY = new byte[]{-1};
    private static final int EXP1_END = 4;
    private static final int EXP2_END = 20;
    private static final int EXP3_END = 148;
    private static final int EXP4_END = 1172;
    private static final int MAX_ENCODED_BYTES = 11;

    public static byte[] encodeDouble(double value) {
        return NumberIndexEncoder.encode(NumberParts.fromDouble(value));
    }

    public static byte[] encodeLong(long value) {
        return NumberIndexEncoder.encode(NumberParts.fromLong(value));
    }

    public static byte[] encode(NumberParts parts) {
        int lastByte;
        if (parts.isZero()) {
            return NumberIndexEncoder.copyOf(ENCODED_ZERO);
        }
        if (parts.isNaN()) {
            return NumberIndexEncoder.copyOf(ENCODED_NAN);
        }
        if (parts.isInfinite()) {
            return parts.negative() ? NumberIndexEncoder.copyOf(ENCODED_NEGATIVE_INFINITY) : NumberIndexEncoder.copyOf(ENCODED_POSITIVE_INFINITY);
        }
        int exponent = parts.exponent();
        long significand = parts.significand();
        byte[] buffer = new byte[11];
        int bufferPos = 0;
        int inverter = parts.negative() ? 255 : 0;
        int exponentMask = 0;
        if (exponent < 0) {
            exponent = -exponent;
            exponentMask = 255;
        }
        if (exponent < 4) {
            lastByte = 192;
            int significandStart = exponent + 1;
            lastByte |= 1 << significandStart;
            int significandMask = (1 << significandStart) - 2;
            lastByte |= (int)(significand >>> 64 - significandStart) & significandMask;
            significand <<= exponent;
            if (exponentMask != 0) {
                int exponentInverter = -1 << significandStart & 0x7E;
                lastByte ^= exponentInverter;
            }
        } else if (exponent < 20) {
            lastByte = 224;
            assert ((exponent -= 4) <= 15);
            lastByte |= exponent;
            buffer[bufferPos++] = (byte)(lastByte ^= 0x7F & exponentMask ^ inverter);
            lastByte = NumberIndexEncoder.topSignificandByte(significand);
            significand <<= 7;
        } else if (exponent < 148) {
            lastByte = 240;
            assert ((exponent -= 20) <= 127);
            lastByte |= exponent >>> 4;
            buffer[bufferPos++] = (byte)(lastByte ^= 0x7F & exponentMask ^ inverter);
            lastByte = exponent << 4 & 0xF0;
            lastByte |= (int)(significand >>> 60);
            buffer[bufferPos++] = (byte)(lastByte ^= 0xF0 & exponentMask ^ inverter);
            lastByte = NumberIndexEncoder.topSignificandByte(significand <<= 4);
            significand <<= 7;
        } else if (exponent < 1172) {
            lastByte = 248;
            assert ((exponent -= 148) <= 1023);
            lastByte |= exponent >>> 8;
            buffer[bufferPos++] = (byte)(lastByte ^= 0x7F & exponentMask ^ inverter);
            lastByte = exponent & 0xFF;
            buffer[bufferPos++] = (byte)(lastByte ^= 0xFF & exponentMask ^ inverter);
            lastByte = NumberIndexEncoder.topSignificandByte(significand);
            significand <<= 7;
        } else {
            throw new IllegalStateException("unimplemented");
        }
        while (significand != 0L) {
            lastByte |= 1;
            buffer[bufferPos++] = (byte)(lastByte ^= inverter);
            lastByte = NumberIndexEncoder.topSignificandByte(significand);
            significand <<= 7;
        }
        buffer[bufferPos++] = (byte)(lastByte ^= inverter);
        return Arrays.copyOf(buffer, bufferPos);
    }

    public static double decodeDouble(byte[] bytes) {
        return NumberIndexEncoder.decode(bytes).parts().asDouble();
    }

    public static long decodeLong(byte[] bytes) {
        return NumberIndexEncoder.decode(bytes).parts().asLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DecodedNumberParts decode(byte[] bytes) {
        int exponent;
        int b;
        int bufferPos = 0;
        if (bytes.length < 1) {
            throw new IllegalArgumentException("Invalid encoded byte array");
        }
        boolean negative = ((b = bytes[bufferPos++] & 0xFF) & 0x80) == 0;
        int inverter = negative ? 255 : 0;
        boolean exponentNegative = ((b ^= inverter) & 0x40) == 0;
        int exponentInverter = exponentNegative ? 255 : 0;
        long significand = 0L;
        int writeBit = 64;
        int marker = NumberIndexEncoder.decodeMarker(b ^ exponentInverter);
        switch (marker) {
            case -4: {
                if (exponentNegative) {
                    throw new IllegalArgumentException("Invalid encoded number " + Arrays.toString(bytes) + ": exponent negative zero is invalid");
                }
                exponent = 0;
                break;
            }
            case -3: 
            case -2: 
            case -1: {
                exponent = 4 + marker;
                int significandStart = exponent + 1;
                int significandMask = ~(-1 << significandStart) & 0x7E;
                significand |= (long)(b & significandMask) << (writeBit -= exponent) - 1;
                break;
            }
            case 1: {
                if (bytes.length < 2) {
                    throw new IllegalArgumentException("Invalid encoded byte array");
                }
                exponent = (b ^ exponentInverter) & 0xF;
                exponent += 4;
                b = bytes[bufferPos++] & 0xFF ^ inverter;
                significand |= NumberIndexEncoder.decodeTrailingSignificandByte(b, writeBit -= 7);
                break;
            }
            case 2: {
                if (bytes.length < 3) {
                    throw new IllegalArgumentException("Invalid encoded byte array");
                }
                exponent = ((b ^ exponentInverter) & 7) << 4;
                b = bytes[bufferPos++] & 0xFF ^ inverter;
                exponent |= (b ^ exponentInverter) >>> 4;
                exponent += 20;
                significand |= ((long)b & 0xFL) << (writeBit -= 4);
                b = bytes[bufferPos++] & 0xFF ^ inverter;
                significand |= NumberIndexEncoder.decodeTrailingSignificandByte(b, writeBit -= 7);
                break;
            }
            case 3: {
                if (bytes.length < 3) {
                    throw new IllegalArgumentException("Invalid encoded byte array");
                }
                exponent = ((b ^ exponentInverter) & 3) << 8;
                b = bytes[bufferPos++] & 0xFF ^ inverter;
                exponent |= b ^ exponentInverter;
                exponent += 148;
                b = bytes[bufferPos++] & 0xFF ^ inverter;
                significand |= NumberIndexEncoder.decodeTrailingSignificandByte(b, writeBit -= 7);
                break;
            }
            case 6: {
                NumberParts parts;
                if (negative) {
                    if (exponentNegative) {
                        parts = NumberParts.create(true, Integer.MIN_VALUE, 0L);
                        return DecodedNumberParts.create(bufferPos, parts);
                    } else {
                        if (bytes.length < 2) {
                            throw new IllegalArgumentException("Invalid encoded byte array");
                        }
                        if ((b = bytes[bufferPos++] & 0xFF) == 128) {
                            parts = NumberParts.create(true, Integer.MAX_VALUE, 0L);
                            return DecodedNumberParts.create(bufferPos, parts);
                        } else {
                            if (b != 96) throw new IllegalArgumentException("Invalid encoded byte array");
                            parts = NumberParts.create(true, Integer.MAX_VALUE, 1L);
                        }
                    }
                    return DecodedNumberParts.create(bufferPos, parts);
                } else {
                    parts = exponentNegative ? NumberParts.create(false, Integer.MIN_VALUE, 0L) : NumberParts.create(false, Integer.MAX_VALUE, 0L);
                }
                return DecodedNumberParts.create(bufferPos, parts);
            }
            default: {
                throw new IllegalArgumentException("Invalid encoded byte array");
            }
        }
        while ((b & 1) != 0) {
            if (bufferPos >= bytes.length) {
                throw new IllegalArgumentException("Invalid encoded byte array");
            }
            b = bytes[bufferPos++] & 0xFF ^ inverter;
            if ((writeBit -= 7) >= 0) {
                significand |= NumberIndexEncoder.decodeTrailingSignificandByte(b, writeBit);
                continue;
            }
            significand |= (long)(b & 0xFE) >>> -(writeBit - 1);
            writeBit = 0;
            if ((b & 1) == 0) continue;
            throw new IllegalArgumentException("Invalid encoded byte array: overlong sequence");
        }
        if (!exponentNegative) return DecodedNumberParts.create(bufferPos, NumberParts.create(negative, exponent, significand));
        exponent = -exponent;
        return DecodedNumberParts.create(bufferPos, NumberParts.create(negative, exponent, significand));
    }

    static int decodeMarker(int byteValue) {
        boolean leadingOne;
        boolean bl = leadingOne = (byteValue & 0x20) != 0;
        if (leadingOne) {
            byteValue ^= 0xFF;
        }
        int log2 = 31 - Integer.numberOfLeadingZeros(byteValue &= 0x3F);
        int leader = 5 - log2;
        return leadingOne ? leader : -leader;
    }

    private static long decodeTrailingSignificandByte(int value, int position) {
        return (long)(value & 0xFE) << position - 1;
    }

    private static int topSignificandByte(long significand) {
        return (int)(significand >>> 56) & 0xFE;
    }

    private static byte[] copyOf(byte[] value) {
        return (byte[])value.clone();
    }

    public static final class DecodedNumberParts {
        private final int bytesRead;
        private final NumberParts parts;

        private DecodedNumberParts(int bytesRead, NumberParts parts) {
            this.bytesRead = bytesRead;
            this.parts = parts;
        }

        public int bytesRead() {
            return this.bytesRead;
        }

        public NumberParts parts() {
            return this.parts;
        }

        static DecodedNumberParts create(int bytesRead, NumberParts parts) {
            return new DecodedNumberParts(bytesRead, parts);
        }
    }
}

