/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Function;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$1;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$10;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$11;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$12;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$13;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$14;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$15;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$2;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$3;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$4;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$5;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$6;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$7;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$8;
import com.google.firebase.firestore.core.FirestoreClient$$Lambda$9;
import com.google.firebase.firestore.core.OnlineState;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.QueryListener;
import com.google.firebase.firestore.core.SyncEngine;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.core.View;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.local.IndexFreeQueryEngine;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.MemoryPersistence;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.QueryResult;
import com.google.firebase.firestore.local.SQLiteLruReferenceDelegate;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatchResult;
import com.google.firebase.firestore.remote.AndroidConnectivityMonitor;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.GrpcMetadataProvider;
import com.google.firebase.firestore.remote.RemoteEvent;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.remote.RemoteStore;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import io.grpc.Status;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FirestoreClient
implements RemoteStore.RemoteStoreCallback {
    private static final String LOG_TAG = "FirestoreClient";
    private final DatabaseInfo databaseInfo;
    private final CredentialsProvider credentialsProvider;
    private final AsyncQueue asyncQueue;
    private Persistence persistence;
    private LocalStore localStore;
    private RemoteStore remoteStore;
    private SyncEngine syncEngine;
    private EventManager eventManager;
    private final GrpcMetadataProvider metadataProvider;
    @Nullable
    private LruGarbageCollector.Scheduler lruScheduler;

    public FirestoreClient(Context context, DatabaseInfo databaseInfo, FirebaseFirestoreSettings settings, CredentialsProvider credentialsProvider, AsyncQueue asyncQueue, @Nullable GrpcMetadataProvider metadataProvider) {
        this.databaseInfo = databaseInfo;
        this.credentialsProvider = credentialsProvider;
        this.asyncQueue = asyncQueue;
        this.metadataProvider = metadataProvider;
        TaskCompletionSource firstUser = new TaskCompletionSource();
        AtomicBoolean initialized = new AtomicBoolean(false);
        asyncQueue.enqueueAndForget(FirestoreClient$$Lambda$1.lambdaFactory$(this, firstUser, context, settings));
        credentialsProvider.setChangeListener(FirestoreClient$$Lambda$2.lambdaFactory$(this, initialized, firstUser, asyncQueue));
    }

    public Task<Void> disableNetwork() {
        this.verifyNotTerminated();
        return this.asyncQueue.enqueue(FirestoreClient$$Lambda$3.lambdaFactory$(this));
    }

    public Task<Void> enableNetwork() {
        this.verifyNotTerminated();
        return this.asyncQueue.enqueue(FirestoreClient$$Lambda$4.lambdaFactory$(this));
    }

    public Task<Void> terminate() {
        this.credentialsProvider.removeChangeListener();
        return this.asyncQueue.enqueueAndInitiateShutdown(FirestoreClient$$Lambda$5.lambdaFactory$(this));
    }

    public boolean isTerminated() {
        return this.asyncQueue.isShuttingDown();
    }

    public QueryListener listen(Query query, EventManager.ListenOptions options, EventListener<ViewSnapshot> listener) {
        this.verifyNotTerminated();
        QueryListener queryListener = new QueryListener(query, options, listener);
        this.asyncQueue.enqueueAndForget(FirestoreClient$$Lambda$6.lambdaFactory$(this, queryListener));
        return queryListener;
    }

    public void stopListening(QueryListener listener) {
        if (this.isTerminated()) {
            return;
        }
        this.asyncQueue.enqueueAndForget(FirestoreClient$$Lambda$7.lambdaFactory$(this, listener));
    }

    public Task<Document> getDocumentFromLocalCache(DocumentKey docKey) {
        this.verifyNotTerminated();
        return this.asyncQueue.enqueue(FirestoreClient$$Lambda$8.lambdaFactory$(this, docKey)).continueWith(FirestoreClient$$Lambda$9.lambdaFactory$());
    }

    public Task<ViewSnapshot> getDocumentsFromLocalCache(Query query) {
        this.verifyNotTerminated();
        return this.asyncQueue.enqueue(FirestoreClient$$Lambda$10.lambdaFactory$(this, query));
    }

    public Task<Void> write(List<Mutation> mutations) {
        this.verifyNotTerminated();
        TaskCompletionSource source = new TaskCompletionSource();
        this.asyncQueue.enqueueAndForget(FirestoreClient$$Lambda$11.lambdaFactory$(this, mutations, source));
        return source.getTask();
    }

    public <TResult> Task<TResult> transaction(Function<Transaction, Task<TResult>> updateFunction) {
        this.verifyNotTerminated();
        return AsyncQueue.callTask(this.asyncQueue.getExecutor(), FirestoreClient$$Lambda$12.lambdaFactory$(this, updateFunction));
    }

    public Task<Void> waitForPendingWrites() {
        this.verifyNotTerminated();
        TaskCompletionSource source = new TaskCompletionSource();
        this.asyncQueue.enqueueAndForget(FirestoreClient$$Lambda$13.lambdaFactory$(this, source));
        return source.getTask();
    }

    private void initialize(Context context, User user, boolean usePersistence, long cacheSizeBytes) {
        Logger.debug(LOG_TAG, "Initializing. user=%s", user.getUid());
        LruGarbageCollector gc = null;
        if (usePersistence) {
            LocalSerializer serializer = new LocalSerializer(new RemoteSerializer(this.databaseInfo.getDatabaseId()));
            LruGarbageCollector.Params params = LruGarbageCollector.Params.WithCacheSizeBytes(cacheSizeBytes);
            SQLitePersistence sqlitePersistence = new SQLitePersistence(context, this.databaseInfo.getPersistenceKey(), this.databaseInfo.getDatabaseId(), serializer, params);
            SQLiteLruReferenceDelegate lruDelegate = sqlitePersistence.getReferenceDelegate();
            gc = lruDelegate.getGarbageCollector();
            this.persistence = sqlitePersistence;
        } else {
            this.persistence = MemoryPersistence.createEagerGcMemoryPersistence();
        }
        this.persistence.start();
        IndexFreeQueryEngine queryEngine = new IndexFreeQueryEngine();
        this.localStore = new LocalStore(this.persistence, queryEngine, user);
        if (gc != null) {
            this.lruScheduler = gc.newScheduler(this.asyncQueue, this.localStore);
            this.lruScheduler.start();
        }
        Datastore datastore = new Datastore(this.databaseInfo, this.asyncQueue, this.credentialsProvider, context, this.metadataProvider);
        AndroidConnectivityMonitor connectivityMonitor = new AndroidConnectivityMonitor(context);
        this.remoteStore = new RemoteStore(this, this.localStore, datastore, this.asyncQueue, connectivityMonitor);
        this.syncEngine = new SyncEngine(this.localStore, this.remoteStore, user);
        this.eventManager = new EventManager(this.syncEngine);
        this.localStore.start();
        this.remoteStore.start();
    }

    public void addSnapshotsInSyncListener(EventListener<Void> listener) {
        this.verifyNotTerminated();
        this.asyncQueue.enqueueAndForget(FirestoreClient$$Lambda$14.lambdaFactory$(this, listener));
    }

    public void removeSnapshotsInSyncListener(EventListener<Void> listener) {
        if (this.isTerminated()) {
            return;
        }
        this.eventManager.removeSnapshotsInSyncListener(listener);
    }

    private void verifyNotTerminated() {
        if (this.isTerminated()) {
            throw new IllegalStateException("The client has already been terminated");
        }
    }

    @Override
    public void handleRemoteEvent(RemoteEvent remoteEvent) {
        this.syncEngine.handleRemoteEvent(remoteEvent);
    }

    @Override
    public void handleRejectedListen(int targetId, Status error) {
        this.syncEngine.handleRejectedListen(targetId, error);
    }

    @Override
    public void handleSuccessfulWrite(MutationBatchResult mutationBatchResult) {
        this.syncEngine.handleSuccessfulWrite(mutationBatchResult);
    }

    @Override
    public void handleRejectedWrite(int batchId, Status error) {
        this.syncEngine.handleRejectedWrite(batchId, error);
    }

    @Override
    public void handleOnlineStateChange(OnlineState onlineState) {
        this.syncEngine.handleOnlineStateChange(onlineState);
    }

    @Override
    public ImmutableSortedSet<DocumentKey> getRemoteKeysForTarget(int targetId) {
        return this.syncEngine.getRemoteKeysForTarget(targetId);
    }

    static /* synthetic */ void lambda$addSnapshotsInSyncListener$14(FirestoreClient this_, EventListener listener) {
        this_.eventManager.addSnapshotsInSyncListener(listener);
    }

    static /* synthetic */ void lambda$waitForPendingWrites$13(FirestoreClient this_, TaskCompletionSource source) {
        this_.syncEngine.registerPendingWritesTask((TaskCompletionSource<Void>)source);
    }

    static /* synthetic */ Task lambda$transaction$12(FirestoreClient this_, Function updateFunction) throws Exception {
        return this_.syncEngine.transaction(this_.asyncQueue, updateFunction);
    }

    static /* synthetic */ void lambda$write$11(FirestoreClient this_, List mutations, TaskCompletionSource source) {
        this_.syncEngine.writeMutations(mutations, (TaskCompletionSource<Void>)source);
    }

    static /* synthetic */ ViewSnapshot lambda$getDocumentsFromLocalCache$10(FirestoreClient this_, Query query) throws Exception {
        QueryResult queryResult = this_.localStore.executeQuery(query, true);
        View view = new View(query, queryResult.getRemoteKeys());
        View.DocumentChanges viewDocChanges = view.computeDocChanges(queryResult.getDocuments());
        return view.applyChanges(viewDocChanges).getSnapshot();
    }

    static /* synthetic */ Document lambda$getDocumentFromLocalCache$9(Task result) throws Exception {
        MaybeDocument maybeDoc = (MaybeDocument)result.getResult();
        if (maybeDoc instanceof Document) {
            return (Document)maybeDoc;
        }
        if (maybeDoc instanceof NoDocument) {
            return null;
        }
        throw new FirebaseFirestoreException("Failed to get document from cache. (However, this document may exist on the server. Run again without setting source to CACHE to attempt to retrieve the document from the server.)", FirebaseFirestoreException.Code.UNAVAILABLE);
    }

    static /* synthetic */ MaybeDocument lambda$getDocumentFromLocalCache$8(FirestoreClient this_, DocumentKey docKey) throws Exception {
        return this_.localStore.readDocument(docKey);
    }

    static /* synthetic */ void lambda$stopListening$7(FirestoreClient this_, QueryListener listener) {
        this_.eventManager.removeQueryListener(listener);
    }

    static /* synthetic */ void lambda$listen$6(FirestoreClient this_, QueryListener queryListener) {
        this_.eventManager.addQueryListener(queryListener);
    }

    static /* synthetic */ void lambda$terminate$5(FirestoreClient this_) {
        this_.remoteStore.shutdown();
        this_.persistence.shutdown();
        if (this_.lruScheduler != null) {
            this_.lruScheduler.stop();
        }
    }

    static /* synthetic */ void lambda$enableNetwork$4(FirestoreClient this_) {
        this_.remoteStore.enableNetwork();
    }

    static /* synthetic */ void lambda$disableNetwork$3(FirestoreClient this_) {
        this_.remoteStore.disableNetwork();
    }

    static /* synthetic */ void lambda$new$2(FirestoreClient this_, AtomicBoolean initialized, TaskCompletionSource firstUser, AsyncQueue asyncQueue, User user) {
        if (initialized.compareAndSet(false, true)) {
            Assert.hardAssert(!firstUser.getTask().isComplete(), "Already fulfilled first user task", new Object[0]);
            firstUser.setResult((Object)user);
        } else {
            asyncQueue.enqueueAndForget(FirestoreClient$$Lambda$15.lambdaFactory$(this_, user));
        }
    }

    static /* synthetic */ void lambda$new$1(FirestoreClient this_, User user) {
        Assert.hardAssert(this_.syncEngine != null, "SyncEngine not yet initialized", new Object[0]);
        Logger.debug(LOG_TAG, "Credential changed. Current user: %s", user.getUid());
        this_.syncEngine.handleCredentialChange(user);
    }

    static /* synthetic */ void lambda$new$0(FirestoreClient this_, TaskCompletionSource firstUser, Context context, FirebaseFirestoreSettings settings) {
        try {
            User initialUser = (User)Tasks.await((Task)firstUser.getTask());
            this_.initialize(context, initialUser, settings.isPersistenceEnabled(), settings.getCacheSizeBytes());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

