/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.DocumentViewChange;
import com.google.firebase.firestore.core.DocumentViewChangeSet;
import com.google.firebase.firestore.core.LimboDocumentChange;
import com.google.firebase.firestore.core.OnlineState;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.View$$Lambda$1;
import com.google.firebase.firestore.core.ViewChange;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.DocumentSet;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.remote.TargetChange;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class View {
    private final Query query;
    private ViewSnapshot.SyncState syncState;
    private boolean current;
    private DocumentSet documentSet;
    private ImmutableSortedSet<DocumentKey> syncedDocuments;
    private ImmutableSortedSet<DocumentKey> limboDocuments;
    private ImmutableSortedSet<DocumentKey> mutatedKeys;

    public View(Query query, ImmutableSortedSet<DocumentKey> remoteDocuments) {
        this.query = query;
        this.syncState = ViewSnapshot.SyncState.NONE;
        this.documentSet = DocumentSet.emptySet(query.comparator());
        this.syncedDocuments = remoteDocuments;
        this.limboDocuments = DocumentKey.emptyKeySet();
        this.mutatedKeys = DocumentKey.emptyKeySet();
    }

    public ViewSnapshot.SyncState getSyncState() {
        return this.syncState;
    }

    public <D extends MaybeDocument> DocumentChanges computeDocChanges(ImmutableSortedMap<DocumentKey, D> docChanges) {
        return this.computeDocChanges(docChanges, null);
    }

    public <D extends MaybeDocument> DocumentChanges computeDocChanges(ImmutableSortedMap<DocumentKey, D> docChanges, @Nullable DocumentChanges previousChanges) {
        DocumentViewChangeSet changeSet = previousChanges != null ? previousChanges.changeSet : new DocumentViewChangeSet();
        DocumentSet oldDocumentSet = previousChanges != null ? previousChanges.documentSet : this.documentSet;
        ImmutableSortedSet newMutatedKeys = previousChanges != null ? previousChanges.mutatedKeys : this.mutatedKeys;
        DocumentSet newDocumentSet = oldDocumentSet;
        boolean needsRefill = false;
        Document lastDocInLimit = this.query.hasLimitToFirst() && (long)oldDocumentSet.size() == this.query.getLimitToFirst() ? oldDocumentSet.getLastDocument() : null;
        Document firstDocInLimit = this.query.hasLimitToLast() && (long)oldDocumentSet.size() == this.query.getLimitToLast() ? oldDocumentSet.getFirstDocument() : null;
        for (Map.Entry entry : docChanges) {
            DocumentKey key = (DocumentKey)entry.getKey();
            Document oldDoc = oldDocumentSet.getDocument(key);
            Document newDoc = null;
            MaybeDocument maybeDoc = (MaybeDocument)entry.getValue();
            if (maybeDoc instanceof Document) {
                newDoc = (Document)maybeDoc;
            }
            if (newDoc != null) {
                Assert.hardAssert(key.equals(newDoc.getKey()), "Mismatching key in doc change %s != %s", key, newDoc.getKey());
                if (!this.query.matches(newDoc)) {
                    newDoc = null;
                }
            }
            boolean oldDocHadPendingMutations = oldDoc != null && this.mutatedKeys.contains((Object)oldDoc.getKey());
            boolean newDocHasPendingMutations = newDoc != null && (newDoc.hasLocalMutations() || this.mutatedKeys.contains((Object)newDoc.getKey()) && newDoc.hasCommittedMutations());
            boolean changeApplied = false;
            if (oldDoc != null && newDoc != null) {
                boolean docsEqual = oldDoc.getData().equals(newDoc.getData());
                if (!docsEqual) {
                    if (!this.shouldWaitForSyncedDocument(oldDoc, newDoc)) {
                        changeSet.addChange(DocumentViewChange.create(DocumentViewChange.Type.MODIFIED, newDoc));
                        changeApplied = true;
                        if (lastDocInLimit != null && this.query.comparator().compare(newDoc, lastDocInLimit) > 0 || firstDocInLimit != null && this.query.comparator().compare(newDoc, firstDocInLimit) < 0) {
                            needsRefill = true;
                        }
                    }
                } else if (oldDocHadPendingMutations != newDocHasPendingMutations) {
                    changeSet.addChange(DocumentViewChange.create(DocumentViewChange.Type.METADATA, newDoc));
                    changeApplied = true;
                }
            } else if (oldDoc == null && newDoc != null) {
                changeSet.addChange(DocumentViewChange.create(DocumentViewChange.Type.ADDED, newDoc));
                changeApplied = true;
            } else if (oldDoc != null && newDoc == null) {
                changeSet.addChange(DocumentViewChange.create(DocumentViewChange.Type.REMOVED, oldDoc));
                changeApplied = true;
                if (lastDocInLimit != null || firstDocInLimit != null) {
                    needsRefill = true;
                }
            }
            if (!changeApplied) continue;
            if (newDoc != null) {
                newDocumentSet = newDocumentSet.add(newDoc);
                if (newDoc.hasLocalMutations()) {
                    newMutatedKeys = newMutatedKeys.insert((Object)newDoc.getKey());
                    continue;
                }
                newMutatedKeys = newMutatedKeys.remove((Object)newDoc.getKey());
                continue;
            }
            newDocumentSet = newDocumentSet.remove(key);
            newMutatedKeys = newMutatedKeys.remove((Object)key);
        }
        if (this.query.hasLimitToFirst() || this.query.hasLimitToLast()) {
            long limit = this.query.hasLimitToFirst() ? this.query.getLimitToFirst() : this.query.getLimitToLast();
            for (long i = (long)newDocumentSet.size() - limit; i > 0L; --i) {
                Document oldDoc = this.query.hasLimitToFirst() ? newDocumentSet.getLastDocument() : newDocumentSet.getFirstDocument();
                newDocumentSet = newDocumentSet.remove(oldDoc.getKey());
                newMutatedKeys = newMutatedKeys.remove((Object)oldDoc.getKey());
                changeSet.addChange(DocumentViewChange.create(DocumentViewChange.Type.REMOVED, oldDoc));
            }
        }
        Assert.hardAssert(!needsRefill || previousChanges == null, "View was refilled using docs that themselves needed refilling.", new Object[0]);
        return new DocumentChanges(newDocumentSet, changeSet, newMutatedKeys, needsRefill);
    }

    private boolean shouldWaitForSyncedDocument(Document oldDoc, Document newDoc) {
        return oldDoc.hasLocalMutations() && newDoc.hasCommittedMutations() && !newDoc.hasLocalMutations();
    }

    public ViewChange applyChanges(DocumentChanges docChanges) {
        return this.applyChanges(docChanges, null);
    }

    public ViewChange applyChanges(DocumentChanges docChanges, TargetChange targetChange) {
        Assert.hardAssert(!docChanges.needsRefill, "Cannot apply changes that need a refill", new Object[0]);
        DocumentSet oldDocumentSet = this.documentSet;
        this.documentSet = docChanges.documentSet;
        this.mutatedKeys = docChanges.mutatedKeys;
        List<DocumentViewChange> viewChanges = docChanges.changeSet.getChanges();
        Collections.sort(viewChanges, View$$Lambda$1.lambdaFactory$(this));
        this.applyTargetChange(targetChange);
        List<LimboDocumentChange> limboDocumentChanges = this.updateLimboDocuments();
        boolean synced = this.limboDocuments.size() == 0 && this.current;
        ViewSnapshot.SyncState newSyncState = synced ? ViewSnapshot.SyncState.SYNCED : ViewSnapshot.SyncState.LOCAL;
        boolean syncStatedChanged = newSyncState != this.syncState;
        this.syncState = newSyncState;
        ViewSnapshot snapshot = null;
        if (viewChanges.size() != 0 || syncStatedChanged) {
            boolean fromCache = newSyncState == ViewSnapshot.SyncState.LOCAL;
            snapshot = new ViewSnapshot(this.query, docChanges.documentSet, oldDocumentSet, viewChanges, fromCache, docChanges.mutatedKeys, syncStatedChanged, false);
        }
        return new ViewChange(snapshot, limboDocumentChanges);
    }

    public ViewChange applyOnlineStateChange(OnlineState onlineState) {
        if (this.current && onlineState == OnlineState.OFFLINE) {
            this.current = false;
            return this.applyChanges(new DocumentChanges(this.documentSet, new DocumentViewChangeSet(), this.mutatedKeys, false));
        }
        return new ViewChange(null, Collections.<LimboDocumentChange>emptyList());
    }

    private void applyTargetChange(TargetChange targetChange) {
        if (targetChange != null) {
            for (DocumentKey documentKey : targetChange.getAddedDocuments()) {
                this.syncedDocuments = this.syncedDocuments.insert((Object)documentKey);
            }
            for (DocumentKey documentKey : targetChange.getModifiedDocuments()) {
                Assert.hardAssert(this.syncedDocuments.contains((Object)documentKey), "Modified document %s not found in view.", documentKey);
            }
            for (DocumentKey documentKey : targetChange.getRemovedDocuments()) {
                this.syncedDocuments = this.syncedDocuments.remove((Object)documentKey);
            }
            this.current = targetChange.isCurrent();
        }
    }

    private List<LimboDocumentChange> updateLimboDocuments() {
        if (!this.current) {
            return Collections.emptyList();
        }
        ImmutableSortedSet<DocumentKey> oldLimboDocs = this.limboDocuments;
        this.limboDocuments = DocumentKey.emptyKeySet();
        for (Document doc : this.documentSet) {
            if (!this.shouldBeLimboDoc(doc.getKey())) continue;
            this.limboDocuments = this.limboDocuments.insert((Object)doc.getKey());
        }
        ArrayList<LimboDocumentChange> changes = new ArrayList<LimboDocumentChange>(oldLimboDocs.size() + this.limboDocuments.size());
        for (DocumentKey key : oldLimboDocs) {
            if (this.limboDocuments.contains((Object)key)) continue;
            changes.add(new LimboDocumentChange(LimboDocumentChange.Type.REMOVED, key));
        }
        for (DocumentKey key : this.limboDocuments) {
            if (oldLimboDocs.contains((Object)key)) continue;
            changes.add(new LimboDocumentChange(LimboDocumentChange.Type.ADDED, key));
        }
        return changes;
    }

    private boolean shouldBeLimboDoc(DocumentKey key) {
        if (this.syncedDocuments.contains((Object)key)) {
            return false;
        }
        Document doc = this.documentSet.getDocument(key);
        if (doc == null) {
            return false;
        }
        return !doc.hasLocalMutations();
    }

    ImmutableSortedSet<DocumentKey> getLimboDocuments() {
        return this.limboDocuments;
    }

    ImmutableSortedSet<DocumentKey> getSyncedDocuments() {
        return this.syncedDocuments;
    }

    private static int changeTypeOrder(DocumentViewChange change) {
        switch (change.getType()) {
            case ADDED: {
                return 1;
            }
            case MODIFIED: {
                return 2;
            }
            case METADATA: {
                return 2;
            }
            case REMOVED: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unknown change type: " + (Object)((Object)change.getType()));
    }

    static /* synthetic */ int lambda$applyChanges$0(View this_, DocumentViewChange o1, DocumentViewChange o2) {
        int typeComp = Util.compareIntegers(View.changeTypeOrder(o1), View.changeTypeOrder(o2));
        o1.getType().compareTo(o2.getType());
        if (typeComp != 0) {
            return typeComp;
        }
        return this_.query.comparator().compare(o1.getDocument(), o2.getDocument());
    }

    public static class DocumentChanges {
        final DocumentSet documentSet;
        final DocumentViewChangeSet changeSet;
        private final boolean needsRefill;
        final ImmutableSortedSet<DocumentKey> mutatedKeys;

        private DocumentChanges(DocumentSet newDocuments, DocumentViewChangeSet changes, ImmutableSortedSet<DocumentKey> mutatedKeys, boolean needsRefill) {
            this.documentSet = newDocuments;
            this.changeSet = changes;
            this.mutatedKeys = mutatedKeys;
            this.needsRefill = needsRefill;
        }

        public boolean needsRefill() {
            return this.needsRefill;
        }
    }
}

