/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.common.base.Preconditions;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.remote.WatchStream;
import com.google.protobuf.ByteString;

public final class TargetData {
    private final Target target;
    private final int targetId;
    private final long sequenceNumber;
    private final QueryPurpose purpose;
    private final SnapshotVersion snapshotVersion;
    private final SnapshotVersion lastLimboFreeSnapshotVersion;
    private final ByteString resumeToken;

    TargetData(Target target, int targetId, long sequenceNumber, QueryPurpose purpose, SnapshotVersion snapshotVersion, SnapshotVersion lastLimboFreeSnapshotVersion, ByteString resumeToken) {
        this.target = (Target)Preconditions.checkNotNull((Object)target);
        this.targetId = targetId;
        this.sequenceNumber = sequenceNumber;
        this.lastLimboFreeSnapshotVersion = lastLimboFreeSnapshotVersion;
        this.purpose = purpose;
        this.snapshotVersion = (SnapshotVersion)Preconditions.checkNotNull((Object)snapshotVersion);
        this.resumeToken = (ByteString)Preconditions.checkNotNull((Object)resumeToken);
    }

    public TargetData(Target target, int targetId, long sequenceNumber, QueryPurpose purpose) {
        this(target, targetId, sequenceNumber, purpose, SnapshotVersion.NONE, SnapshotVersion.NONE, WatchStream.EMPTY_RESUME_TOKEN);
    }

    public TargetData withSequenceNumber(long sequenceNumber) {
        return new TargetData(this.target, this.targetId, sequenceNumber, this.purpose, this.snapshotVersion, this.lastLimboFreeSnapshotVersion, this.resumeToken);
    }

    public TargetData withResumeToken(ByteString resumeToken, SnapshotVersion snapshotVersion) {
        return new TargetData(this.target, this.targetId, this.sequenceNumber, this.purpose, snapshotVersion, this.lastLimboFreeSnapshotVersion, resumeToken);
    }

    public TargetData withLastLimboFreeSnapshotVersion(SnapshotVersion lastLimboFreeSnapshotVersion) {
        return new TargetData(this.target, this.targetId, this.sequenceNumber, this.purpose, this.snapshotVersion, lastLimboFreeSnapshotVersion, this.resumeToken);
    }

    public Target getTarget() {
        return this.target;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public QueryPurpose getPurpose() {
        return this.purpose;
    }

    public SnapshotVersion getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public ByteString getResumeToken() {
        return this.resumeToken;
    }

    public SnapshotVersion getLastLimboFreeSnapshotVersion() {
        return this.lastLimboFreeSnapshotVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetData targetData = (TargetData)o;
        return this.target.equals(targetData.target) && this.targetId == targetData.targetId && this.sequenceNumber == targetData.sequenceNumber && this.purpose.equals((Object)targetData.purpose) && this.snapshotVersion.equals(targetData.snapshotVersion) && this.lastLimboFreeSnapshotVersion.equals(targetData.lastLimboFreeSnapshotVersion) && this.resumeToken.equals((Object)targetData.resumeToken);
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = 31 * result + this.targetId;
        result = 31 * result + (int)this.sequenceNumber;
        result = 31 * result + this.purpose.hashCode();
        result = 31 * result + this.snapshotVersion.hashCode();
        result = 31 * result + this.lastLimboFreeSnapshotVersion.hashCode();
        result = 31 * result + this.resumeToken.hashCode();
        return result;
    }

    public String toString() {
        return "TargetData{target=" + this.target + ", targetId=" + this.targetId + ", sequenceNumber=" + this.sequenceNumber + ", purpose=" + (Object)((Object)this.purpose) + ", snapshotVersion=" + this.snapshotVersion + ", lastLimboFreeSnapshotVersion=" + this.lastLimboFreeSnapshotVersion + ", resumeToken=" + this.resumeToken + '}';
    }
}

