/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.util.Util;

public class BooleanValue
extends FieldValue {
    private static final BooleanValue TRUE_VALUE = new BooleanValue(Boolean.TRUE);
    private static final BooleanValue FALSE_VALUE = new BooleanValue(Boolean.FALSE);
    private final boolean internalValue;

    private BooleanValue(Boolean b) {
        this.internalValue = b;
    }

    @Override
    public int typeOrder() {
        return 1;
    }

    @Override
    public Boolean value() {
        return this.internalValue;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return this.internalValue ? 1 : 0;
    }

    @Override
    public int compareTo(FieldValue o) {
        if (o instanceof BooleanValue) {
            return Util.compareBooleans(this.internalValue, ((BooleanValue)o).internalValue);
        }
        return this.defaultCompareTo(o);
    }

    public static BooleanValue valueOf(Boolean b) {
        return b != false ? TRUE_VALUE : FALSE_VALUE;
    }
}

