/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.SnapshotMetadata;
import com.google.firebase.firestore.UserDataWriter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.util.CustomClassMapper;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firestore.v1.Value;
import java.util.Date;
import java.util.Map;

public class DocumentSnapshot {
    private final FirebaseFirestore firestore;
    private final DocumentKey key;
    @Nullable
    private final Document doc;
    private final SnapshotMetadata metadata;

    DocumentSnapshot(FirebaseFirestore firestore, DocumentKey key, @Nullable Document doc, boolean isFromCache, boolean hasPendingWrites) {
        this.firestore = Preconditions.checkNotNull(firestore);
        this.key = Preconditions.checkNotNull(key);
        this.doc = doc;
        this.metadata = new SnapshotMetadata(hasPendingWrites, isFromCache);
    }

    static DocumentSnapshot fromDocument(FirebaseFirestore firestore, Document doc, boolean fromCache, boolean hasPendingWrites) {
        return new DocumentSnapshot(firestore, doc.getKey(), doc, fromCache, hasPendingWrites);
    }

    static DocumentSnapshot fromNoDocument(FirebaseFirestore firestore, DocumentKey key, boolean fromCache, boolean hasPendingWrites) {
        return new DocumentSnapshot(firestore, key, null, fromCache, hasPendingWrites);
    }

    @NonNull
    public String getId() {
        return this.key.getPath().getLastSegment();
    }

    @NonNull
    public SnapshotMetadata getMetadata() {
        return this.metadata;
    }

    public boolean exists() {
        return this.doc != null;
    }

    @Nullable
    Document getDocument() {
        return this.doc;
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.getData(ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    public Map<String, Object> getData(@NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull(serverTimestampBehavior, "Provided serverTimestampBehavior value must not be null.");
        UserDataWriter userDataWriter = new UserDataWriter(this.firestore, this.firestore.getFirestoreSettings().areTimestampsInSnapshotsEnabled(), serverTimestampBehavior);
        return this.doc == null ? null : userDataWriter.convertObject(this.doc.getData().getFieldsMap());
    }

    @Nullable
    public <T> T toObject(@NonNull Class<T> valueType) {
        return this.toObject(valueType, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    public <T> T toObject(@NonNull Class<T> valueType, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull(valueType, "Provided POJO type must not be null.");
        Preconditions.checkNotNull(serverTimestampBehavior, "Provided serverTimestampBehavior value must not be null.");
        Map<String, Object> data = this.getData(serverTimestampBehavior);
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType, this.getReference());
    }

    public boolean contains(@NonNull String field) {
        return this.contains(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field));
    }

    public boolean contains(@NonNull com.google.firebase.firestore.FieldPath fieldPath) {
        Preconditions.checkNotNull(fieldPath, "Provided field path must not be null.");
        return this.doc != null && this.doc.getField(fieldPath.getInternalPath()) != null;
    }

    @Nullable
    public Object get(@NonNull String field) {
        return this.get(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field), ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    public Object get(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        return this.get(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field), serverTimestampBehavior);
    }

    @Nullable
    public Object get(@NonNull com.google.firebase.firestore.FieldPath fieldPath) {
        return this.get(fieldPath, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    public Object get(@NonNull com.google.firebase.firestore.FieldPath fieldPath, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull(fieldPath, "Provided field path must not be null.");
        Preconditions.checkNotNull(serverTimestampBehavior, "Provided serverTimestampBehavior value must not be null.");
        return this.getInternal(fieldPath.getInternalPath(), serverTimestampBehavior, this.firestore.getFirestoreSettings().areTimestampsInSnapshotsEnabled());
    }

    @Nullable
    public <T> T get(@NonNull String field, @NonNull Class<T> valueType) {
        return this.get(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field), valueType, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    public <T> T get(@NonNull String field, @NonNull Class<T> valueType, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        return this.get(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field), valueType, serverTimestampBehavior);
    }

    @Nullable
    public <T> T get(@NonNull com.google.firebase.firestore.FieldPath fieldPath, @NonNull Class<T> valueType) {
        return this.get(fieldPath, valueType, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    public <T> T get(@NonNull com.google.firebase.firestore.FieldPath fieldPath, @NonNull Class<T> valueType, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Object data = this.get(fieldPath, serverTimestampBehavior);
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType, this.getReference());
    }

    @Nullable
    public Boolean getBoolean(@NonNull String field) {
        return this.getTypedValue(field, Boolean.class);
    }

    @Nullable
    public Double getDouble(@NonNull String field) {
        Number val = this.getTypedValue(field, Number.class);
        return val != null ? Double.valueOf(val.doubleValue()) : null;
    }

    @Nullable
    public String getString(@NonNull String field) {
        return this.getTypedValue(field, String.class);
    }

    @Nullable
    public Long getLong(@NonNull String field) {
        Number val = this.getTypedValue(field, Number.class);
        return val != null ? Long.valueOf(val.longValue()) : null;
    }

    @Nullable
    public Date getDate(@NonNull String field) {
        return this.getDate(field, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    public Date getDate(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull(field, "Provided field path must not be null.");
        Preconditions.checkNotNull(serverTimestampBehavior, "Provided serverTimestampBehavior value must not be null.");
        Object maybeDate = this.getInternal(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field).getInternalPath(), serverTimestampBehavior, false);
        return this.castTypedValue(maybeDate, field, Date.class);
    }

    @Nullable
    public Timestamp getTimestamp(@NonNull String field) {
        return this.getTimestamp(field, ServerTimestampBehavior.DEFAULT);
    }

    @Nullable
    public Timestamp getTimestamp(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull(field, "Provided field path must not be null.");
        Preconditions.checkNotNull(serverTimestampBehavior, "Provided serverTimestampBehavior value must not be null.");
        Object maybeTimestamp = this.getInternal(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field).getInternalPath(), serverTimestampBehavior, true);
        return this.castTypedValue(maybeTimestamp, field, Timestamp.class);
    }

    @Nullable
    public Blob getBlob(@NonNull String field) {
        return this.getTypedValue(field, Blob.class);
    }

    @Nullable
    public GeoPoint getGeoPoint(@NonNull String field) {
        return this.getTypedValue(field, GeoPoint.class);
    }

    @Nullable
    public DocumentReference getDocumentReference(@NonNull String field) {
        return this.getTypedValue(field, DocumentReference.class);
    }

    @NonNull
    public DocumentReference getReference() {
        return new DocumentReference(this.key, this.firestore);
    }

    @Nullable
    private <T> T getTypedValue(String field, Class<T> clazz) {
        Preconditions.checkNotNull(field, "Provided field must not be null.");
        Object value = this.get(field, ServerTimestampBehavior.DEFAULT);
        return this.castTypedValue(value, field, clazz);
    }

    @Nullable
    private <T> T castTypedValue(Object value, String field, Class<T> clazz) {
        if (value == null) {
            return null;
        }
        if (!clazz.isInstance(value)) {
            throw new RuntimeException("Field '" + field + "' is not a " + clazz.getName());
        }
        return clazz.cast(value);
    }

    @Nullable
    private Object getInternal(@NonNull FieldPath fieldPath, @NonNull ServerTimestampBehavior serverTimestampBehavior, boolean timestampsInSnapshots) {
        Value val;
        if (this.doc != null && (val = this.doc.getField(fieldPath)) != null) {
            UserDataWriter userDataWriter = new UserDataWriter(this.firestore, timestampsInSnapshots, serverTimestampBehavior);
            return userDataWriter.convertValue(val);
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DocumentSnapshot)) {
            return false;
        }
        DocumentSnapshot other = (DocumentSnapshot)obj;
        return this.firestore.equals(other.firestore) && this.key.equals(other.key) && (this.doc == null ? other.doc == null : this.doc.equals(other.doc)) && this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        int hash = this.firestore.hashCode();
        hash = hash * 31 + this.key.hashCode();
        hash = hash * 31 + (this.doc != null ? this.doc.hashCode() : 0);
        hash = hash * 31 + this.metadata.hashCode();
        return hash;
    }

    public String toString() {
        return "DocumentSnapshot{key=" + this.key + ", metadata=" + this.metadata + ", doc=" + this.doc + '}';
    }

    public static enum ServerTimestampBehavior {
        NONE,
        ESTIMATE,
        PREVIOUS;

        static final ServerTimestampBehavior DEFAULT;

        static {
            DEFAULT = NONE;
        }
    }
}

