/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseAppLifecycleListener;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.remote.GrpcMetadataProvider;
import java.util.HashMap;
import java.util.Map;

class FirestoreMultiDbComponent
implements FirebaseAppLifecycleListener,
FirebaseFirestore.InstanceRegistry {
    private final Map<String, FirebaseFirestore> instances = new HashMap<String, FirebaseFirestore>();
    private final FirebaseApp app;
    private final Context context;
    private final InternalAuthProvider authProvider;
    private final GrpcMetadataProvider metadataProvider;

    FirestoreMultiDbComponent(@NonNull Context context, @NonNull FirebaseApp app, @Nullable InternalAuthProvider authProvider, @Nullable GrpcMetadataProvider metadataProvider) {
        this.context = context;
        this.app = app;
        this.authProvider = authProvider;
        this.metadataProvider = metadataProvider;
        this.app.addLifecycleEventListener((FirebaseAppLifecycleListener)this);
    }

    @NonNull
    synchronized FirebaseFirestore get(@NonNull String databaseId) {
        FirebaseFirestore firestore = this.instances.get(databaseId);
        if (firestore == null) {
            firestore = FirebaseFirestore.newInstance(this.context, this.app, this.authProvider, databaseId, this, this.metadataProvider);
            this.instances.put(databaseId, firestore);
        }
        return firestore;
    }

    @Override
    public synchronized void remove(@NonNull String databaseId) {
        this.instances.remove(databaseId);
    }

    public synchronized void onDeleted(String firebaseAppName, FirebaseOptions options) {
        for (Map.Entry<String, FirebaseFirestore> entry : this.instances.entrySet()) {
            entry.getValue().terminateInternal();
            this.instances.remove(entry.getKey());
        }
    }
}

