/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.model.mutation.PatchMutation;
import com.google.firebase.firestore.util.Assert;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class LocalDocumentsView {
    private final RemoteDocumentCache remoteDocumentCache;
    private final MutationQueue mutationQueue;
    private final IndexManager indexManager;

    LocalDocumentsView(RemoteDocumentCache remoteDocumentCache, MutationQueue mutationQueue, IndexManager indexManager) {
        this.remoteDocumentCache = remoteDocumentCache;
        this.mutationQueue = mutationQueue;
        this.indexManager = indexManager;
    }

    @VisibleForTesting
    RemoteDocumentCache getRemoteDocumentCache() {
        return this.remoteDocumentCache;
    }

    @VisibleForTesting
    MutationQueue getMutationQueue() {
        return this.mutationQueue;
    }

    @VisibleForTesting
    IndexManager getIndexManager() {
        return this.indexManager;
    }

    @Nullable
    MaybeDocument getDocument(DocumentKey key) {
        List<MutationBatch> batches = this.mutationQueue.getAllMutationBatchesAffectingDocumentKey(key);
        return this.getDocument(key, batches);
    }

    @Nullable
    private MaybeDocument getDocument(DocumentKey key, List<MutationBatch> inBatches) {
        MaybeDocument document = this.remoteDocumentCache.get(key);
        for (MutationBatch batch : inBatches) {
            document = batch.applyToLocalView(key, document);
        }
        return document;
    }

    private Map<DocumentKey, MaybeDocument> applyLocalMutationsToDocuments(Map<DocumentKey, MaybeDocument> docs, List<MutationBatch> batches) {
        for (Map.Entry<DocumentKey, MaybeDocument> base : docs.entrySet()) {
            MaybeDocument localView = base.getValue();
            for (MutationBatch batch : batches) {
                localView = batch.applyToLocalView(base.getKey(), localView);
            }
            base.setValue(localView);
        }
        return docs;
    }

    ImmutableSortedMap<DocumentKey, MaybeDocument> getDocuments(Iterable<DocumentKey> keys) {
        Map<DocumentKey, MaybeDocument> docs = this.remoteDocumentCache.getAll(keys);
        return this.getLocalViewOfDocuments(docs);
    }

    ImmutableSortedMap<DocumentKey, MaybeDocument> getLocalViewOfDocuments(Map<DocumentKey, MaybeDocument> baseDocs) {
        ImmutableSortedMap results = DocumentCollections.emptyMaybeDocumentMap();
        List<MutationBatch> batches = this.mutationQueue.getAllMutationBatchesAffectingDocumentKeys(baseDocs.keySet());
        Map<DocumentKey, MaybeDocument> docs = this.applyLocalMutationsToDocuments(baseDocs, batches);
        for (Map.Entry<DocumentKey, MaybeDocument> entry : docs.entrySet()) {
            DocumentKey key = entry.getKey();
            MaybeDocument maybeDoc = entry.getValue();
            if (maybeDoc == null) {
                maybeDoc = new NoDocument(key, SnapshotVersion.NONE, false);
            }
            results = results.insert((Object)key, (Object)maybeDoc);
        }
        return results;
    }

    ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingQuery(Query query, SnapshotVersion sinceReadTime) {
        ResourcePath path = query.getPath();
        if (query.isDocumentQuery()) {
            return this.getDocumentsMatchingDocumentQuery(path);
        }
        if (query.isCollectionGroupQuery()) {
            return this.getDocumentsMatchingCollectionGroupQuery(query, sinceReadTime);
        }
        return this.getDocumentsMatchingCollectionQuery(query, sinceReadTime);
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingDocumentQuery(ResourcePath path) {
        ImmutableSortedMap result = DocumentCollections.emptyDocumentMap();
        MaybeDocument doc = this.getDocument(DocumentKey.fromPath(path));
        if (doc instanceof Document) {
            result = result.insert((Object)doc.getKey(), (Object)((Document)doc));
        }
        return result;
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingCollectionGroupQuery(Query query, SnapshotVersion sinceReadTime) {
        Assert.hardAssert(query.getPath().isEmpty(), "Currently we only support collection group queries at the root.", new Object[0]);
        String collectionId = query.getCollectionGroup();
        ImmutableSortedMap results = DocumentCollections.emptyDocumentMap();
        List<ResourcePath> parents = this.indexManager.getCollectionParents(collectionId);
        for (ResourcePath parent : parents) {
            Query collectionQuery = query.asCollectionQueryAtPath((ResourcePath)((Object)parent.append(collectionId)));
            ImmutableSortedMap<DocumentKey, Document> collectionResults = this.getDocumentsMatchingCollectionQuery(collectionQuery, sinceReadTime);
            for (Map.Entry docEntry : collectionResults) {
                results = results.insert((Object)((DocumentKey)docEntry.getKey()), (Object)((Document)docEntry.getValue()));
            }
        }
        return results;
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingCollectionQuery(Query query, SnapshotVersion sinceReadTime) {
        ImmutableSortedMap results = this.remoteDocumentCache.getAllDocumentsMatchingQuery(query, sinceReadTime);
        List<MutationBatch> matchingBatches = this.mutationQueue.getAllMutationBatchesAffectingQuery(query);
        results = this.addMissingBaseDocuments(matchingBatches, results);
        for (MutationBatch batch : matchingBatches) {
            for (Mutation mutation : batch.getMutations()) {
                if (!query.getPath().isImmediateParentOf(mutation.getKey().getPath())) continue;
                DocumentKey key = mutation.getKey();
                MaybeDocument baseDoc = (MaybeDocument)results.get((Object)key);
                MaybeDocument mutatedDoc = mutation.applyToLocalView(baseDoc, baseDoc, batch.getLocalWriteTime());
                if (mutatedDoc instanceof Document) {
                    results = results.insert((Object)key, (Object)((Document)mutatedDoc));
                    continue;
                }
                results = results.remove((Object)key);
            }
        }
        for (Map.Entry docEntry : results) {
            if (query.matches((Document)docEntry.getValue())) continue;
            results = results.remove((Object)((DocumentKey)docEntry.getKey()));
        }
        return results;
    }

    private ImmutableSortedMap<DocumentKey, Document> addMissingBaseDocuments(List<MutationBatch> matchingBatches, ImmutableSortedMap<DocumentKey, Document> existingDocs) {
        HashSet<DocumentKey> missingDocKeys = new HashSet<DocumentKey>();
        for (MutationBatch batch : matchingBatches) {
            for (Mutation mutation : batch.getMutations()) {
                if (!(mutation instanceof PatchMutation) || existingDocs.containsKey((Object)mutation.getKey())) continue;
                missingDocKeys.add(mutation.getKey());
            }
        }
        ImmutableSortedMap mergedDocs = existingDocs;
        Map<DocumentKey, MaybeDocument> missingDocs = this.remoteDocumentCache.getAll(missingDocKeys);
        for (Map.Entry entry : missingDocs.entrySet()) {
            if (entry.getValue() == null || !(entry.getValue() instanceof Document)) continue;
            mergedDocs = mergedDocs.insert((Object)((DocumentKey)entry.getKey()), (Object)((Document)entry.getValue()));
        }
        return mergedDocs;
    }
}

