/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.SparseArray;
import com.google.firebase.firestore.core.ListenSequence;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.LruDelegate;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.MemoryLruReferenceDelegate$$Lambda$1;
import com.google.firebase.firestore.local.MemoryMutationQueue;
import com.google.firebase.firestore.local.MemoryPersistence;
import com.google.firebase.firestore.local.MemoryRemoteDocumentCache;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.local.TargetData;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;
import java.util.HashMap;
import java.util.Map;

class MemoryLruReferenceDelegate
implements ReferenceDelegate,
LruDelegate {
    private final MemoryPersistence persistence;
    private final LocalSerializer serializer;
    private final Map<DocumentKey, Long> orphanedSequenceNumbers;
    private ReferenceSet inMemoryPins;
    private final LruGarbageCollector garbageCollector;
    private final ListenSequence listenSequence;
    private long currentSequenceNumber;

    MemoryLruReferenceDelegate(MemoryPersistence persistence, LruGarbageCollector.Params params, LocalSerializer serializer) {
        this.persistence = persistence;
        this.serializer = serializer;
        this.orphanedSequenceNumbers = new HashMap<DocumentKey, Long>();
        this.listenSequence = new ListenSequence(persistence.getTargetCache().getHighestListenSequenceNumber());
        this.currentSequenceNumber = -1L;
        this.garbageCollector = new LruGarbageCollector(this, params);
    }

    @Override
    public LruGarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    @Override
    public void onTransactionStarted() {
        Assert.hardAssert(this.currentSequenceNumber == -1L, "Starting a transaction without committing the previous one", new Object[0]);
        this.currentSequenceNumber = this.listenSequence.next();
    }

    @Override
    public void onTransactionCommitted() {
        Assert.hardAssert(this.currentSequenceNumber != -1L, "Committing a transaction without having started one", new Object[0]);
        this.currentSequenceNumber = -1L;
    }

    @Override
    public long getCurrentSequenceNumber() {
        Assert.hardAssert(this.currentSequenceNumber != -1L, "Attempting to get a sequence number outside of a transaction", new Object[0]);
        return this.currentSequenceNumber;
    }

    @Override
    public void forEachTarget(Consumer<TargetData> consumer) {
        this.persistence.getTargetCache().forEachTarget(consumer);
    }

    @Override
    public long getSequenceNumberCount() {
        long targetCount = this.persistence.getTargetCache().getTargetCount();
        long[] orphanedCount = new long[1];
        this.forEachOrphanedDocumentSequenceNumber(MemoryLruReferenceDelegate$$Lambda$1.lambdaFactory$(orphanedCount));
        return targetCount + orphanedCount[0];
    }

    @Override
    public void forEachOrphanedDocumentSequenceNumber(Consumer<Long> consumer) {
        for (Map.Entry<DocumentKey, Long> entry : this.orphanedSequenceNumbers.entrySet()) {
            if (this.isPinned(entry.getKey(), entry.getValue())) continue;
            consumer.accept(entry.getValue());
        }
    }

    @Override
    public void setInMemoryPins(ReferenceSet inMemoryPins) {
        this.inMemoryPins = inMemoryPins;
    }

    @Override
    public int removeTargets(long upperBound, SparseArray<?> activeTargetIds) {
        return this.persistence.getTargetCache().removeQueries(upperBound, activeTargetIds);
    }

    @Override
    public int removeOrphanedDocuments(long upperBound) {
        int count = 0;
        MemoryRemoteDocumentCache cache = this.persistence.getRemoteDocumentCache();
        for (MaybeDocument doc : cache.getDocuments()) {
            DocumentKey key = doc.getKey();
            if (this.isPinned(key, upperBound)) continue;
            cache.remove(key);
            this.orphanedSequenceNumbers.remove(key);
            ++count;
        }
        return count;
    }

    @Override
    public void removeMutationReference(DocumentKey key) {
        this.orphanedSequenceNumbers.put(key, this.getCurrentSequenceNumber());
    }

    @Override
    public void removeTarget(TargetData targetData) {
        TargetData updated = targetData.withSequenceNumber(this.getCurrentSequenceNumber());
        this.persistence.getTargetCache().updateTargetData(updated);
    }

    @Override
    public void addReference(DocumentKey key) {
        this.orphanedSequenceNumbers.put(key, this.getCurrentSequenceNumber());
    }

    @Override
    public void removeReference(DocumentKey key) {
        this.orphanedSequenceNumbers.put(key, this.getCurrentSequenceNumber());
    }

    @Override
    public void updateLimboDocument(DocumentKey key) {
        this.orphanedSequenceNumbers.put(key, this.getCurrentSequenceNumber());
    }

    private boolean mutationQueuesContainsKey(DocumentKey key) {
        for (MemoryMutationQueue mutationQueue : this.persistence.getMutationQueues()) {
            if (!mutationQueue.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isPinned(DocumentKey key, long upperBound) {
        if (this.mutationQueuesContainsKey(key)) {
            return true;
        }
        if (this.inMemoryPins.containsKey(key)) {
            return true;
        }
        if (this.persistence.getTargetCache().containsKey(key)) {
            return true;
        }
        Long sequenceNumber = this.orphanedSequenceNumbers.get(key);
        return sequenceNumber != null && sequenceNumber > upperBound;
    }

    @Override
    public long getByteSize() {
        long count = 0L;
        count += this.persistence.getTargetCache().getByteSize(this.serializer);
        count += this.persistence.getRemoteDocumentCache().getByteSize(this.serializer);
        for (MemoryMutationQueue queue : this.persistence.getMutationQueues()) {
            count += queue.getByteSize(this.serializer);
        }
        return count;
    }

    static /* synthetic */ void lambda$getSequenceNumberCount$0(long[] orphanedCount, Long sequenceNumber) {
        orphanedCount[0] = orphanedCount[0] + 1L;
    }
}

