/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.database.Cursor;
import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.local.SQLiteRemoteDocumentCache$$Lambda$1;
import com.google.firebase.firestore.local.SQLiteRemoteDocumentCache$$Lambda$2;
import com.google.firebase.firestore.local.SQLiteRemoteDocumentCache$$Lambda$3;
import com.google.firebase.firestore.local.SQLiteRemoteDocumentCache$$Lambda$4;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.BackgroundQueue;
import com.google.firebase.firestore.util.Executors;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

final class SQLiteRemoteDocumentCache
implements RemoteDocumentCache {
    private final SQLitePersistence db;
    private final LocalSerializer serializer;

    SQLiteRemoteDocumentCache(SQLitePersistence persistence, LocalSerializer serializer) {
        this.db = persistence;
        this.serializer = serializer;
    }

    @Override
    public void add(MaybeDocument maybeDocument, SnapshotVersion readTime) {
        Assert.hardAssert(!readTime.equals(SnapshotVersion.NONE), "Cannot add document to the RemoteDocumentCache with a read time of zero", new Object[0]);
        String path = this.pathForKey(maybeDocument.getKey());
        Timestamp timestamp = readTime.getTimestamp();
        com.google.firebase.firestore.proto.MaybeDocument message = this.serializer.encodeMaybeDocument(maybeDocument);
        this.db.execute("INSERT OR REPLACE INTO remote_documents (path, read_time_seconds, read_time_nanos, contents) VALUES (?, ?, ?, ?)", path, timestamp.getSeconds(), timestamp.getNanoseconds(), message.toByteArray());
        this.db.getIndexManager().addToCollectionParentIndex((ResourcePath)maybeDocument.getKey().getPath().popLast());
    }

    @Override
    public void remove(DocumentKey documentKey) {
        String path = this.pathForKey(documentKey);
        this.db.execute("DELETE FROM remote_documents WHERE path = ?", path);
    }

    @Override
    @Nullable
    public MaybeDocument get(DocumentKey documentKey) {
        String path = this.pathForKey(documentKey);
        return (MaybeDocument)this.db.query("SELECT contents FROM remote_documents WHERE path = ?").binding(path).firstValue(SQLiteRemoteDocumentCache$$Lambda$1.lambdaFactory$(this));
    }

    @Override
    public Map<DocumentKey, MaybeDocument> getAll(Iterable<DocumentKey> documentKeys) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (DocumentKey documentKey : documentKeys) {
            args.add(EncodedPath.encode(documentKey.getPath()));
        }
        HashMap<DocumentKey, MaybeDocument> results = new HashMap<DocumentKey, MaybeDocument>();
        for (DocumentKey key : documentKeys) {
            results.put(key, null);
        }
        SQLitePersistence.LongQuery longQuery = new SQLitePersistence.LongQuery(this.db, "SELECT contents FROM remote_documents WHERE path IN (", args, ") ORDER BY path");
        while (longQuery.hasMoreSubqueries()) {
            longQuery.performNextSubquery().forEach(SQLiteRemoteDocumentCache$$Lambda$2.lambdaFactory$(this, results));
        }
        return results;
    }

    @Override
    public ImmutableSortedMap<DocumentKey, Document> getAllDocumentsMatchingQuery(Query query, SnapshotVersion sinceReadTime) {
        Assert.hardAssert(!query.isCollectionGroupQuery(), "CollectionGroup queries should be handled in LocalDocumentsView", new Object[0]);
        ResourcePath prefix = query.getPath();
        int immediateChildrenPathLength = prefix.length() + 1;
        String prefixPath = EncodedPath.encode(prefix);
        String prefixSuccessorPath = EncodedPath.prefixSuccessor(prefixPath);
        Timestamp readTime = sinceReadTime.getTimestamp();
        BackgroundQueue backgroundQueue = new BackgroundQueue();
        ImmutableSortedMap[] matchingDocuments = new ImmutableSortedMap[]{DocumentCollections.emptyDocumentMap()};
        SQLitePersistence.Query sqlQuery = sinceReadTime.equals(SnapshotVersion.NONE) ? this.db.query("SELECT path, contents FROM remote_documents WHERE path >= ? AND path < ?").binding(prefixPath, prefixSuccessorPath) : this.db.query("SELECT path, contents FROM remote_documents WHERE path >= ? AND path < ?AND (read_time_seconds > ? OR (read_time_seconds = ? AND read_time_nanos > ?))").binding(prefixPath, prefixSuccessorPath, readTime.getSeconds(), readTime.getSeconds(), readTime.getNanoseconds());
        sqlQuery.forEach(SQLiteRemoteDocumentCache$$Lambda$3.lambdaFactory$(this, immediateChildrenPathLength, backgroundQueue, query, matchingDocuments));
        try {
            backgroundQueue.drain();
        }
        catch (InterruptedException e) {
            Assert.fail("Interrupted while deserializing documents", e);
        }
        return matchingDocuments[0];
    }

    private String pathForKey(DocumentKey key) {
        return EncodedPath.encode(key.getPath());
    }

    private MaybeDocument decodeMaybeDocument(byte[] bytes) {
        try {
            return this.serializer.decodeMaybeDocument(com.google.firebase.firestore.proto.MaybeDocument.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw Assert.fail("MaybeDocument failed to parse: %s", new Object[]{e});
        }
    }

    static /* synthetic */ void lambda$getAllDocumentsMatchingQuery$3(SQLiteRemoteDocumentCache this_, int immediateChildrenPathLength, BackgroundQueue backgroundQueue, Query query, ImmutableSortedMap[] matchingDocuments, Cursor row) {
        ResourcePath path = EncodedPath.decodeResourcePath(row.getString(0));
        if (path.length() != immediateChildrenPathLength) {
            return;
        }
        byte[] rawDocument = row.getBlob(1);
        Executor executor = row.isLast() ? Executors.DIRECT_EXECUTOR : backgroundQueue;
        executor.execute(SQLiteRemoteDocumentCache$$Lambda$4.lambdaFactory$(this_, rawDocument, query, matchingDocuments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$getAllDocumentsMatchingQuery$2(SQLiteRemoteDocumentCache this_, byte[] rawDocument, Query query, ImmutableSortedMap[] matchingDocuments) {
        MaybeDocument maybeDoc = this_.decodeMaybeDocument(rawDocument);
        if (maybeDoc instanceof Document && query.matches((Document)maybeDoc)) {
            SQLiteRemoteDocumentCache sQLiteRemoteDocumentCache = this_;
            synchronized (sQLiteRemoteDocumentCache) {
                matchingDocuments[0] = matchingDocuments[0].insert((Object)maybeDoc.getKey(), (Object)((Document)maybeDoc));
            }
        }
    }

    static /* synthetic */ void lambda$getAll$1(SQLiteRemoteDocumentCache this_, Map results, Cursor row) {
        MaybeDocument decoded = this_.decodeMaybeDocument(row.getBlob(0));
        results.put(decoded.getKey(), decoded);
    }

    static /* synthetic */ MaybeDocument lambda$get$0(SQLiteRemoteDocumentCache this_, Cursor row) {
        return this_.decodeMaybeDocument(row.getBlob(0));
    }
}

