/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.remote.GrpcMetadataProvider;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.inject.Provider;
import com.google.firebase.platforminfo.UserAgentPublisher;
import io.grpc.Metadata;

public class FirebaseClientGrpcMetadataProvider
implements GrpcMetadataProvider {
    private final Provider<HeartBeatInfo> heartBeatInfoProvider;
    private final Provider<UserAgentPublisher> userAgentPublisherProvider;
    private final String firebaseFirestoreHeartBeatTag = "fire-fst";
    private static final Metadata.Key<String> HEART_BEAT_HEADER = Metadata.Key.of((String)"x-firebase-client-log-type", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> USER_AGENT_HEADER = Metadata.Key.of((String)"x-firebase-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public FirebaseClientGrpcMetadataProvider(@NonNull Provider<UserAgentPublisher> userAgentPublisherProvider, @NonNull Provider<HeartBeatInfo> heartBeatInfoProvider) {
        this.userAgentPublisherProvider = userAgentPublisherProvider;
        this.heartBeatInfoProvider = heartBeatInfoProvider;
    }

    @Override
    public void updateMetadata(@NonNull Metadata metadata) {
        if (this.heartBeatInfoProvider.get() == null || this.userAgentPublisherProvider.get() == null) {
            return;
        }
        int heartBeatCode = ((HeartBeatInfo)this.heartBeatInfoProvider.get()).getHeartBeatCode("fire-fst").getCode();
        if (heartBeatCode != 0) {
            metadata.put(HEART_BEAT_HEADER, (Object)Integer.toString(heartBeatCode));
            metadata.put(USER_AGENT_HEADER, (Object)((UserAgentPublisher)this.userAgentPublisherProvider.get()).getUserAgent());
        }
    }
}

