/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.DocumentViewChange;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.remote.TargetChange;
import com.google.firebase.firestore.util.Assert;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;

final class TargetState {
    private int outstandingResponses = 0;
    private final Map<DocumentKey, DocumentViewChange.Type> documentChanges = new HashMap<DocumentKey, DocumentViewChange.Type>();
    private boolean hasChanges = true;
    private ByteString resumeToken = ByteString.EMPTY;
    private boolean current = false;

    TargetState() {
    }

    boolean isCurrent() {
        return this.current;
    }

    boolean isPending() {
        return this.outstandingResponses != 0;
    }

    boolean hasChanges() {
        return this.hasChanges;
    }

    void updateResumeToken(ByteString resumeToken) {
        if (!resumeToken.isEmpty()) {
            this.hasChanges = true;
            this.resumeToken = resumeToken;
        }
    }

    TargetChange toTargetChange() {
        ImmutableSortedSet addedDocuments = DocumentKey.emptyKeySet();
        ImmutableSortedSet modifiedDocuments = DocumentKey.emptyKeySet();
        ImmutableSortedSet removedDocuments = DocumentKey.emptyKeySet();
        block5: for (Map.Entry<DocumentKey, DocumentViewChange.Type> entry : this.documentChanges.entrySet()) {
            DocumentKey key = entry.getKey();
            DocumentViewChange.Type changeType = entry.getValue();
            switch (changeType) {
                case ADDED: {
                    addedDocuments = addedDocuments.insert((Object)key);
                    continue block5;
                }
                case MODIFIED: {
                    modifiedDocuments = modifiedDocuments.insert((Object)key);
                    continue block5;
                }
                case REMOVED: {
                    removedDocuments = removedDocuments.insert((Object)key);
                    continue block5;
                }
            }
            throw Assert.fail("Encountered invalid change type: %s", new Object[]{changeType});
        }
        return new TargetChange(this.resumeToken, this.current, addedDocuments, modifiedDocuments, removedDocuments);
    }

    void clearChanges() {
        this.hasChanges = false;
        this.documentChanges.clear();
    }

    void addDocumentChange(DocumentKey key, DocumentViewChange.Type changeType) {
        this.hasChanges = true;
        this.documentChanges.put(key, changeType);
    }

    void removeDocumentChange(DocumentKey key) {
        this.hasChanges = true;
        this.documentChanges.remove(key);
    }

    void recordPendingTargetRequest() {
        ++this.outstandingResponses;
    }

    void recordTargetResponse() {
        --this.outstandingResponses;
    }

    void markCurrent() {
        this.hasChanges = true;
        this.current = true;
    }
}

