/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.local.TargetData;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.model.mutation.ArrayTransformOperation;
import com.google.firebase.firestore.model.mutation.DeleteMutation;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.NumericIncrementTransformOperation;
import com.google.firebase.firestore.model.mutation.PatchMutation;
import com.google.firebase.firestore.model.mutation.ServerTimestampOperation;
import com.google.firebase.firestore.model.mutation.SetMutation;
import com.google.firebase.firestore.model.mutation.TransformMutation;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.model.mutation.VerifyMutation;
import com.google.firebase.firestore.remote.ExistenceFilter;
import com.google.firebase.firestore.remote.WatchChange;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentChange;
import com.google.firestore.v1.DocumentDelete;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.DocumentRemove;
import com.google.firestore.v1.DocumentTransform;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Target;
import com.google.firestore.v1.TargetChange;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import com.google.firestore.v1.WriteResult;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class RemoteSerializer {
    private final DatabaseId databaseId;
    private final String databaseName;

    public RemoteSerializer(DatabaseId databaseId) {
        this.databaseId = databaseId;
        this.databaseName = RemoteSerializer.encodedDatabaseId(databaseId).canonicalString();
    }

    public com.google.protobuf.Timestamp encodeTimestamp(Timestamp timestamp) {
        Timestamp.Builder builder = com.google.protobuf.Timestamp.newBuilder();
        builder.setSeconds(timestamp.getSeconds());
        builder.setNanos(timestamp.getNanoseconds());
        return (com.google.protobuf.Timestamp)builder.build();
    }

    public Timestamp decodeTimestamp(com.google.protobuf.Timestamp proto) {
        return new Timestamp(proto.getSeconds(), proto.getNanos());
    }

    public com.google.protobuf.Timestamp encodeVersion(SnapshotVersion version) {
        return this.encodeTimestamp(version.getTimestamp());
    }

    public SnapshotVersion decodeVersion(com.google.protobuf.Timestamp proto) {
        if (proto.getSeconds() == 0L && proto.getNanos() == 0) {
            return SnapshotVersion.NONE;
        }
        return new SnapshotVersion(this.decodeTimestamp(proto));
    }

    public String encodeKey(DocumentKey key) {
        return this.encodeResourceName(this.databaseId, key.getPath());
    }

    public DocumentKey decodeKey(String name) {
        ResourcePath resource = this.decodeResourceName(name);
        Assert.hardAssert(resource.getSegment(1).equals(this.databaseId.getProjectId()), "Tried to deserialize key from different project.", new Object[0]);
        Assert.hardAssert(resource.getSegment(3).equals(this.databaseId.getDatabaseId()), "Tried to deserialize key from different database.", new Object[0]);
        return DocumentKey.fromPath(RemoteSerializer.extractLocalPathFromResourceName(resource));
    }

    private String encodeQueryPath(ResourcePath path) {
        return this.encodeResourceName(this.databaseId, path);
    }

    private ResourcePath decodeQueryPath(String name) {
        ResourcePath resource = this.decodeResourceName(name);
        if (resource.length() == 4) {
            return ResourcePath.EMPTY;
        }
        return RemoteSerializer.extractLocalPathFromResourceName(resource);
    }

    private String encodeResourceName(DatabaseId databaseId, ResourcePath path) {
        return ((ResourcePath)((Object)RemoteSerializer.encodedDatabaseId(databaseId).append("documents"))).append(path).canonicalString();
    }

    private ResourcePath decodeResourceName(String encoded) {
        ResourcePath resource = ResourcePath.fromString(encoded);
        Assert.hardAssert(RemoteSerializer.isValidResourceName(resource), "Tried to deserialize invalid key %s", resource);
        return resource;
    }

    private static ResourcePath encodedDatabaseId(DatabaseId databaseId) {
        return ResourcePath.fromSegments(Arrays.asList("projects", databaseId.getProjectId(), "databases", databaseId.getDatabaseId()));
    }

    private static ResourcePath extractLocalPathFromResourceName(ResourcePath resourceName) {
        Assert.hardAssert(resourceName.length() > 4 && resourceName.getSegment(4).equals("documents"), "Tried to deserialize invalid key %s", resourceName);
        return (ResourcePath)resourceName.popFirst(5);
    }

    private static boolean isValidResourceName(ResourcePath path) {
        return path.length() >= 4 && path.getSegment(0).equals("projects") && path.getSegment(2).equals("databases");
    }

    public String databaseName() {
        return this.databaseName;
    }

    public com.google.firestore.v1.Document encodeDocument(DocumentKey key, ObjectValue value) {
        Document.Builder builder = com.google.firestore.v1.Document.newBuilder();
        builder.setName(this.encodeKey(key));
        builder.putAllFields(value.getFieldsMap());
        return (com.google.firestore.v1.Document)builder.build();
    }

    public MaybeDocument decodeMaybeDocument(BatchGetDocumentsResponse response) {
        if (response.getResultCase().equals((Object)BatchGetDocumentsResponse.ResultCase.FOUND)) {
            return this.decodeFoundDocument(response);
        }
        if (response.getResultCase().equals((Object)BatchGetDocumentsResponse.ResultCase.MISSING)) {
            return this.decodeMissingDocument(response);
        }
        throw new IllegalArgumentException("Unknown result case: " + (Object)((Object)response.getResultCase()));
    }

    private Document decodeFoundDocument(BatchGetDocumentsResponse response) {
        Assert.hardAssert(response.getResultCase().equals((Object)BatchGetDocumentsResponse.ResultCase.FOUND), "Tried to deserialize a found document from a missing document.", new Object[0]);
        DocumentKey key = this.decodeKey(response.getFound().getName());
        ObjectValue value = ObjectValue.fromMap(response.getFound().getFieldsMap());
        SnapshotVersion version = this.decodeVersion(response.getFound().getUpdateTime());
        Assert.hardAssert(!version.equals(SnapshotVersion.NONE), "Got a document response with no snapshot version", new Object[0]);
        return new Document(key, version, value, Document.DocumentState.SYNCED);
    }

    private NoDocument decodeMissingDocument(BatchGetDocumentsResponse response) {
        Assert.hardAssert(response.getResultCase().equals((Object)BatchGetDocumentsResponse.ResultCase.MISSING), "Tried to deserialize a missing document from a found document.", new Object[0]);
        DocumentKey key = this.decodeKey(response.getMissing());
        SnapshotVersion version = this.decodeVersion(response.getReadTime());
        Assert.hardAssert(!version.equals(SnapshotVersion.NONE), "Got a no document response with no snapshot version", new Object[0]);
        return new NoDocument(key, version, false);
    }

    public Write encodeMutation(Mutation mutation) {
        Write.Builder builder = Write.newBuilder();
        if (mutation instanceof SetMutation) {
            builder.setUpdate(this.encodeDocument(mutation.getKey(), ((SetMutation)mutation).getValue()));
        } else if (mutation instanceof PatchMutation) {
            builder.setUpdate(this.encodeDocument(mutation.getKey(), ((PatchMutation)mutation).getValue()));
            builder.setUpdateMask(this.encodeDocumentMask(((PatchMutation)mutation).getMask()));
        } else if (mutation instanceof TransformMutation) {
            TransformMutation transform = (TransformMutation)mutation;
            DocumentTransform.Builder transformBuilder = DocumentTransform.newBuilder();
            transformBuilder.setDocument(this.encodeKey(transform.getKey()));
            for (FieldTransform fieldTransform : transform.getFieldTransforms()) {
                transformBuilder.addFieldTransforms(this.encodeFieldTransform(fieldTransform));
            }
            builder.setTransform(transformBuilder);
        } else if (mutation instanceof DeleteMutation) {
            builder.setDelete(this.encodeKey(mutation.getKey()));
        } else if (mutation instanceof VerifyMutation) {
            builder.setVerify(this.encodeKey(mutation.getKey()));
        } else {
            throw Assert.fail("unknown mutation type %s", mutation.getClass());
        }
        if (!mutation.getPrecondition().isNone()) {
            builder.setCurrentDocument(this.encodePrecondition(mutation.getPrecondition()));
        }
        return (Write)builder.build();
    }

    public Mutation decodeMutation(Write mutation) {
        com.google.firebase.firestore.model.mutation.Precondition precondition = mutation.hasCurrentDocument() ? this.decodePrecondition(mutation.getCurrentDocument()) : com.google.firebase.firestore.model.mutation.Precondition.NONE;
        switch (mutation.getOperationCase()) {
            case UPDATE: {
                if (mutation.hasUpdateMask()) {
                    return new PatchMutation(this.decodeKey(mutation.getUpdate().getName()), ObjectValue.fromMap(mutation.getUpdate().getFieldsMap()), this.decodeDocumentMask(mutation.getUpdateMask()), precondition);
                }
                return new SetMutation(this.decodeKey(mutation.getUpdate().getName()), ObjectValue.fromMap(mutation.getUpdate().getFieldsMap()), precondition);
            }
            case DELETE: {
                return new DeleteMutation(this.decodeKey(mutation.getDelete()), precondition);
            }
            case TRANSFORM: {
                ArrayList<FieldTransform> fieldTransforms = new ArrayList<FieldTransform>();
                for (DocumentTransform.FieldTransform fieldTransform : mutation.getTransform().getFieldTransformsList()) {
                    fieldTransforms.add(this.decodeFieldTransform(fieldTransform));
                }
                Boolean exists = precondition.getExists();
                Assert.hardAssert(exists != null && exists != false, "Transforms only support precondition \"exists == true\"", new Object[0]);
                return new TransformMutation(this.decodeKey(mutation.getTransform().getDocument()), fieldTransforms);
            }
            case VERIFY: {
                return new VerifyMutation(this.decodeKey(mutation.getVerify()), precondition);
            }
        }
        throw Assert.fail("Unknown mutation operation: %d", new Object[]{mutation.getOperationCase()});
    }

    private Precondition encodePrecondition(com.google.firebase.firestore.model.mutation.Precondition precondition) {
        Assert.hardAssert(!precondition.isNone(), "Can't serialize an empty precondition", new Object[0]);
        Precondition.Builder builder = Precondition.newBuilder();
        if (precondition.getUpdateTime() != null) {
            return (Precondition)builder.setUpdateTime(this.encodeVersion(precondition.getUpdateTime())).build();
        }
        if (precondition.getExists() != null) {
            return (Precondition)builder.setExists(precondition.getExists()).build();
        }
        throw Assert.fail("Unknown Precondition", new Object[0]);
    }

    private com.google.firebase.firestore.model.mutation.Precondition decodePrecondition(Precondition precondition) {
        switch (precondition.getConditionTypeCase()) {
            case UPDATE_TIME: {
                return com.google.firebase.firestore.model.mutation.Precondition.updateTime(this.decodeVersion(precondition.getUpdateTime()));
            }
            case EXISTS: {
                return com.google.firebase.firestore.model.mutation.Precondition.exists(precondition.getExists());
            }
            case CONDITIONTYPE_NOT_SET: {
                return com.google.firebase.firestore.model.mutation.Precondition.NONE;
            }
        }
        throw Assert.fail("Unknown precondition", new Object[0]);
    }

    private DocumentMask encodeDocumentMask(FieldMask mask) {
        DocumentMask.Builder builder = DocumentMask.newBuilder();
        for (FieldPath path : mask.getMask()) {
            builder.addFieldPaths(path.canonicalString());
        }
        return (DocumentMask)builder.build();
    }

    private FieldMask decodeDocumentMask(DocumentMask mask) {
        int count = mask.getFieldPathsCount();
        HashSet<FieldPath> paths = new HashSet<FieldPath>(count);
        for (int i = 0; i < count; ++i) {
            paths.add(FieldPath.fromServerFormat(mask.getFieldPaths(i)));
        }
        return FieldMask.fromSet(paths);
    }

    private DocumentTransform.FieldTransform encodeFieldTransform(FieldTransform fieldTransform) {
        TransformOperation transform = fieldTransform.getOperation();
        if (transform instanceof ServerTimestampOperation) {
            return (DocumentTransform.FieldTransform)DocumentTransform.FieldTransform.newBuilder().setFieldPath(fieldTransform.getFieldPath().canonicalString()).setSetToServerValue(DocumentTransform.FieldTransform.ServerValue.REQUEST_TIME).build();
        }
        if (transform instanceof ArrayTransformOperation.Union) {
            ArrayTransformOperation.Union union = (ArrayTransformOperation.Union)transform;
            return (DocumentTransform.FieldTransform)DocumentTransform.FieldTransform.newBuilder().setFieldPath(fieldTransform.getFieldPath().canonicalString()).setAppendMissingElements(ArrayValue.newBuilder().addAllValues(union.getElements())).build();
        }
        if (transform instanceof ArrayTransformOperation.Remove) {
            ArrayTransformOperation.Remove remove = (ArrayTransformOperation.Remove)transform;
            return (DocumentTransform.FieldTransform)DocumentTransform.FieldTransform.newBuilder().setFieldPath(fieldTransform.getFieldPath().canonicalString()).setRemoveAllFromArray(ArrayValue.newBuilder().addAllValues(remove.getElements())).build();
        }
        if (transform instanceof NumericIncrementTransformOperation) {
            NumericIncrementTransformOperation incrementOperation = (NumericIncrementTransformOperation)transform;
            return (DocumentTransform.FieldTransform)DocumentTransform.FieldTransform.newBuilder().setFieldPath(fieldTransform.getFieldPath().canonicalString()).setIncrement(incrementOperation.getOperand()).build();
        }
        throw Assert.fail("Unknown transform: %s", transform);
    }

    private FieldTransform decodeFieldTransform(DocumentTransform.FieldTransform fieldTransform) {
        switch (fieldTransform.getTransformTypeCase()) {
            case SET_TO_SERVER_VALUE: {
                Assert.hardAssert(fieldTransform.getSetToServerValue() == DocumentTransform.FieldTransform.ServerValue.REQUEST_TIME, "Unknown transform setToServerValue: %s", new Object[]{fieldTransform.getSetToServerValue()});
                return new FieldTransform(FieldPath.fromServerFormat(fieldTransform.getFieldPath()), ServerTimestampOperation.getInstance());
            }
            case APPEND_MISSING_ELEMENTS: {
                return new FieldTransform(FieldPath.fromServerFormat(fieldTransform.getFieldPath()), new ArrayTransformOperation.Union(fieldTransform.getAppendMissingElements().getValuesList()));
            }
            case REMOVE_ALL_FROM_ARRAY: {
                return new FieldTransform(FieldPath.fromServerFormat(fieldTransform.getFieldPath()), new ArrayTransformOperation.Remove(fieldTransform.getRemoveAllFromArray().getValuesList()));
            }
            case INCREMENT: {
                return new FieldTransform(FieldPath.fromServerFormat(fieldTransform.getFieldPath()), new NumericIncrementTransformOperation(fieldTransform.getIncrement()));
            }
        }
        throw Assert.fail("Unknown FieldTransform proto: %s", fieldTransform);
    }

    public MutationResult decodeMutationResult(WriteResult proto, SnapshotVersion commitVersion) {
        SnapshotVersion version = this.decodeVersion(proto.getUpdateTime());
        if (SnapshotVersion.NONE.equals(version)) {
            version = commitVersion;
        }
        ArrayList<Value> transformResults = null;
        int transformResultsCount = proto.getTransformResultsCount();
        if (transformResultsCount > 0) {
            transformResults = new ArrayList<Value>(transformResultsCount);
            for (int i = 0; i < transformResultsCount; ++i) {
                transformResults.add(proto.getTransformResults(i));
            }
        }
        return new MutationResult(version, transformResults);
    }

    @Nullable
    public Map<String, String> encodeListenRequestLabels(TargetData targetData) {
        String value = this.encodeLabel(targetData.getPurpose());
        if (value == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(1);
        result.put("goog-listen-tags", value);
        return result;
    }

    @Nullable
    private String encodeLabel(QueryPurpose purpose) {
        switch (purpose) {
            case LISTEN: {
                return null;
            }
            case EXISTENCE_FILTER_MISMATCH: {
                return "existence-filter-mismatch";
            }
            case LIMBO_RESOLUTION: {
                return "limbo-document";
            }
        }
        throw Assert.fail("Unrecognized query purpose: %s", new Object[]{purpose});
    }

    public Target encodeTarget(TargetData targetData) {
        Target.Builder builder = Target.newBuilder();
        com.google.firebase.firestore.core.Target target = targetData.getTarget();
        if (target.isDocumentQuery()) {
            builder.setDocuments(this.encodeDocumentsTarget(target));
        } else {
            builder.setQuery(this.encodeQueryTarget(target));
        }
        builder.setTargetId(targetData.getTargetId());
        builder.setResumeToken(targetData.getResumeToken());
        return (Target)builder.build();
    }

    public Target.DocumentsTarget encodeDocumentsTarget(com.google.firebase.firestore.core.Target target) {
        Target.DocumentsTarget.Builder builder = Target.DocumentsTarget.newBuilder();
        builder.addDocuments(this.encodeQueryPath(target.getPath()));
        return (Target.DocumentsTarget)builder.build();
    }

    public com.google.firebase.firestore.core.Target decodeDocumentsTarget(Target.DocumentsTarget target) {
        int count = target.getDocumentsCount();
        Assert.hardAssert(count == 1, "DocumentsTarget contained other than 1 document %d", count);
        String name = target.getDocuments(0);
        return Query.atPath(this.decodeQueryPath(name)).toTarget();
    }

    public Target.QueryTarget encodeQueryTarget(com.google.firebase.firestore.core.Target target) {
        StructuredQuery.CollectionSelector.Builder from;
        Target.QueryTarget.Builder builder = Target.QueryTarget.newBuilder();
        StructuredQuery.Builder structuredQueryBuilder = StructuredQuery.newBuilder();
        ResourcePath path = target.getPath();
        if (target.getCollectionGroup() != null) {
            Assert.hardAssert(path.length() % 2 == 0, "Collection Group queries should be within a document path or root.", new Object[0]);
            builder.setParent(this.encodeQueryPath(path));
            from = StructuredQuery.CollectionSelector.newBuilder();
            from.setCollectionId(target.getCollectionGroup());
            from.setAllDescendants(true);
            structuredQueryBuilder.addFrom(from);
        } else {
            Assert.hardAssert(path.length() % 2 != 0, "Document queries with filters are not supported.", new Object[0]);
            builder.setParent(this.encodeQueryPath((ResourcePath)path.popLast()));
            from = StructuredQuery.CollectionSelector.newBuilder();
            from.setCollectionId(path.getLastSegment());
            structuredQueryBuilder.addFrom(from);
        }
        if (target.getFilters().size() > 0) {
            structuredQueryBuilder.setWhere(this.encodeFilters(target.getFilters()));
        }
        for (OrderBy orderBy : target.getOrderBy()) {
            structuredQueryBuilder.addOrderBy(this.encodeOrderBy(orderBy));
        }
        if (target.hasLimit()) {
            structuredQueryBuilder.setLimit(Int32Value.newBuilder().setValue((int)target.getLimit()));
        }
        if (target.getStartAt() != null) {
            structuredQueryBuilder.setStartAt(this.encodeBound(target.getStartAt()));
        }
        if (target.getEndAt() != null) {
            structuredQueryBuilder.setEndAt(this.encodeBound(target.getEndAt()));
        }
        builder.setStructuredQuery(structuredQueryBuilder);
        return (Target.QueryTarget)builder.build();
    }

    public com.google.firebase.firestore.core.Target decodeQueryTarget(Target.QueryTarget target) {
        List<OrderBy> orderBy;
        ResourcePath path = this.decodeQueryPath(target.getParent());
        StructuredQuery query = target.getStructuredQuery();
        String collectionGroup = null;
        int fromCount = query.getFromCount();
        if (fromCount > 0) {
            Assert.hardAssert(fromCount == 1, "StructuredQuery.from with more than one collection is not supported.", new Object[0]);
            StructuredQuery.CollectionSelector from = query.getFrom(0);
            if (from.getAllDescendants()) {
                collectionGroup = from.getCollectionId();
            } else {
                path = (ResourcePath)((Object)path.append(from.getCollectionId()));
            }
        }
        List<Filter> filterBy = query.hasWhere() ? this.decodeFilters(query.getWhere()) : Collections.emptyList();
        int orderByCount = query.getOrderByCount();
        if (orderByCount > 0) {
            orderBy = new ArrayList(orderByCount);
            for (int i = 0; i < orderByCount; ++i) {
                orderBy.add(this.decodeOrderBy(query.getOrderBy(i)));
            }
        } else {
            orderBy = Collections.emptyList();
        }
        long limit = -1L;
        if (query.hasLimit()) {
            limit = query.getLimit().getValue();
        }
        Bound startAt = null;
        if (query.hasStartAt()) {
            startAt = this.decodeBound(query.getStartAt());
        }
        Bound endAt = null;
        if (query.hasEndAt()) {
            endAt = this.decodeBound(query.getEndAt());
        }
        return new Query(path, collectionGroup, filterBy, orderBy, limit, Query.LimitType.LIMIT_TO_FIRST, startAt, endAt).toTarget();
    }

    private StructuredQuery.Filter encodeFilters(List<Filter> filters) {
        ArrayList<StructuredQuery.Filter> protos = new ArrayList<StructuredQuery.Filter>(filters.size());
        for (Filter filter : filters) {
            if (!(filter instanceof FieldFilter)) continue;
            protos.add(this.encodeUnaryOrFieldFilter((FieldFilter)filter));
        }
        if (filters.size() == 1) {
            return (StructuredQuery.Filter)protos.get(0);
        }
        StructuredQuery.CompositeFilter.Builder composite = StructuredQuery.CompositeFilter.newBuilder();
        composite.setOp(StructuredQuery.CompositeFilter.Operator.AND);
        composite.addAllFilters(protos);
        return (StructuredQuery.Filter)StructuredQuery.Filter.newBuilder().setCompositeFilter(composite).build();
    }

    private List<Filter> decodeFilters(StructuredQuery.Filter proto) {
        List<StructuredQuery.Filter> filters;
        if (proto.getFilterTypeCase() == StructuredQuery.Filter.FilterTypeCase.COMPOSITE_FILTER) {
            Assert.hardAssert(proto.getCompositeFilter().getOp() == StructuredQuery.CompositeFilter.Operator.AND, "Only AND-type composite filters are supported, got %d", new Object[]{proto.getCompositeFilter().getOp()});
            filters = proto.getCompositeFilter().getFiltersList();
        } else {
            filters = Collections.singletonList(proto);
        }
        ArrayList<Filter> result = new ArrayList<Filter>(filters.size());
        block5: for (StructuredQuery.Filter filter : filters) {
            switch (filter.getFilterTypeCase()) {
                case COMPOSITE_FILTER: {
                    throw Assert.fail("Nested composite filters are not supported.", new Object[0]);
                }
                case FIELD_FILTER: {
                    result.add(this.decodeFieldFilter(filter.getFieldFilter()));
                    continue block5;
                }
                case UNARY_FILTER: {
                    result.add(this.decodeUnaryFilter(filter.getUnaryFilter()));
                    continue block5;
                }
            }
            throw Assert.fail("Unrecognized Filter.filterType %d", new Object[]{filter.getFilterTypeCase()});
        }
        return result;
    }

    @VisibleForTesting
    StructuredQuery.Filter encodeUnaryOrFieldFilter(FieldFilter filter) {
        if (filter.getOperator() == Filter.Operator.EQUAL || filter.getOperator() == Filter.Operator.NOT_EQUAL) {
            StructuredQuery.UnaryFilter.Builder unaryProto = StructuredQuery.UnaryFilter.newBuilder();
            unaryProto.setField(this.encodeFieldPath(filter.getField()));
            if (Values.isNanValue(filter.getValue())) {
                unaryProto.setOp(filter.getOperator() == Filter.Operator.EQUAL ? StructuredQuery.UnaryFilter.Operator.IS_NAN : StructuredQuery.UnaryFilter.Operator.IS_NOT_NAN);
                return (StructuredQuery.Filter)StructuredQuery.Filter.newBuilder().setUnaryFilter(unaryProto).build();
            }
            if (Values.isNullValue(filter.getValue())) {
                unaryProto.setOp(filter.getOperator() == Filter.Operator.EQUAL ? StructuredQuery.UnaryFilter.Operator.IS_NULL : StructuredQuery.UnaryFilter.Operator.IS_NOT_NULL);
                return (StructuredQuery.Filter)StructuredQuery.Filter.newBuilder().setUnaryFilter(unaryProto).build();
            }
        }
        StructuredQuery.FieldFilter.Builder proto = StructuredQuery.FieldFilter.newBuilder();
        proto.setField(this.encodeFieldPath(filter.getField()));
        proto.setOp(this.encodeFieldFilterOperator(filter.getOperator()));
        proto.setValue(filter.getValue());
        return (StructuredQuery.Filter)StructuredQuery.Filter.newBuilder().setFieldFilter(proto).build();
    }

    @VisibleForTesting
    FieldFilter decodeFieldFilter(StructuredQuery.FieldFilter proto) {
        FieldPath fieldPath = FieldPath.fromServerFormat(proto.getField().getFieldPath());
        Filter.Operator filterOperator = this.decodeFieldFilterOperator(proto.getOp());
        return FieldFilter.create(fieldPath, filterOperator, proto.getValue());
    }

    private Filter decodeUnaryFilter(StructuredQuery.UnaryFilter proto) {
        FieldPath fieldPath = FieldPath.fromServerFormat(proto.getField().getFieldPath());
        switch (proto.getOp()) {
            case IS_NAN: {
                return FieldFilter.create(fieldPath, Filter.Operator.EQUAL, Values.NAN_VALUE);
            }
            case IS_NULL: {
                return FieldFilter.create(fieldPath, Filter.Operator.EQUAL, Values.NULL_VALUE);
            }
            case IS_NOT_NAN: {
                return FieldFilter.create(fieldPath, Filter.Operator.NOT_EQUAL, Values.NAN_VALUE);
            }
            case IS_NOT_NULL: {
                return FieldFilter.create(fieldPath, Filter.Operator.NOT_EQUAL, Values.NULL_VALUE);
            }
        }
        throw Assert.fail("Unrecognized UnaryFilter.operator %d", new Object[]{proto.getOp()});
    }

    private StructuredQuery.FieldReference encodeFieldPath(FieldPath field) {
        return (StructuredQuery.FieldReference)StructuredQuery.FieldReference.newBuilder().setFieldPath(field.canonicalString()).build();
    }

    private StructuredQuery.FieldFilter.Operator encodeFieldFilterOperator(Filter.Operator operator) {
        switch (operator) {
            case LESS_THAN: {
                return StructuredQuery.FieldFilter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case EQUAL: {
                return StructuredQuery.FieldFilter.Operator.EQUAL;
            }
            case NOT_EQUAL: {
                return StructuredQuery.FieldFilter.Operator.NOT_EQUAL;
            }
            case GREATER_THAN: {
                return StructuredQuery.FieldFilter.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case ARRAY_CONTAINS: {
                return StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS;
            }
            case IN: {
                return StructuredQuery.FieldFilter.Operator.IN;
            }
            case ARRAY_CONTAINS_ANY: {
                return StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY;
            }
            case NOT_IN: {
                return StructuredQuery.FieldFilter.Operator.NOT_IN;
            }
        }
        throw Assert.fail("Unknown operator %d", new Object[]{operator});
    }

    private Filter.Operator decodeFieldFilterOperator(StructuredQuery.FieldFilter.Operator operator) {
        switch (operator) {
            case LESS_THAN: {
                return Filter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return Filter.Operator.LESS_THAN_OR_EQUAL;
            }
            case EQUAL: {
                return Filter.Operator.EQUAL;
            }
            case NOT_EQUAL: {
                return Filter.Operator.NOT_EQUAL;
            }
            case GREATER_THAN_OR_EQUAL: {
                return Filter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Filter.Operator.GREATER_THAN;
            }
            case ARRAY_CONTAINS: {
                return Filter.Operator.ARRAY_CONTAINS;
            }
            case IN: {
                return Filter.Operator.IN;
            }
            case ARRAY_CONTAINS_ANY: {
                return Filter.Operator.ARRAY_CONTAINS_ANY;
            }
            case NOT_IN: {
                return Filter.Operator.NOT_IN;
            }
        }
        throw Assert.fail("Unhandled FieldFilter.operator %d", new Object[]{operator});
    }

    private StructuredQuery.Order encodeOrderBy(OrderBy orderBy) {
        StructuredQuery.Order.Builder proto = StructuredQuery.Order.newBuilder();
        if (orderBy.getDirection().equals((Object)OrderBy.Direction.ASCENDING)) {
            proto.setDirection(StructuredQuery.Direction.ASCENDING);
        } else {
            proto.setDirection(StructuredQuery.Direction.DESCENDING);
        }
        proto.setField(this.encodeFieldPath(orderBy.getField()));
        return (StructuredQuery.Order)proto.build();
    }

    private OrderBy decodeOrderBy(StructuredQuery.Order proto) {
        OrderBy.Direction direction;
        FieldPath fieldPath = FieldPath.fromServerFormat(proto.getField().getFieldPath());
        switch (proto.getDirection()) {
            case ASCENDING: {
                direction = OrderBy.Direction.ASCENDING;
                break;
            }
            case DESCENDING: {
                direction = OrderBy.Direction.DESCENDING;
                break;
            }
            default: {
                throw Assert.fail("Unrecognized direction %d", new Object[]{proto.getDirection()});
            }
        }
        return OrderBy.getInstance(direction, fieldPath);
    }

    private Cursor encodeBound(Bound bound) {
        Cursor.Builder builder = Cursor.newBuilder();
        builder.addAllValues(bound.getPosition());
        builder.setBefore(bound.isBefore());
        return (Cursor)builder.build();
    }

    private Bound decodeBound(Cursor proto) {
        return new Bound(proto.getValuesList(), proto.getBefore());
    }

    public WatchChange decodeWatchChange(ListenResponse protoChange) {
        WatchChange watchChange;
        switch (protoChange.getResponseTypeCase()) {
            case TARGET_CHANGE: {
                WatchChange.WatchTargetChangeType changeType;
                TargetChange targetChange = protoChange.getTargetChange();
                Status cause = null;
                switch (targetChange.getTargetChangeType()) {
                    case NO_CHANGE: {
                        changeType = WatchChange.WatchTargetChangeType.NoChange;
                        break;
                    }
                    case ADD: {
                        changeType = WatchChange.WatchTargetChangeType.Added;
                        break;
                    }
                    case REMOVE: {
                        changeType = WatchChange.WatchTargetChangeType.Removed;
                        cause = this.fromStatus(targetChange.getCause());
                        break;
                    }
                    case CURRENT: {
                        changeType = WatchChange.WatchTargetChangeType.Current;
                        break;
                    }
                    case RESET: {
                        changeType = WatchChange.WatchTargetChangeType.Reset;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown target change type");
                    }
                }
                watchChange = new WatchChange.WatchTargetChange(changeType, targetChange.getTargetIdsList(), targetChange.getResumeToken(), cause);
                break;
            }
            case DOCUMENT_CHANGE: {
                DocumentChange docChange = protoChange.getDocumentChange();
                List<Integer> added = docChange.getTargetIdsList();
                List<Integer> removed = docChange.getRemovedTargetIdsList();
                DocumentKey key = this.decodeKey(docChange.getDocument().getName());
                SnapshotVersion version = this.decodeVersion(docChange.getDocument().getUpdateTime());
                Assert.hardAssert(!version.equals(SnapshotVersion.NONE), "Got a document change without an update time", new Object[0]);
                ObjectValue data = ObjectValue.fromMap(docChange.getDocument().getFieldsMap());
                Document document = new Document(key, version, data, Document.DocumentState.SYNCED);
                watchChange = new WatchChange.DocumentChange(added, removed, document.getKey(), document);
                break;
            }
            case DOCUMENT_DELETE: {
                DocumentDelete docDelete = protoChange.getDocumentDelete();
                List<Integer> removed = docDelete.getRemovedTargetIdsList();
                DocumentKey key = this.decodeKey(docDelete.getDocument());
                SnapshotVersion version = this.decodeVersion(docDelete.getReadTime());
                NoDocument doc = new NoDocument(key, version, false);
                watchChange = new WatchChange.DocumentChange(Collections.<Integer>emptyList(), removed, doc.getKey(), doc);
                break;
            }
            case DOCUMENT_REMOVE: {
                DocumentRemove docRemove = protoChange.getDocumentRemove();
                List<Integer> removed = docRemove.getRemovedTargetIdsList();
                DocumentKey key = this.decodeKey(docRemove.getDocument());
                watchChange = new WatchChange.DocumentChange(Collections.<Integer>emptyList(), removed, key, null);
                break;
            }
            case FILTER: {
                com.google.firestore.v1.ExistenceFilter protoFilter = protoChange.getFilter();
                ExistenceFilter filter = new ExistenceFilter(protoFilter.getCount());
                int targetId = protoFilter.getTargetId();
                watchChange = new WatchChange.ExistenceFilterWatchChange(targetId, filter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown change type set");
            }
        }
        return watchChange;
    }

    public SnapshotVersion decodeVersionFromListenResponse(ListenResponse watchChange) {
        if (watchChange.getResponseTypeCase() != ListenResponse.ResponseTypeCase.TARGET_CHANGE) {
            return SnapshotVersion.NONE;
        }
        if (watchChange.getTargetChange().getTargetIdsCount() != 0) {
            return SnapshotVersion.NONE;
        }
        return this.decodeVersion(watchChange.getTargetChange().getReadTime());
    }

    private Status fromStatus(com.google.rpc.Status status) {
        return Status.fromCodeValue((int)status.getCode()).withDescription(status.getMessage());
    }
}

