/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

final class LoadBundleTaskProgress {
    static final LoadBundleTaskProgress INITIAL = new LoadBundleTaskProgress(0, 0, 0L, 0L, null, TaskState.SUCCESS);
    private final int documentsLoaded;
    private final int totalDocuments;
    private final long bytesLoaded;
    private final long totalBytes;
    @NonNull
    private final TaskState taskState;
    @Nullable
    private final Exception exception;

    public LoadBundleTaskProgress(int documentsLoaded, int totalDocuments, long bytesLoaded, long totalBytes, @Nullable Exception exception, @NonNull TaskState taskState) {
        this.documentsLoaded = documentsLoaded;
        this.totalDocuments = totalDocuments;
        this.bytesLoaded = bytesLoaded;
        this.totalBytes = totalBytes;
        this.taskState = taskState;
        this.exception = exception;
    }

    public int getDocumentsLoaded() {
        return this.documentsLoaded;
    }

    public int getTotalDocuments() {
        return this.totalDocuments;
    }

    public long getBytesLoaded() {
        return this.bytesLoaded;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    @NonNull
    public TaskState getTaskState() {
        return this.taskState;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBundleTaskProgress that = (LoadBundleTaskProgress)o;
        if (this.documentsLoaded != that.documentsLoaded) {
            return false;
        }
        if (this.totalDocuments != that.totalDocuments) {
            return false;
        }
        if (this.bytesLoaded != that.bytesLoaded) {
            return false;
        }
        if (this.totalBytes != that.totalBytes) {
            return false;
        }
        if (this.taskState != that.taskState) {
            return false;
        }
        return this.exception != null ? this.exception.equals(that.exception) : that.exception == null;
    }

    public int hashCode() {
        int result = this.documentsLoaded;
        result = 31 * result + this.totalDocuments;
        result = 31 * result + (int)(this.bytesLoaded ^ this.bytesLoaded >>> 32);
        result = 31 * result + (int)(this.totalBytes ^ this.totalBytes >>> 32);
        result = 31 * result + this.taskState.hashCode();
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        return result;
    }

    public static enum TaskState {
        ERROR,
        RUNNING,
        SUCCESS;

    }
}

