/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.List;

public class KeyFieldInFilter
extends FieldFilter {
    private final List<DocumentKey> keys = new ArrayList<DocumentKey>();

    KeyFieldInFilter(FieldPath field, Value value) {
        super(field, Filter.Operator.IN, value);
        this.keys.addAll(KeyFieldInFilter.extractDocumentKeysFromArrayValue(Filter.Operator.IN, value));
    }

    @Override
    public boolean matches(Document doc) {
        return this.keys.contains(doc.getKey());
    }

    static List<DocumentKey> extractDocumentKeysFromArrayValue(Filter.Operator operator, Value value) {
        Assert.hardAssert(operator == Filter.Operator.IN || operator == Filter.Operator.NOT_IN, "extractDocumentKeysFromArrayValue requires IN or NOT_IN operators", new Object[0]);
        Assert.hardAssert(Values.isArray(value), "KeyFieldInFilter/KeyFieldNotInFilter expects an ArrayValue", new Object[0]);
        ArrayList<DocumentKey> keys = new ArrayList<DocumentKey>();
        for (Value element : value.getArrayValue().getValuesList()) {
            Assert.hardAssert(Values.isReferenceValue(element), "Comparing on key with " + operator.toString() + ", but an array value was not a ReferenceValue", new Object[0]);
            keys.add(DocumentKey.fromName(element.getReferenceValue()));
        }
        return keys;
    }
}

