/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.local.QueryEngine;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import java.util.Collections;
import java.util.Map;

public class DefaultQueryEngine
implements QueryEngine {
    private static final String LOG_TAG = "DefaultQueryEngine";
    private LocalDocumentsView localDocumentsView;

    @Override
    public void setLocalDocumentsView(LocalDocumentsView localDocuments) {
        this.localDocumentsView = localDocuments;
    }

    @Override
    public ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingQuery(Query query, SnapshotVersion lastLimboFreeSnapshotVersion, ImmutableSortedSet<DocumentKey> remoteKeys) {
        Assert.hardAssert(this.localDocumentsView != null, "setLocalDocumentsView() not called", new Object[0]);
        if (query.matchesAllDocuments()) {
            return this.executeFullCollectionScan(query);
        }
        if (lastLimboFreeSnapshotVersion.equals(SnapshotVersion.NONE)) {
            return this.executeFullCollectionScan(query);
        }
        ImmutableSortedMap<DocumentKey, MaybeDocument> documents = this.localDocumentsView.getDocuments((Iterable<DocumentKey>)remoteKeys);
        ImmutableSortedSet<Document> previousResults = this.applyQuery(query, documents);
        if ((query.hasLimitToFirst() || query.hasLimitToLast()) && this.needsRefill(query.getLimitType(), previousResults, remoteKeys, lastLimboFreeSnapshotVersion)) {
            return this.executeFullCollectionScan(query);
        }
        if (Logger.isDebugEnabled()) {
            Logger.debug(LOG_TAG, "Re-using previous result from %s to execute query: %s", lastLimboFreeSnapshotVersion.toString(), query.toString());
        }
        ImmutableSortedMap updatedResults = this.localDocumentsView.getDocumentsMatchingQuery(query, lastLimboFreeSnapshotVersion);
        for (Document result : previousResults) {
            updatedResults = updatedResults.insert((Object)result.getKey(), (Object)result);
        }
        return updatedResults;
    }

    private ImmutableSortedSet<Document> applyQuery(Query query, ImmutableSortedMap<DocumentKey, MaybeDocument> documents) {
        ImmutableSortedSet queryResults = new ImmutableSortedSet(Collections.emptyList(), query.comparator());
        for (Map.Entry entry : documents) {
            MaybeDocument maybeDoc = (MaybeDocument)entry.getValue();
            if (!(maybeDoc instanceof Document) || !query.matches((Document)maybeDoc)) continue;
            Document doc = (Document)maybeDoc;
            queryResults = queryResults.insert((Object)doc);
        }
        return queryResults;
    }

    private boolean needsRefill(Query.LimitType limitType, ImmutableSortedSet<Document> sortedPreviousResults, ImmutableSortedSet<DocumentKey> remoteKeys, SnapshotVersion limboFreeSnapshotVersion) {
        Document documentAtLimitEdge;
        if (remoteKeys.size() != sortedPreviousResults.size()) {
            return true;
        }
        Document document = documentAtLimitEdge = limitType == Query.LimitType.LIMIT_TO_FIRST ? (Document)sortedPreviousResults.getMaxEntry() : (Document)sortedPreviousResults.getMinEntry();
        if (documentAtLimitEdge == null) {
            return false;
        }
        return documentAtLimitEdge.hasPendingWrites() || documentAtLimitEdge.getVersion().compareTo(limboFreeSnapshotVersion) > 0;
    }

    @Override
    public void handleDocumentChange(MaybeDocument oldDocument, MaybeDocument newDocument) {
    }

    private ImmutableSortedMap<DocumentKey, Document> executeFullCollectionScan(Query query) {
        if (Logger.isDebugEnabled()) {
            Logger.debug(LOG_TAG, "Using full collection scan to execute query: %s", query.toString());
        }
        return this.localDocumentsView.getDocumentsMatchingQuery(query, SnapshotVersion.NONE);
    }
}

