/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.local.TargetData;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.proto.MaybeDocument;
import com.google.firebase.firestore.proto.NoDocument;
import com.google.firebase.firestore.proto.Target;
import com.google.firebase.firestore.proto.UnknownDocument;
import com.google.firebase.firestore.proto.WriteBatch;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentTransform;
import com.google.firestore.v1.Write;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;

public final class LocalSerializer {
    private final RemoteSerializer rpcSerializer;

    public LocalSerializer(RemoteSerializer rpcSerializer) {
        this.rpcSerializer = rpcSerializer;
    }

    com.google.firebase.firestore.proto.MaybeDocument encodeMaybeDocument(MaybeDocument document) {
        MaybeDocument.Builder builder = com.google.firebase.firestore.proto.MaybeDocument.newBuilder();
        if (document instanceof com.google.firebase.firestore.model.NoDocument) {
            com.google.firebase.firestore.model.NoDocument noDocument = (com.google.firebase.firestore.model.NoDocument)document;
            builder.setNoDocument(this.encodeNoDocument(noDocument));
            builder.setHasCommittedMutations(noDocument.hasCommittedMutations());
        } else if (document instanceof Document) {
            Document existingDocument = (Document)document;
            builder.setDocument(this.encodeDocument(existingDocument));
            builder.setHasCommittedMutations(existingDocument.hasCommittedMutations());
        } else if (document instanceof com.google.firebase.firestore.model.UnknownDocument) {
            builder.setUnknownDocument(this.encodeUnknownDocument((com.google.firebase.firestore.model.UnknownDocument)document));
            builder.setHasCommittedMutations(true);
        } else {
            throw Assert.fail("Unknown document type %s", document.getClass().getCanonicalName());
        }
        return (com.google.firebase.firestore.proto.MaybeDocument)builder.build();
    }

    MaybeDocument decodeMaybeDocument(com.google.firebase.firestore.proto.MaybeDocument proto) {
        switch (proto.getDocumentTypeCase()) {
            case DOCUMENT: {
                return this.decodeDocument(proto.getDocument(), proto.getHasCommittedMutations());
            }
            case NO_DOCUMENT: {
                return this.decodeNoDocument(proto.getNoDocument(), proto.getHasCommittedMutations());
            }
            case UNKNOWN_DOCUMENT: {
                return this.decodeUnknownDocument(proto.getUnknownDocument());
            }
        }
        throw Assert.fail("Unknown MaybeDocument %s", proto);
    }

    private com.google.firestore.v1.Document encodeDocument(Document document) {
        Document.Builder builder = com.google.firestore.v1.Document.newBuilder();
        builder.setName(this.rpcSerializer.encodeKey(document.getKey()));
        builder.putAllFields(document.getData().getFieldsMap());
        Timestamp updateTime = document.getVersion().getTimestamp();
        builder.setUpdateTime(this.rpcSerializer.encodeTimestamp(updateTime));
        return (com.google.firestore.v1.Document)builder.build();
    }

    private Document decodeDocument(com.google.firestore.v1.Document document, boolean hasCommittedMutations) {
        DocumentKey key = this.rpcSerializer.decodeKey(document.getName());
        SnapshotVersion version = this.rpcSerializer.decodeVersion(document.getUpdateTime());
        return new Document(key, version, ObjectValue.fromMap(document.getFieldsMap()), hasCommittedMutations ? Document.DocumentState.COMMITTED_MUTATIONS : Document.DocumentState.SYNCED);
    }

    private NoDocument encodeNoDocument(com.google.firebase.firestore.model.NoDocument document) {
        NoDocument.Builder builder = NoDocument.newBuilder();
        builder.setName(this.rpcSerializer.encodeKey(document.getKey()));
        builder.setReadTime(this.rpcSerializer.encodeTimestamp(document.getVersion().getTimestamp()));
        return (NoDocument)builder.build();
    }

    private com.google.firebase.firestore.model.NoDocument decodeNoDocument(NoDocument proto, boolean hasCommittedMutations) {
        DocumentKey key = this.rpcSerializer.decodeKey(proto.getName());
        SnapshotVersion version = this.rpcSerializer.decodeVersion(proto.getReadTime());
        return new com.google.firebase.firestore.model.NoDocument(key, version, hasCommittedMutations);
    }

    private UnknownDocument encodeUnknownDocument(com.google.firebase.firestore.model.UnknownDocument document) {
        UnknownDocument.Builder builder = UnknownDocument.newBuilder();
        builder.setName(this.rpcSerializer.encodeKey(document.getKey()));
        builder.setVersion(this.rpcSerializer.encodeTimestamp(document.getVersion().getTimestamp()));
        return (UnknownDocument)builder.build();
    }

    private com.google.firebase.firestore.model.UnknownDocument decodeUnknownDocument(UnknownDocument proto) {
        DocumentKey key = this.rpcSerializer.decodeKey(proto.getName());
        SnapshotVersion version = this.rpcSerializer.decodeVersion(proto.getVersion());
        return new com.google.firebase.firestore.model.UnknownDocument(key, version);
    }

    WriteBatch encodeMutationBatch(MutationBatch batch) {
        WriteBatch.Builder result = WriteBatch.newBuilder();
        result.setBatchId(batch.getBatchId());
        result.setLocalWriteTime(this.rpcSerializer.encodeTimestamp(batch.getLocalWriteTime()));
        for (Mutation mutation : batch.getBaseMutations()) {
            result.addBaseWrites(this.rpcSerializer.encodeMutation(mutation));
        }
        for (Mutation mutation : batch.getMutations()) {
            result.addWrites(this.rpcSerializer.encodeMutation(mutation));
        }
        return (WriteBatch)result.build();
    }

    MutationBatch decodeMutationBatch(WriteBatch batch) {
        int batchId = batch.getBatchId();
        Timestamp localWriteTime = this.rpcSerializer.decodeTimestamp(batch.getLocalWriteTime());
        int baseMutationsCount = batch.getBaseWritesCount();
        ArrayList<Mutation> baseMutations = new ArrayList<Mutation>(baseMutationsCount);
        for (int i = 0; i < baseMutationsCount; ++i) {
            baseMutations.add(this.rpcSerializer.decodeMutation(batch.getBaseWrites(i)));
        }
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(batch.getWritesCount());
        for (int i = batch.getWritesCount() - 1; i >= 0; --i) {
            Write mutation = batch.getWrites(i);
            if (mutation.hasTransform()) {
                Assert.hardAssert(i >= 1 && !batch.getWrites(i - 1).hasTransform() && batch.getWrites(i - 1).hasUpdate(), "TransformMutation should be preceded by a patch or set mutation", new Object[0]);
                Write mutationToJoin = batch.getWrites(i - 1);
                Write.Builder newMutationBuilder = Write.newBuilder(mutationToJoin);
                for (DocumentTransform.FieldTransform fieldTransform : mutation.getTransform().getFieldTransformsList()) {
                    newMutationBuilder.addUpdateTransforms(fieldTransform);
                }
                mutations.add(this.rpcSerializer.decodeMutation((Write)newMutationBuilder.build()));
                --i;
                continue;
            }
            mutations.add(this.rpcSerializer.decodeMutation(mutation));
        }
        Collections.reverse(mutations);
        return new MutationBatch(batchId, localWriteTime, baseMutations, mutations);
    }

    com.google.firebase.firestore.proto.Target encodeTargetData(TargetData targetData) {
        Assert.hardAssert(QueryPurpose.LISTEN.equals((Object)targetData.getPurpose()), "Only queries with purpose %s may be stored, got %s", new Object[]{QueryPurpose.LISTEN, targetData.getPurpose()});
        Target.Builder result = com.google.firebase.firestore.proto.Target.newBuilder();
        result.setTargetId(targetData.getTargetId()).setLastListenSequenceNumber(targetData.getSequenceNumber()).setLastLimboFreeSnapshotVersion(this.rpcSerializer.encodeVersion(targetData.getLastLimboFreeSnapshotVersion())).setSnapshotVersion(this.rpcSerializer.encodeVersion(targetData.getSnapshotVersion())).setResumeToken(targetData.getResumeToken());
        Target target = targetData.getTarget();
        if (target.isDocumentQuery()) {
            result.setDocuments(this.rpcSerializer.encodeDocumentsTarget(target));
        } else {
            result.setQuery(this.rpcSerializer.encodeQueryTarget(target));
        }
        return (com.google.firebase.firestore.proto.Target)result.build();
    }

    TargetData decodeTargetData(com.google.firebase.firestore.proto.Target targetProto) {
        Target target;
        int targetId = targetProto.getTargetId();
        SnapshotVersion version = this.rpcSerializer.decodeVersion(targetProto.getSnapshotVersion());
        SnapshotVersion lastLimboFreeSnapshotVersion = this.rpcSerializer.decodeVersion(targetProto.getLastLimboFreeSnapshotVersion());
        ByteString resumeToken = targetProto.getResumeToken();
        long sequenceNumber = targetProto.getLastListenSequenceNumber();
        switch (targetProto.getTargetTypeCase()) {
            case DOCUMENTS: {
                target = this.rpcSerializer.decodeDocumentsTarget(targetProto.getDocuments());
                break;
            }
            case QUERY: {
                target = this.rpcSerializer.decodeQueryTarget(targetProto.getQuery());
                break;
            }
            default: {
                throw Assert.fail("Unknown targetType %d", new Object[]{targetProto.getTargetTypeCase()});
            }
        }
        return new TargetData(target, targetId, sequenceNumber, QueryPurpose.LISTEN, version, lastLimboFreeSnapshotVersion, resumeToken);
    }
}

