/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.List;

public abstract class Mutation {
    private final DocumentKey key;
    private final Precondition precondition;
    private final List<FieldTransform> fieldTransforms;

    Mutation(DocumentKey key, Precondition precondition) {
        this(key, precondition, new ArrayList<FieldTransform>());
    }

    Mutation(DocumentKey key, Precondition precondition, List<FieldTransform> fieldTransforms) {
        this.key = key;
        this.precondition = precondition;
        this.fieldTransforms = fieldTransforms;
    }

    public DocumentKey getKey() {
        return this.key;
    }

    public Precondition getPrecondition() {
        return this.precondition;
    }

    public List<FieldTransform> getFieldTransforms() {
        return this.fieldTransforms;
    }

    public abstract MaybeDocument applyToRemoteDocument(@Nullable MaybeDocument var1, MutationResult var2);

    @Nullable
    public abstract MaybeDocument applyToLocalView(@Nullable MaybeDocument var1, Timestamp var2);

    boolean hasSameKeyAndPrecondition(Mutation other) {
        return this.key.equals(other.key) && this.precondition.equals(other.precondition);
    }

    int keyAndPreconditionHashCode() {
        return this.getKey().hashCode() * 31 + this.precondition.hashCode();
    }

    String keyAndPreconditionToString() {
        return "key=" + this.key + ", precondition=" + this.precondition;
    }

    void verifyKeyMatches(@Nullable MaybeDocument maybeDoc) {
        if (maybeDoc != null) {
            Assert.hardAssert(maybeDoc.getKey().equals(this.getKey()), "Can only apply a mutation to a document with the same key", new Object[0]);
        }
    }

    static SnapshotVersion getPostMutationVersion(@Nullable MaybeDocument maybeDoc) {
        if (maybeDoc instanceof Document) {
            return maybeDoc.getVersion();
        }
        return SnapshotVersion.NONE;
    }

    protected List<Value> serverTransformResults(@Nullable MaybeDocument maybeDoc, List<Value> serverTransformResults) {
        ArrayList<Value> transformResults = new ArrayList<Value>(this.fieldTransforms.size());
        Assert.hardAssert(this.fieldTransforms.size() == serverTransformResults.size(), "server transform count (%d) should match field transform count (%d)", serverTransformResults.size(), this.fieldTransforms.size());
        for (int i = 0; i < serverTransformResults.size(); ++i) {
            FieldTransform fieldTransform = this.fieldTransforms.get(i);
            TransformOperation transform = fieldTransform.getOperation();
            Value previousValue = null;
            if (maybeDoc instanceof Document) {
                previousValue = ((Document)maybeDoc).getField(fieldTransform.getFieldPath());
            }
            transformResults.add(transform.applyToRemoteDocument(previousValue, serverTransformResults.get(i)));
        }
        return transformResults;
    }

    protected List<Value> localTransformResults(Timestamp localWriteTime, @Nullable MaybeDocument maybeDoc) {
        ArrayList<Value> transformResults = new ArrayList<Value>(this.fieldTransforms.size());
        for (FieldTransform fieldTransform : this.fieldTransforms) {
            TransformOperation transform = fieldTransform.getOperation();
            Value previousValue = null;
            if (maybeDoc instanceof Document) {
                previousValue = ((Document)maybeDoc).getField(fieldTransform.getFieldPath());
            }
            transformResults.add(transform.applyToLocalView(previousValue, localWriteTime));
        }
        return transformResults;
    }

    ObjectValue transformObject(ObjectValue objectValue, List<Value> transformResults) {
        Assert.hardAssert(transformResults.size() == this.fieldTransforms.size(), "Transform results length mismatch.", new Object[0]);
        ObjectValue.Builder builder = objectValue.toBuilder();
        for (int i = 0; i < this.fieldTransforms.size(); ++i) {
            FieldTransform fieldTransform = this.fieldTransforms.get(i);
            FieldPath fieldPath = fieldTransform.getFieldPath();
            builder.set(fieldPath, transformResults.get(i));
        }
        return builder.build();
    }

    public ObjectValue extractTransformBaseValue(@Nullable MaybeDocument maybeDoc) {
        ObjectValue.Builder baseObject = null;
        for (FieldTransform transform : this.fieldTransforms) {
            Value coercedValue;
            Value existingValue = null;
            if (maybeDoc instanceof Document) {
                existingValue = ((Document)maybeDoc).getField(transform.getFieldPath());
            }
            if ((coercedValue = transform.getOperation().computeBaseValue(existingValue)) == null) continue;
            if (baseObject == null) {
                baseObject = ObjectValue.newBuilder();
            }
            baseObject.set(transform.getFieldPath(), coercedValue);
        }
        return baseObject != null ? baseObject.build() : null;
    }
}

