/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatchResult;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.util.Assert;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MutationBatch {
    public static final int UNKNOWN = -1;
    private final int batchId;
    private final Timestamp localWriteTime;
    private final List<Mutation> baseMutations;
    private final List<Mutation> mutations;

    public MutationBatch(int batchId, Timestamp localWriteTime, List<Mutation> baseMutations, List<Mutation> mutations) {
        Assert.hardAssert(!mutations.isEmpty(), "Cannot create an empty mutation batch", new Object[0]);
        this.batchId = batchId;
        this.localWriteTime = localWriteTime;
        this.baseMutations = baseMutations;
        this.mutations = mutations;
    }

    @Nullable
    public MaybeDocument applyToRemoteDocument(DocumentKey documentKey, @Nullable MaybeDocument maybeDoc, MutationBatchResult batchResult) {
        if (maybeDoc != null) {
            Assert.hardAssert(maybeDoc.getKey().equals(documentKey), "applyToRemoteDocument: key %s doesn't match maybeDoc key %s", documentKey, maybeDoc.getKey());
        }
        int size = this.mutations.size();
        List<MutationResult> mutationResults = batchResult.getMutationResults();
        Assert.hardAssert(mutationResults.size() == size, "Mismatch between mutations length (%d) and results length (%d)", size, mutationResults.size());
        for (int i = 0; i < size; ++i) {
            Mutation mutation = this.mutations.get(i);
            if (!mutation.getKey().equals(documentKey)) continue;
            MutationResult mutationResult = mutationResults.get(i);
            maybeDoc = mutation.applyToRemoteDocument(maybeDoc, mutationResult);
        }
        return maybeDoc;
    }

    @Nullable
    public MaybeDocument applyToLocalView(DocumentKey documentKey, @Nullable MaybeDocument maybeDoc) {
        Mutation mutation;
        int i;
        if (maybeDoc != null) {
            Assert.hardAssert(maybeDoc.getKey().equals(documentKey), "applyToRemoteDocument: key %s doesn't match maybeDoc key %s", documentKey, maybeDoc.getKey());
        }
        for (i = 0; i < this.baseMutations.size(); ++i) {
            mutation = this.baseMutations.get(i);
            if (!mutation.getKey().equals(documentKey)) continue;
            maybeDoc = mutation.applyToLocalView(maybeDoc, this.localWriteTime);
        }
        for (i = 0; i < this.mutations.size(); ++i) {
            mutation = this.mutations.get(i);
            if (!mutation.getKey().equals(documentKey)) continue;
            maybeDoc = mutation.applyToLocalView(maybeDoc, this.localWriteTime);
        }
        return maybeDoc;
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> applyToLocalDocumentSet(ImmutableSortedMap<DocumentKey, MaybeDocument> maybeDocumentMap) {
        ImmutableSortedMap mutatedDocuments = maybeDocumentMap;
        for (DocumentKey key : this.getKeys()) {
            MaybeDocument mutatedDocument = this.applyToLocalView(key, (MaybeDocument)mutatedDocuments.get((Object)key));
            if (mutatedDocument == null) continue;
            mutatedDocuments = mutatedDocuments.insert((Object)mutatedDocument.getKey(), (Object)mutatedDocument);
        }
        return mutatedDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationBatch that = (MutationBatch)o;
        return this.batchId == that.batchId && this.localWriteTime.equals(that.localWriteTime) && this.baseMutations.equals(that.baseMutations) && this.mutations.equals(that.mutations);
    }

    public int hashCode() {
        int result = this.batchId;
        result = 31 * result + this.localWriteTime.hashCode();
        result = 31 * result + this.baseMutations.hashCode();
        result = 31 * result + this.mutations.hashCode();
        return result;
    }

    public String toString() {
        return "MutationBatch(batchId=" + this.batchId + ", localWriteTime=" + this.localWriteTime + ", baseMutations=" + this.baseMutations + ", mutations=" + this.mutations + ')';
    }

    public Set<DocumentKey> getKeys() {
        HashSet<DocumentKey> set = new HashSet<DocumentKey>();
        for (Mutation mutation : this.mutations) {
            set.add(mutation.getKey());
        }
        return set;
    }

    public int getBatchId() {
        return this.batchId;
    }

    public Timestamp getLocalWriteTime() {
        return this.localWriteTime;
    }

    public List<Mutation> getMutations() {
        return this.mutations;
    }

    public List<Mutation> getBaseMutations() {
        return this.baseMutations;
    }
}

