/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.List;

public final class SetMutation
extends Mutation {
    private final ObjectValue value;

    public SetMutation(DocumentKey key, ObjectValue value, Precondition precondition) {
        this(key, value, precondition, new ArrayList<FieldTransform>());
    }

    public SetMutation(DocumentKey key, ObjectValue value, Precondition precondition, List<FieldTransform> fieldTransforms) {
        super(key, precondition, fieldTransforms);
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetMutation that = (SetMutation)o;
        return this.hasSameKeyAndPrecondition(that) && this.value.equals(that.value) && this.getFieldTransforms().equals(that.getFieldTransforms());
    }

    public int hashCode() {
        int result = this.keyAndPreconditionHashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "SetMutation{" + this.keyAndPreconditionToString() + ", value=" + this.value + "}";
    }

    @Override
    public MaybeDocument applyToRemoteDocument(@Nullable MaybeDocument maybeDoc, MutationResult mutationResult) {
        this.verifyKeyMatches(maybeDoc);
        SnapshotVersion version = mutationResult.getVersion();
        ObjectValue newData = this.value;
        if (mutationResult.getTransformResults() != null) {
            List<Value> transformResults = this.serverTransformResults(maybeDoc, mutationResult.getTransformResults());
            newData = this.transformObject(newData, transformResults);
        }
        return new Document(this.getKey(), version, newData, Document.DocumentState.COMMITTED_MUTATIONS);
    }

    @Override
    @Nullable
    public MaybeDocument applyToLocalView(@Nullable MaybeDocument maybeDoc, Timestamp localWriteTime) {
        this.verifyKeyMatches(maybeDoc);
        if (!this.getPrecondition().isValidFor(maybeDoc)) {
            return maybeDoc;
        }
        List<Value> transformResults = this.localTransformResults(localWriteTime, maybeDoc);
        ObjectValue newData = this.transformObject(this.value, transformResults);
        SnapshotVersion version = SetMutation.getPostMutationVersion(maybeDoc);
        return new Document(this.getKey(), version, newData, Document.DocumentState.LOCAL_MUTATIONS);
    }

    public ObjectValue getValue() {
        return this.value;
    }
}

