/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.firestore.remote.AbstractStream$$Lambda$1;
import com.google.firebase.firestore.remote.AbstractStream$StreamObserver$$Lambda$1;
import com.google.firebase.firestore.remote.AbstractStream$StreamObserver$$Lambda$2;
import com.google.firebase.firestore.remote.AbstractStream$StreamObserver$$Lambda$3;
import com.google.firebase.firestore.remote.AbstractStream$StreamObserver$$Lambda$4;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.FirestoreChannel;
import com.google.firebase.firestore.remote.IncomingStreamObserver;
import com.google.firebase.firestore.remote.Stream;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.ExponentialBackoff;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

abstract class AbstractStream<ReqT, RespT, CallbackT extends Stream.StreamCallback>
implements Stream<CallbackT> {
    private static final long BACKOFF_INITIAL_DELAY_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final long BACKOFF_MAX_DELAY_MS = TimeUnit.MINUTES.toMillis(1L);
    private static final double BACKOFF_FACTOR = 1.5;
    private static final long IDLE_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(1L);
    private static final long BACKOFF_CLIENT_NETWORK_FAILURE_MAX_DELAY_MS = TimeUnit.SECONDS.toMillis(10L);
    @Nullable
    private AsyncQueue.DelayedTask idleTimer;
    private final FirestoreChannel firestoreChannel;
    private final MethodDescriptor<ReqT, RespT> methodDescriptor;
    private final IdleTimeoutRunnable idleTimeoutRunnable;
    private final AsyncQueue workerQueue;
    private final AsyncQueue.TimerId idleTimerId;
    private Stream.State state = Stream.State.Initial;
    private long closeCount = 0L;
    private ClientCall<ReqT, RespT> call;
    final ExponentialBackoff backoff;
    final CallbackT listener;

    AbstractStream(FirestoreChannel channel, MethodDescriptor<ReqT, RespT> methodDescriptor, AsyncQueue workerQueue, AsyncQueue.TimerId connectionTimerId, AsyncQueue.TimerId idleTimerId, CallbackT listener) {
        this.firestoreChannel = channel;
        this.methodDescriptor = methodDescriptor;
        this.workerQueue = workerQueue;
        this.idleTimerId = idleTimerId;
        this.listener = listener;
        this.idleTimeoutRunnable = new IdleTimeoutRunnable();
        this.backoff = new ExponentialBackoff(workerQueue, connectionTimerId, BACKOFF_INITIAL_DELAY_MS, 1.5, BACKOFF_MAX_DELAY_MS);
    }

    @Override
    public boolean isStarted() {
        this.workerQueue.verifyIsCurrentThread();
        return this.state == Stream.State.Starting || this.state == Stream.State.Open || this.state == Stream.State.Backoff;
    }

    @Override
    public boolean isOpen() {
        this.workerQueue.verifyIsCurrentThread();
        return this.state == Stream.State.Open;
    }

    @Override
    public void start() {
        this.workerQueue.verifyIsCurrentThread();
        Assert.hardAssert(this.call == null, "Last call still set", new Object[0]);
        Assert.hardAssert(this.idleTimer == null, "Idle timer still set", new Object[0]);
        if (this.state == Stream.State.Error) {
            this.performBackoff();
            return;
        }
        Assert.hardAssert(this.state == Stream.State.Initial, "Already started", new Object[0]);
        CloseGuardedRunner closeGuardedRunner = new CloseGuardedRunner(this.closeCount);
        StreamObserver streamObserver = new StreamObserver(closeGuardedRunner);
        this.call = this.firestoreChannel.runBidiStreamingRpc(this.methodDescriptor, streamObserver);
        this.state = Stream.State.Starting;
    }

    private void close(Stream.State finalState, Status status) {
        Assert.hardAssert(this.isStarted(), "Only started streams should be closed.", new Object[0]);
        Assert.hardAssert(finalState == Stream.State.Error || status.equals((Object)Status.OK), "Can't provide an error when not in an error state.", new Object[0]);
        this.workerQueue.verifyIsCurrentThread();
        if (Datastore.isMissingSslCiphers(status)) {
            Util.crashMainThread(new IllegalStateException("The Cloud Firestore client failed to establish a secure connection. This is likely a problem with your app, rather than with Cloud Firestore itself. See https://bit.ly/2XFpdma for instructions on how to enable TLS on Android 4.x devices.", status.getCause()));
        }
        this.cancelIdleCheck();
        this.backoff.cancel();
        ++this.closeCount;
        Status.Code code = status.getCode();
        if (code == Status.Code.OK) {
            this.backoff.reset();
        } else if (code == Status.Code.RESOURCE_EXHAUSTED) {
            Logger.debug(this.getClass().getSimpleName(), "(%x) Using maximum backoff delay to prevent overloading the backend.", System.identityHashCode(this));
            this.backoff.resetToMax();
        } else if (code == Status.Code.UNAUTHENTICATED) {
            this.firestoreChannel.invalidateToken();
        } else if (code == Status.Code.UNAVAILABLE && (status.getCause() instanceof UnknownHostException || status.getCause() instanceof ConnectException)) {
            this.backoff.setTemporaryMaxDelay(BACKOFF_CLIENT_NETWORK_FAILURE_MAX_DELAY_MS);
        }
        if (finalState != Stream.State.Error) {
            Logger.debug(this.getClass().getSimpleName(), "(%x) Performing stream teardown", System.identityHashCode(this));
            this.tearDown();
        }
        if (this.call != null) {
            if (status.isOk()) {
                Logger.debug(this.getClass().getSimpleName(), "(%x) Closing stream client-side", System.identityHashCode(this));
                this.call.halfClose();
            }
            this.call = null;
        }
        this.state = finalState;
        this.listener.onClose(status);
    }

    protected void tearDown() {
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            this.close(Stream.State.Initial, Status.OK);
        }
    }

    @Override
    public void inhibitBackoff() {
        Assert.hardAssert(!this.isStarted(), "Can only inhibit backoff after in a stopped state", new Object[0]);
        this.workerQueue.verifyIsCurrentThread();
        this.state = Stream.State.Initial;
        this.backoff.reset();
    }

    protected void writeRequest(ReqT message) {
        this.workerQueue.verifyIsCurrentThread();
        Logger.debug(this.getClass().getSimpleName(), "(%x) Stream sending: %s", System.identityHashCode(this), message);
        this.cancelIdleCheck();
        this.call.sendMessage(message);
    }

    private void handleIdleCloseTimer() {
        if (this.isOpen()) {
            this.close(Stream.State.Initial, Status.OK);
        }
    }

    @VisibleForTesting
    void handleServerClose(Status status) {
        Assert.hardAssert(this.isStarted(), "Can't handle server close on non-started stream!", new Object[0]);
        this.close(Stream.State.Error, status);
    }

    private void onOpen() {
        this.state = Stream.State.Open;
        this.listener.onOpen();
    }

    public abstract void onNext(RespT var1);

    private void performBackoff() {
        Assert.hardAssert(this.state == Stream.State.Error, "Should only perform backoff in an error state", new Object[0]);
        this.state = Stream.State.Backoff;
        this.backoff.backoffAndRun(AbstractStream$$Lambda$1.lambdaFactory$(this));
    }

    void markIdle() {
        if (this.isOpen() && this.idleTimer == null) {
            this.idleTimer = this.workerQueue.enqueueAfterDelay(this.idleTimerId, IDLE_TIMEOUT_MS, this.idleTimeoutRunnable);
        }
    }

    private void cancelIdleCheck() {
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
            this.idleTimer = null;
        }
    }

    static /* synthetic */ void lambda$performBackoff$0(AbstractStream this_) {
        Assert.hardAssert(this_.state == Stream.State.Backoff, "State should still be backoff but was %s", new Object[]{this_.state});
        this_.state = Stream.State.Initial;
        this_.start();
        Assert.hardAssert(this_.isStarted(), "Stream should have started", new Object[0]);
    }

    @VisibleForTesting
    class IdleTimeoutRunnable
    implements Runnable {
        IdleTimeoutRunnable() {
        }

        @Override
        public void run() {
            AbstractStream.this.handleIdleCloseTimer();
        }
    }

    class StreamObserver
    implements IncomingStreamObserver<RespT> {
        private final CloseGuardedRunner dispatcher;

        StreamObserver(CloseGuardedRunner dispatcher) {
            this.dispatcher = dispatcher;
        }

        @Override
        public void onHeaders(Metadata headers) {
            this.dispatcher.run(AbstractStream$StreamObserver$$Lambda$1.lambdaFactory$(this, headers));
        }

        @Override
        public void onNext(RespT response) {
            this.dispatcher.run(AbstractStream$StreamObserver$$Lambda$2.lambdaFactory$(this, response));
        }

        @Override
        public void onOpen() {
            this.dispatcher.run(AbstractStream$StreamObserver$$Lambda$3.lambdaFactory$(this));
        }

        @Override
        public void onClose(Status status) {
            this.dispatcher.run(AbstractStream$StreamObserver$$Lambda$4.lambdaFactory$(this, status));
        }

        static /* synthetic */ void lambda$onClose$3(StreamObserver this_, Status status) {
            if (status.isOk()) {
                Logger.debug(this_.AbstractStream.this.getClass().getSimpleName(), "(%x) Stream closed.", System.identityHashCode(this_.AbstractStream.this));
            } else {
                Logger.warn(this_.AbstractStream.this.getClass().getSimpleName(), "(%x) Stream closed with status: %s.", System.identityHashCode(this_.AbstractStream.this), status);
            }
            this_.AbstractStream.this.handleServerClose(status);
        }

        static /* synthetic */ void lambda$onOpen$2(StreamObserver this_) {
            Logger.debug(this_.AbstractStream.this.getClass().getSimpleName(), "(%x) Stream is open", System.identityHashCode(this_.AbstractStream.this));
            this_.AbstractStream.this.onOpen();
        }

        static /* synthetic */ void lambda$onNext$1(StreamObserver this_, Object response) {
            if (Logger.isDebugEnabled()) {
                Logger.debug(this_.AbstractStream.this.getClass().getSimpleName(), "(%x) Stream received: %s", System.identityHashCode(this_.AbstractStream.this), response);
            }
            this_.AbstractStream.this.onNext(response);
        }

        static /* synthetic */ void lambda$onHeaders$0(StreamObserver this_, Metadata headers) {
            if (Logger.isDebugEnabled()) {
                HashMap<String, String> allowlistedHeaders = new HashMap<String, String>();
                for (String header : headers.keys()) {
                    if (!Datastore.WHITE_LISTED_HEADERS.contains(header.toLowerCase(Locale.ENGLISH))) continue;
                    allowlistedHeaders.put(header, (String)headers.get(Metadata.Key.of((String)header, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
                }
                if (!allowlistedHeaders.isEmpty()) {
                    Logger.debug(this_.AbstractStream.this.getClass().getSimpleName(), "(%x) Stream received headers: %s", System.identityHashCode(this_.AbstractStream.this), allowlistedHeaders);
                }
            }
        }
    }

    class CloseGuardedRunner {
        private final long initialCloseCount;

        CloseGuardedRunner(long initialCloseCount) {
            this.initialCloseCount = initialCloseCount;
        }

        void run(Runnable task) {
            AbstractStream.this.workerQueue.verifyIsCurrentThread();
            if (AbstractStream.this.closeCount == this.initialCloseCount) {
                task.run();
            } else {
                Logger.debug(AbstractStream.this.getClass().getSimpleName(), "stream callback skipped by CloseGuardedRunner.", new Object[0]);
            }
        }
    }
}

