/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import android.util.Log;

public class Logger {
    private static Level logLevel = Level.WARN;

    public static void setLogLevel(Level level) {
        logLevel = level;
    }

    public static boolean isDebugEnabled() {
        return logLevel.ordinal() >= Level.DEBUG.ordinal();
    }

    private static void doLog(Level level, String tag, String toLog, Object ... values) {
        if (level.ordinal() >= logLevel.ordinal()) {
            String value = String.format("(%s) [%s]: ", "22.0.2", tag) + String.format(toLog, values);
            switch (level) {
                case DEBUG: {
                    Log.i((String)"Firestore", (String)value);
                    return;
                }
                case WARN: {
                    Log.w((String)"Firestore", (String)value);
                    return;
                }
                case NONE: {
                    throw new IllegalStateException("Trying to log something on level NONE");
                }
            }
        }
    }

    public static void warn(String tag, String toLog, Object ... values) {
        Logger.doLog(Level.WARN, tag, toLog, values);
    }

    public static void debug(String tag, String toLog, Object ... values) {
        Logger.doLog(Level.DEBUG, tag, toLog, values);
    }

    public static enum Level {
        DEBUG,
        WARN,
        NONE;

    }
}

