/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.bundle;

import android.util.Base64;
import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.bundle.BundleDocument;
import com.google.firebase.firestore.bundle.BundleMetadata;
import com.google.firebase.firestore.bundle.BundledDocumentMetadata;
import com.google.firebase.firestore.bundle.BundledQuery;
import com.google.firebase.firestore.bundle.NamedQuery;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import com.google.type.LatLng;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BundleSerializer {
    private static final long MILLIS_PER_SECOND = 1000L;
    private final SimpleDateFormat timestampFormat;
    private final RemoteSerializer remoteSerializer;

    public BundleSerializer(RemoteSerializer remoteSerializer) {
        this.remoteSerializer = remoteSerializer;
        this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        this.timestampFormat.setCalendar(calendar);
    }

    public NamedQuery decodeNamedQuery(JSONObject namedQuery) throws JSONException {
        String name = namedQuery.getString("name");
        BundledQuery bundledQuery = this.decodeBundledQuery(namedQuery.getJSONObject("bundledQuery"));
        SnapshotVersion readTime = this.decodeSnapshotVersion(namedQuery.get("readTime"));
        return new NamedQuery(name, bundledQuery, readTime);
    }

    public BundleMetadata decodeBundleMetadata(JSONObject bundleMetadata) throws JSONException {
        String bundleId = bundleMetadata.getString("id");
        int version = bundleMetadata.getInt("version");
        SnapshotVersion createTime = this.decodeSnapshotVersion(bundleMetadata.get("createTime"));
        int totalDocuments = bundleMetadata.getInt("totalDocuments");
        long totalBytes = bundleMetadata.getLong("totalBytes");
        return new BundleMetadata(bundleId, version, createTime, totalDocuments, totalBytes);
    }

    public BundledDocumentMetadata decodeBundledDocumentMetadata(JSONObject bundledDocumentMetadata) throws JSONException {
        DocumentKey key = DocumentKey.fromPath(this.decodeName(bundledDocumentMetadata.getString("name")));
        SnapshotVersion readTime = this.decodeSnapshotVersion(bundledDocumentMetadata.get("readTime"));
        boolean exists = bundledDocumentMetadata.optBoolean("exists", false);
        JSONArray queriesJson = bundledDocumentMetadata.optJSONArray("queries");
        ArrayList<String> queries = new ArrayList<String>();
        if (queriesJson != null) {
            for (int i = 0; i < queriesJson.length(); ++i) {
                queries.add(queriesJson.getString(i));
            }
        }
        return new BundledDocumentMetadata(key, readTime, exists, queries);
    }

    BundleDocument decodeDocument(JSONObject document) throws JSONException {
        String name = document.getString("name");
        DocumentKey key = DocumentKey.fromPath(this.decodeName(name));
        SnapshotVersion updateTime = this.decodeSnapshotVersion(document.get("updateTime"));
        Value.Builder value = Value.newBuilder();
        this.decodeMapValue(value, document.getJSONObject("fields"));
        return new BundleDocument(MutableDocument.newFoundDocument(key, updateTime, ObjectValue.fromMap(value.getMapValue().getFieldsMap())));
    }

    private ResourcePath decodeName(String name) {
        ResourcePath resourcePath = ResourcePath.fromString(name);
        if (!this.remoteSerializer.isLocalResourceName(resourcePath)) {
            throw new IllegalArgumentException("Resource name is not valid for current instance: " + name);
        }
        return (ResourcePath)resourcePath.popFirst(5);
    }

    private SnapshotVersion decodeSnapshotVersion(Object timestamp) throws JSONException {
        return new SnapshotVersion(this.decodeTimestamp(timestamp));
    }

    private BundledQuery decodeBundledQuery(JSONObject bundledQuery) throws JSONException {
        JSONObject structuredQuery = bundledQuery.getJSONObject("structuredQuery");
        this.verifyNoSelect(structuredQuery);
        ResourcePath parent = this.decodeName(bundledQuery.getString("parent"));
        JSONArray from = structuredQuery.getJSONArray("from");
        this.verifyCollectionSelector(from);
        JSONObject collectionSelector = from.getJSONObject(0);
        boolean allDescendants = collectionSelector.optBoolean("allDescendants", false);
        String collectionGroup = null;
        if (allDescendants) {
            collectionGroup = collectionSelector.getString("collectionId");
        } else {
            parent = (ResourcePath)((Object)parent.append(collectionSelector.getString("collectionId")));
        }
        List<Filter> filters = this.decodeWhere(structuredQuery.optJSONObject("where"));
        List<OrderBy> orderBys = this.decodeOrderBy(structuredQuery.optJSONArray("orderBy"));
        Bound startAt = this.decodeBound(structuredQuery.optJSONObject("startAt"));
        Bound endAt = this.decodeBound(structuredQuery.optJSONObject("endAt"));
        this.verifyNoOffset(structuredQuery);
        int limit = this.decodeLimit(structuredQuery);
        Query.LimitType limitType = this.decodeLimitType(bundledQuery);
        return new BundledQuery(new Target(parent, collectionGroup, filters, orderBys, limit, startAt, endAt), limitType);
    }

    private int decodeLimit(JSONObject structuredQuery) {
        JSONObject limit = structuredQuery.optJSONObject("limit");
        if (limit != null) {
            return limit.optInt("value", -1);
        }
        return structuredQuery.optInt("limit", -1);
    }

    private Bound decodeBound(@Nullable JSONObject bound) throws JSONException {
        if (bound != null) {
            ArrayList<Value> cursor = new ArrayList<Value>();
            boolean before = bound.optBoolean("before", false);
            JSONArray values = bound.optJSONArray("values");
            if (values != null) {
                for (int i = 0; i < values.length(); ++i) {
                    cursor.add(this.decodeValue(values.getJSONObject(i)));
                }
            }
            return new Bound(cursor, before);
        }
        return null;
    }

    private List<OrderBy> decodeOrderBy(@Nullable JSONArray orderBys) throws JSONException {
        ArrayList<OrderBy> result = new ArrayList<OrderBy>();
        if (orderBys != null) {
            for (int i = 0; i < orderBys.length(); ++i) {
                JSONObject orderBy = orderBys.getJSONObject(i);
                FieldPath fieldPath = this.decodeFieldReference(orderBy.getJSONObject("field"));
                String directionString = orderBy.optString("direction", "ASCENDING");
                OrderBy.Direction direction = directionString.equals("ASCENDING") ? OrderBy.Direction.ASCENDING : OrderBy.Direction.DESCENDING;
                result.add(OrderBy.getInstance(direction, fieldPath));
            }
        }
        return result;
    }

    private List<Filter> decodeWhere(@Nullable JSONObject where) throws JSONException {
        ArrayList<Filter> result = new ArrayList<Filter>();
        if (where != null) {
            this.decodeFilter(result, where);
        }
        return result;
    }

    private void decodeFilter(List<Filter> result, JSONObject structuredQuery) throws JSONException {
        if (structuredQuery.has("compositeFilter")) {
            this.decodeCompositeFilter(result, structuredQuery.getJSONObject("compositeFilter"));
        } else if (structuredQuery.has("fieldFilter")) {
            this.decodeFieldFilter(result, structuredQuery.getJSONObject("fieldFilter"));
        } else if (structuredQuery.has("unaryFilter")) {
            this.decodeUnaryFilter(result, structuredQuery.getJSONObject("unaryFilter"));
        }
    }

    private void decodeCompositeFilter(List<Filter> result, JSONObject compositeFilter) throws JSONException {
        if (!compositeFilter.getString("op").equals("AND")) {
            throw new IllegalArgumentException("The Android SDK only supports composite filters of type 'AND'");
        }
        JSONArray filters = compositeFilter.optJSONArray("filters");
        if (filters != null) {
            for (int i = 0; i < filters.length(); ++i) {
                this.decodeFilter(result, filters.getJSONObject(i));
            }
        }
    }

    private void decodeFieldFilter(List<Filter> result, JSONObject fieldFilter) throws JSONException {
        FieldPath fieldPath = this.decodeFieldReference(fieldFilter.getJSONObject("field"));
        Filter.Operator filterOperator = this.decodeFieldFilterOperator(fieldFilter.getString("op"));
        result.add(FieldFilter.create(fieldPath, filterOperator, this.decodeValue(fieldFilter.getJSONObject("value"))));
    }

    private Value decodeValue(JSONObject value) throws JSONException {
        Value.Builder builder = Value.newBuilder();
        if (value.has("nullValue")) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else if (value.has("booleanValue")) {
            builder.setBooleanValue(value.optBoolean("booleanValue", false));
        } else if (value.has("integerValue")) {
            builder.setIntegerValue(value.optLong("integerValue"));
        } else if (value.has("doubleValue")) {
            builder.setDoubleValue(value.optDouble("doubleValue"));
        } else if (value.has("timestampValue")) {
            this.decodeTimestamp(builder, value.get("timestampValue"));
        } else if (value.has("stringValue")) {
            builder.setStringValue(value.optString("stringValue", ""));
        } else if (value.has("bytesValue")) {
            builder.setBytesValue(ByteString.copyFrom((byte[])Base64.decode((String)value.getString("bytesValue"), (int)0)));
        } else if (value.has("referenceValue")) {
            builder.setReferenceValue(value.getString("referenceValue"));
        } else if (value.has("geoPointValue")) {
            this.decodeGeoPoint(builder, value.getJSONObject("geoPointValue"));
        } else if (value.has("arrayValue")) {
            this.decodeArrayValue(builder, value.getJSONObject("arrayValue").optJSONArray("values"));
        } else if (value.has("mapValue")) {
            this.decodeMapValue(builder, value.getJSONObject("mapValue").optJSONObject("fields"));
        } else {
            throw new IllegalArgumentException("Unexpected value type: " + value);
        }
        return (Value)builder.build();
    }

    private void decodeArrayValue(Value.Builder builder, @Nullable JSONArray values) throws JSONException {
        ArrayValue.Builder arrayBuilder = ArrayValue.newBuilder();
        if (values != null) {
            for (int i = 0; i < values.length(); ++i) {
                arrayBuilder.addValues(this.decodeValue(values.getJSONObject(i)));
            }
        }
        builder.setArrayValue(arrayBuilder);
    }

    private void decodeMapValue(Value.Builder builder, @Nullable JSONObject map) throws JSONException {
        MapValue.Builder mapBuilder = MapValue.newBuilder();
        if (map != null) {
            Iterator it = map.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                mapBuilder.putFields(key, this.decodeValue(map.getJSONObject(key)));
            }
        }
        builder.setMapValue(mapBuilder);
    }

    private void decodeGeoPoint(Value.Builder builder, JSONObject geoPoint) {
        builder.setGeoPointValue(LatLng.newBuilder().setLatitude(geoPoint.optDouble("latitude")).setLongitude(geoPoint.optDouble("longitude")));
    }

    private Timestamp decodeTimestamp(JSONObject timestamp) {
        return new Timestamp(timestamp.optLong("seconds"), timestamp.optInt("nanos"));
    }

    private Timestamp decodeTimestamp(String timestamp) {
        try {
            int nanos;
            String timeValue;
            int dayOffset = timestamp.indexOf(84);
            if (dayOffset == -1) {
                throw new IllegalArgumentException("Invalid timestamp: " + timestamp);
            }
            int timezoneOffsetPosition = timestamp.indexOf(90, dayOffset);
            if (timezoneOffsetPosition == -1) {
                timezoneOffsetPosition = timestamp.indexOf(43, dayOffset);
            }
            if (timezoneOffsetPosition == -1) {
                timezoneOffsetPosition = timestamp.indexOf(45, dayOffset);
            }
            if (timezoneOffsetPosition == -1) {
                throw new IllegalArgumentException("Invalid timestamp: Missing valid timezone offset: " + timestamp);
            }
            String secondValue = timeValue = timestamp.substring(0, timezoneOffsetPosition);
            String nanoValue = "";
            int pointPosition = timeValue.indexOf(46);
            if (pointPosition != -1) {
                secondValue = timeValue.substring(0, pointPosition);
                nanoValue = timeValue.substring(pointPosition + 1);
            }
            Date date = this.timestampFormat.parse(secondValue);
            long seconds = date.getTime() / 1000L;
            int n = nanos = nanoValue.isEmpty() ? 0 : BundleSerializer.parseNanos(nanoValue);
            if (timestamp.charAt(timezoneOffsetPosition) == 'Z') {
                if (timestamp.length() != timezoneOffsetPosition + 1) {
                    throw new IllegalArgumentException("Invalid timestamp: Invalid trailing data \"" + timestamp.substring(timezoneOffsetPosition) + "\"");
                }
            } else {
                String offsetValue = timestamp.substring(timezoneOffsetPosition + 1);
                long offset = BundleSerializer.decodeTimezoneOffset(offsetValue);
                seconds = timestamp.charAt(timezoneOffsetPosition) == '+' ? (seconds -= offset) : (seconds += offset);
            }
            return new Timestamp(seconds, nanos);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse timestamp", e);
        }
    }

    private Timestamp decodeTimestamp(Object timestamp) throws JSONException {
        if (timestamp instanceof String) {
            return this.decodeTimestamp((String)timestamp);
        }
        if (!(timestamp instanceof JSONObject)) {
            throw new IllegalArgumentException("Timestamps must be either ISO 8601-formatted strings or JSON objects");
        }
        return this.decodeTimestamp((JSONObject)timestamp);
    }

    private void decodeTimestamp(Value.Builder builder, Object timestamp) throws JSONException {
        Timestamp decoded = this.decodeTimestamp(timestamp);
        builder.setTimestampValue(com.google.protobuf.Timestamp.newBuilder().setSeconds(decoded.getSeconds()).setNanos(decoded.getNanoseconds()));
    }

    private static int parseNanos(String value) {
        int result = 0;
        for (int i = 0; i < 9; ++i) {
            result *= 10;
            if (i >= value.length()) continue;
            if (value.charAt(i) < '0' || value.charAt(i) > '9') {
                throw new IllegalArgumentException("Invalid nanoseconds: " + value);
            }
            result += value.charAt(i) - 48;
        }
        return result;
    }

    private static long decodeTimezoneOffset(String value) {
        int pos = value.indexOf(58);
        if (pos == -1) {
            throw new IllegalArgumentException("Invalid offset value: " + value);
        }
        String hours = value.substring(0, pos);
        String minutes = value.substring(pos + 1);
        return (Long.parseLong(hours) * 60L + Long.parseLong(minutes)) * 60L;
    }

    private Filter.Operator decodeFieldFilterOperator(String operator) {
        return Filter.Operator.valueOf(operator);
    }

    private void decodeUnaryFilter(List<Filter> result, JSONObject unaryFilter) throws JSONException {
        String operator;
        FieldPath fieldPath = this.decodeFieldReference(unaryFilter.getJSONObject("field"));
        String string = operator = unaryFilter.getString("op");
        int n = -1;
        switch (string.hashCode()) {
            case -2125479834: {
                if (!string.equals("IS_NAN")) break;
                n = 0;
                break;
            }
            case -1465346180: {
                if (!string.equals("IS_NULL")) break;
                n = 1;
                break;
            }
            case -244195494: {
                if (!string.equals("IS_NOT_NAN")) break;
                n = 2;
                break;
            }
            case 1019893512: {
                if (!string.equals("IS_NOT_NULL")) break;
                n = 3;
            }
        }
        switch (n) {
            case 0: {
                result.add(FieldFilter.create(fieldPath, Filter.Operator.EQUAL, Values.NAN_VALUE));
                break;
            }
            case 1: {
                result.add(FieldFilter.create(fieldPath, Filter.Operator.EQUAL, Values.NULL_VALUE));
                break;
            }
            case 2: {
                result.add(FieldFilter.create(fieldPath, Filter.Operator.NOT_EQUAL, Values.NAN_VALUE));
                break;
            }
            case 3: {
                result.add(FieldFilter.create(fieldPath, Filter.Operator.NOT_EQUAL, Values.NULL_VALUE));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected unary filter: " + operator);
            }
        }
    }

    private FieldPath decodeFieldReference(JSONObject fieldReference) throws JSONException {
        return FieldPath.fromServerFormat(fieldReference.getString("fieldPath"));
    }

    private Query.LimitType decodeLimitType(JSONObject bundledQuery) {
        String limitType = bundledQuery.optString("limitType", "FIRST");
        if (limitType.equals("FIRST")) {
            return Query.LimitType.LIMIT_TO_FIRST;
        }
        if (limitType.equals("LAST")) {
            return Query.LimitType.LIMIT_TO_LAST;
        }
        throw new IllegalArgumentException("Invalid limit type for bundle query: " + limitType);
    }

    private void verifyCollectionSelector(JSONArray from) {
        if (from.length() != 1) {
            throw new IllegalArgumentException("Only queries with a single 'from' clause are supported by the Android SDK");
        }
    }

    private void verifyNoOffset(JSONObject structuredQuery) {
        if (structuredQuery.has("offset")) {
            throw new IllegalArgumentException("Queries with offsets are not supported by the Android SDK");
        }
    }

    private void verifyNoSelect(JSONObject structuredQuery) {
        if (structuredQuery.has("select")) {
            throw new IllegalArgumentException("Queries with 'select' statements are not supported by the Android SDK");
        }
    }
}

