/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;

public class OrderBy {
    private final Direction direction;
    final FieldPath field;

    public static OrderBy getInstance(Direction direction, FieldPath path) {
        return new OrderBy(direction, path);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public FieldPath getField() {
        return this.field;
    }

    private OrderBy(Direction direction, FieldPath field) {
        this.direction = direction;
        this.field = field;
    }

    int compare(Document d1, Document d2) {
        if (this.field.equals(FieldPath.KEY_PATH)) {
            return this.direction.getComparisonModifier() * d1.getKey().compareTo(d2.getKey());
        }
        Value v1 = d1.getField(this.field);
        Value v2 = d2.getField(this.field);
        Assert.hardAssert(v1 != null && v2 != null, "Trying to compare documents on fields that don't exist.", new Object[0]);
        return this.direction.getComparisonModifier() * Values.compare(v1, v2);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)o;
        return this.direction == other.direction && this.field.equals(other.field);
    }

    public int hashCode() {
        int result = 29;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public String toString() {
        return (this.direction == Direction.ASCENDING ? "" : "-") + this.field.canonicalString();
    }

    public static enum Direction {
        ASCENDING(1),
        DESCENDING(-1);

        private final int comparisonModifier;

        private Direction(int comparisonModifier) {
            this.comparisonModifier = comparisonModifier;
        }

        int getComparisonModifier() {
            return this.comparisonModifier;
        }
    }
}

