/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PatchMutation
extends Mutation {
    private final ObjectValue value;
    private final FieldMask mask;

    public PatchMutation(DocumentKey key, ObjectValue value, FieldMask mask, Precondition precondition) {
        this(key, value, mask, precondition, new ArrayList<FieldTransform>());
    }

    public PatchMutation(DocumentKey key, ObjectValue value, FieldMask mask, Precondition precondition, List<FieldTransform> fieldTransforms) {
        super(key, precondition, fieldTransforms);
        this.value = value;
        this.mask = mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchMutation that = (PatchMutation)o;
        return this.hasSameKeyAndPrecondition(that) && this.value.equals(that.value) && this.getFieldTransforms().equals(that.getFieldTransforms());
    }

    public int hashCode() {
        int result = this.keyAndPreconditionHashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "PatchMutation{" + this.keyAndPreconditionToString() + ", mask=" + this.mask + ", value=" + this.value + "}";
    }

    public ObjectValue getValue() {
        return this.value;
    }

    public FieldMask getMask() {
        return this.mask;
    }

    @Override
    public void applyToRemoteDocument(MutableDocument document, MutationResult mutationResult) {
        this.verifyKeyMatches(document);
        if (!this.getPrecondition().isValidFor(document)) {
            document.convertToUnknownDocument(mutationResult.getVersion());
            return;
        }
        Map<FieldPath, Value> transformResults = this.serverTransformResults(document, mutationResult.getTransformResults());
        ObjectValue value = document.getData();
        value.setAll(this.getPatch());
        value.setAll(transformResults);
        document.convertToFoundDocument(mutationResult.getVersion(), document.getData()).setHasCommittedMutations();
    }

    @Override
    public void applyToLocalView(MutableDocument document, Timestamp localWriteTime) {
        this.verifyKeyMatches(document);
        if (!this.getPrecondition().isValidFor(document)) {
            return;
        }
        Map<FieldPath, Value> transformResults = this.localTransformResults(localWriteTime, document);
        ObjectValue value = document.getData();
        value.setAll(this.getPatch());
        value.setAll(transformResults);
        document.convertToFoundDocument(PatchMutation.getPostMutationVersion(document), document.getData()).setHasLocalMutations();
    }

    private Map<FieldPath, Value> getPatch() {
        HashMap<FieldPath, Value> result = new HashMap<FieldPath, Value>();
        for (FieldPath path : this.mask.getMask()) {
            if (path.isEmpty()) continue;
            result.put(path, this.value.get(path));
        }
        return result;
    }
}

