/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.SyncEngine;
import com.google.firebase.firestore.local.GarbageCollectionScheduler;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.remote.ConnectivityMonitor;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.RemoteStore;
import com.google.firebase.firestore.util.AsyncQueue;

public abstract class ComponentProvider {
    private Persistence persistence;
    private LocalStore localStore;
    private SyncEngine syncEngine;
    private RemoteStore remoteStore;
    private EventManager eventManager;
    private ConnectivityMonitor connectityMonitor;
    @Nullable
    private GarbageCollectionScheduler gargabeCollectionScheduler;

    public Persistence getPersistence() {
        return this.persistence;
    }

    @Nullable
    public GarbageCollectionScheduler getGargabeCollectionScheduler() {
        return this.gargabeCollectionScheduler;
    }

    public LocalStore getLocalStore() {
        return this.localStore;
    }

    public SyncEngine getSyncEngine() {
        return this.syncEngine;
    }

    public RemoteStore getRemoteStore() {
        return this.remoteStore;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    protected ConnectivityMonitor getConnectivityMonitor() {
        return this.connectityMonitor;
    }

    public void initialize(Configuration configuration) {
        this.persistence = this.createPersistence(configuration);
        this.persistence.start();
        this.localStore = this.createLocalStore(configuration);
        this.connectityMonitor = this.createConnectivityMonitor(configuration);
        this.remoteStore = this.createRemoteStore(configuration);
        this.syncEngine = this.createSyncEngine(configuration);
        this.eventManager = this.createEventManager(configuration);
        this.localStore.start();
        this.remoteStore.start();
        this.gargabeCollectionScheduler = this.createGarbageCollectionScheduler(configuration);
    }

    protected abstract GarbageCollectionScheduler createGarbageCollectionScheduler(Configuration var1);

    protected abstract EventManager createEventManager(Configuration var1);

    protected abstract LocalStore createLocalStore(Configuration var1);

    protected abstract ConnectivityMonitor createConnectivityMonitor(Configuration var1);

    protected abstract Persistence createPersistence(Configuration var1);

    protected abstract RemoteStore createRemoteStore(Configuration var1);

    protected abstract SyncEngine createSyncEngine(Configuration var1);

    public static class Configuration {
        private final Context context;
        private final AsyncQueue asyncQueue;
        private final DatabaseInfo databaseInfo;
        private final Datastore datastore;
        private final User initialUser;
        private final int maxConcurrentLimboResolutions;
        private final FirebaseFirestoreSettings settings;

        public Configuration(Context context, AsyncQueue asyncQueue, DatabaseInfo databaseInfo, Datastore datastore, User initialUser, int maxConcurrentLimboResolutions, FirebaseFirestoreSettings settings) {
            this.context = context;
            this.asyncQueue = asyncQueue;
            this.databaseInfo = databaseInfo;
            this.datastore = datastore;
            this.initialUser = initialUser;
            this.maxConcurrentLimboResolutions = maxConcurrentLimboResolutions;
            this.settings = settings;
        }

        FirebaseFirestoreSettings getSettings() {
            return this.settings;
        }

        AsyncQueue getAsyncQueue() {
            return this.asyncQueue;
        }

        DatabaseInfo getDatabaseInfo() {
            return this.databaseInfo;
        }

        Datastore getDatastore() {
            return this.datastore;
        }

        User getInitialUser() {
            return this.initialUser;
        }

        int getMaxConcurrentLimboResolutions() {
            return this.maxConcurrentLimboResolutions;
        }

        Context getContext() {
            return this.context;
        }
    }
}

